/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details.orm;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.common.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.SequenceGenerator;
import org.eclipse.jpt.jpa.core.context.TableGenerator;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.jpa.ui.internal.details.GeneratorComposite;
import org.eclipse.jpt.jpa.ui.internal.details.SequenceGeneratorComposite;
import org.eclipse.jpt.jpa.ui.internal.details.TableGeneratorComposite;
import org.eclipse.jpt.jpa.ui.internal.details.orm.AddGeneratorDialog;
import org.eclipse.jpt.jpa.ui.internal.details.orm.JptUiDetailsOrmMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMappingsGeneratorsComposite
extends Pane<EntityMappings> {
    private ModifiablePropertyValueModel<OrmGenerator> generatorHolder;
    GeneratorComposite<SequenceGenerator> sequenceGeneratorPane;
    TableGeneratorComposite tableGeneratorPane;
    private AddRemoveListPane<EntityMappings> listPane;

    public EntityMappingsGeneratorsComposite(Pane<? extends EntityMappings> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    void addGenerator(ObjectListSelectionModel listSelectionModel) {
        this.addGeneratorFromDialog(listSelectionModel, this.buildAddGeneratorDialog());
    }

    protected AddGeneratorDialog buildAddGeneratorDialog() {
        return new AddGeneratorDialog(this.getShell(), ((EntityMappings)this.getSubject()).getPersistenceUnit());
    }

    protected void addGeneratorFromDialog(ObjectListSelectionModel listSelectionModel, AddGeneratorDialog dialog) {
        OrmTableGenerator generator;
        if (dialog.open() != 0) {
            return;
        }
        String generatorType = dialog.getGeneratorType();
        if (generatorType == "tableGenerator") {
            generator = ((EntityMappings)this.getSubject()).addTableGenerator();
        } else if (generatorType == "sequenceGenerator") {
            generator = ((EntityMappings)this.getSubject()).addSequenceGenerator();
        } else {
            throw new IllegalArgumentException();
        }
        generator.setName(dialog.getName());
        this.generatorHolder.setValue((Object)generator);
        listSelectionModel.setSelectedValue((Object)generator);
    }

    private ListValueModel<OrmGenerator> buildDisplayableGeneratorListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildGeneratorsListHolder(), new String[]{"name"});
    }

    private AddRemovePane.Adapter buildGeneratorAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                EntityMappingsGeneratorsComposite.this.addGenerator(listSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof OrmSequenceGenerator) {
                        ((EntityMappings)EntityMappingsGeneratorsComposite.this.getSubject()).removeSequenceGenerator((OrmSequenceGenerator)item);
                    } else {
                        ((EntityMappings)EntityMappingsGeneratorsComposite.this.getSubject()).removeTableGenerator((OrmTableGenerator)item);
                    }
                    ++n2;
                }
            }
        };
    }

    private ModifiablePropertyValueModel<OrmGenerator> buildGeneratorHolder() {
        return new SimplePropertyValueModel();
    }

    private ILabelProvider buildGeneratorLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                OrmGenerator generator = (OrmGenerator)element;
                String name = generator.getName();
                if (name == null) {
                    int index = -1;
                    index = generator instanceof OrmSequenceGenerator ? CollectionTools.indexOf((Iterable)((EntityMappings)EntityMappingsGeneratorsComposite.this.getSubject()).getSequenceGenerators(), (Object)generator) : CollectionTools.indexOf((Iterable)((EntityMappings)EntityMappingsGeneratorsComposite.this.getSubject()).getTableGenerators(), (Object)generator);
                    name = NLS.bind((String)JptUiDetailsOrmMessages.OrmGeneratorsComposite_displayString, (Object)index);
                }
                return name;
            }
        };
    }

    private ListValueModel<OrmGenerator> buildGeneratorsListHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildSequenceGeneratorListHolder());
        list.add(this.buildTableGeneratorListHolder());
        return new CompositeListValueModel(list);
    }

    private PropertyValueModel<Boolean> buildPaneEnablerHolder() {
        return new TransformationPropertyValueModel<EntityMappings, Boolean>(this.getSubjectHolder()){

            protected Boolean transform(EntityMappings value) {
                return value != null;
            }
        };
    }

    private Transformer<OrmGenerator, Control> buildPaneTransformer() {
        return new Transformer<OrmGenerator, Control>(){

            public Control transform(OrmGenerator generator) {
                if (generator == null) {
                    return null;
                }
                if (generator instanceof OrmSequenceGenerator) {
                    return EntityMappingsGeneratorsComposite.this.sequenceGeneratorPane.getControl();
                }
                return EntityMappingsGeneratorsComposite.this.tableGeneratorPane.getControl();
            }
        };
    }

    private PropertyValueModel<SequenceGenerator> buildSequenceGeneratorHolder() {
        return new TransformationPropertyValueModel<OrmGenerator, SequenceGenerator>(this.generatorHolder){

            protected SequenceGenerator transform_(OrmGenerator value) {
                return value instanceof SequenceGenerator ? (SequenceGenerator)value : null;
            }
        };
    }

    private ListValueModel<OrmSequenceGenerator> buildSequenceGeneratorListHolder() {
        return new ListAspectAdapter<EntityMappings, OrmSequenceGenerator>(this.getSubjectHolder(), new String[]{"sequenceGenerators"}){

            protected ListIterable<OrmSequenceGenerator> getListIterable() {
                return ((EntityMappings)this.subject).getSequenceGenerators();
            }

            protected int size_() {
                return ((EntityMappings)this.subject).getSequenceGeneratorsSize();
            }
        };
    }

    private PropertyValueModel<TableGenerator> buildTableGeneratorHolder() {
        return new TransformationPropertyValueModel<OrmGenerator, TableGenerator>(this.generatorHolder){

            protected TableGenerator transform_(OrmGenerator value) {
                return value instanceof TableGenerator ? (TableGenerator)value : null;
            }
        };
    }

    private ListValueModel<OrmTableGenerator> buildTableGeneratorListHolder() {
        return new ListAspectAdapter<EntityMappings, OrmTableGenerator>(this.getSubjectHolder(), new String[]{"tableGenerators"}){

            protected ListIterable<OrmTableGenerator> getListIterable() {
                return ((EntityMappings)this.subject).getTableGenerators();
            }

            protected int size_() {
                return ((EntityMappings)this.subject).getTableGeneratorsSize();
            }
        };
    }

    protected void initialize() {
        super.initialize();
        this.generatorHolder = this.buildGeneratorHolder();
    }

    protected void initializeLayout(Composite container) {
        container = this.addCollapsibleSection(container, JptUiDetailsOrmMessages.OrmGeneratorsComposite_groupBox);
        this.listPane = this.addListPane(container);
        this.installPaneEnabler();
        PropertyValueModel<SequenceGenerator> sequenceGeneratorHolder = this.buildSequenceGeneratorHolder();
        PropertyValueModel<TableGenerator> tableGeneratorHolder = this.buildTableGeneratorHolder();
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.sequenceGeneratorPane = this.buildSequenceGeneratorComposite((Composite)pageBook, sequenceGeneratorHolder, this.buildSequenceGeneratorBuilder());
        this.tableGeneratorPane = new TableGeneratorComposite((Pane<?>)this, tableGeneratorHolder, (Composite)pageBook, this.buildTableGeneratorBuilder());
        this.addAlignRight(this.sequenceGeneratorPane);
        this.addAlignRight(this.tableGeneratorPane);
        this.installPaneSwitcher(pageBook);
    }

    protected GeneratorComposite<SequenceGenerator> buildSequenceGeneratorComposite(Composite parent, PropertyValueModel<SequenceGenerator> sequenceGeneratorHolder, GeneratorComposite.GeneratorBuilder<SequenceGenerator> generatorBuilder) {
        return new SequenceGeneratorComposite((Pane<?>)this, sequenceGeneratorHolder, parent, generatorBuilder);
    }

    private AddRemoveListPane<EntityMappings> addListPane(Composite container) {
        return new AddRemoveListPane((Pane)this, container, this.buildGeneratorAdapter(), this.buildDisplayableGeneratorListHolder(), this.generatorHolder, this.buildGeneratorLabelProvider());
    }

    private void installPaneEnabler() {
        new PaneEnabler(this.buildPaneEnablerHolder(), this.listPane);
    }

    private void installPaneSwitcher(PageBook pageBook) {
        new ControlSwitcher(this.generatorHolder, this.buildPaneTransformer(), pageBook);
    }

    private GeneratorComposite.GeneratorBuilder<SequenceGenerator> buildSequenceGeneratorBuilder() {
        return new GeneratorComposite.GeneratorBuilder<SequenceGenerator>(){

            @Override
            public SequenceGenerator addGenerator() {
                throw new UnsupportedOperationException("The sequence generator will never be null so we do not need to implement this");
            }
        };
    }

    private GeneratorComposite.GeneratorBuilder<TableGenerator> buildTableGeneratorBuilder() {
        return new GeneratorComposite.GeneratorBuilder<TableGenerator>(){

            @Override
            public TableGenerator addGenerator() {
                throw new UnsupportedOperationException("The table generator will never be null so we do not need to implement this");
            }
        };
    }
}

