/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.persistence.details;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.persistence.JptUiPersistenceMessages;
import org.eclipse.jpt.jpa.ui.internal.persistence.details.ArchiveFileSelectionDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceUnitJarFilesComposite
extends Pane<PersistenceUnit> {
    private ModifiablePropertyValueModel<JarFileRef> selectedItemHolder;

    public PersistenceUnitJarFilesComposite(Pane<? extends PersistenceUnit> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    protected void initialize() {
        super.initialize();
        this.selectedItemHolder = this.buildSelectedItemHolder();
    }

    protected void initializeLayout(Composite container) {
        this.addJarFilesList(container);
    }

    protected void addJarFilesList(Composite container) {
        new AddRemoveListPane<PersistenceUnit>((Pane)this, container, this.buildAdapter(), this.buildItemListHolder(), this.selectedItemHolder, this.buildLabelProvider(), "org.eclipse.jpt.jpa.ui.persistence_general"){

            protected Composite addContainer(Composite parent) {
                parent = super.addContainer(parent);
                PersistenceUnitJarFilesComposite.this.updateGridData(parent);
                return parent;
            }

            protected void initializeLayout(Composite container) {
                super.initializeLayout(container);
                PersistenceUnitJarFilesComposite.this.updateGridData(this.getContainer());
            }
        };
    }

    private void updateGridData(Composite container) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        container.setLayoutData((Object)gridData);
    }

    private AddRemovePane.Adapter buildAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                PersistenceUnitJarFilesComposite.this.addJarFileRef();
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    ((PersistenceUnit)PersistenceUnitJarFilesComposite.this.getSubject()).removeJarFileRef((JarFileRef)item);
                    ++n2;
                }
            }
        };
    }

    private ListValueModel<JarFileRef> buildItemListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildListHolder(), new String[]{"fileName"});
    }

    private ListValueModel<JarFileRef> buildListHolder() {
        return new ListAspectAdapter<PersistenceUnit, JarFileRef>(this.getSubjectHolder(), new String[]{"jarFileRefs"}){

            protected ListIterable<JarFileRef> getListIterable() {
                return ((PersistenceUnit)this.subject).getJarFileRefs();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).getJarFileRefsSize();
            }
        };
    }

    private ModifiablePropertyValueModel<JarFileRef> buildSelectedItemHolder() {
        return new SimplePropertyValueModel();
    }

    private ILabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return JptJpaUiPlugin.getImage("full/obj16/jpa-jar-file");
            }

            public String getText(Object element) {
                JarFileRef jarFileRef = (JarFileRef)element;
                String name = jarFileRef.getFileName();
                if (name == null) {
                    name = JptUiPersistenceMessages.PersistenceUnitJarFilesComposite_noFileName;
                }
                return name;
            }
        };
    }

    private void addJarFileRef() {
        IProject project = ((PersistenceUnit)this.getSubject()).getJpaProject().getProject();
        ArchiveFileSelectionDialog dialog = new ArchiveFileSelectionDialog(this.getShell(), this.buildJarFileDeploymentPathCalculator());
        dialog.setHelpAvailable(false);
        dialog.setTitle(JptUiPersistenceMessages.PersistenceUnitMappingFilesComposite_jarFileDialog_title);
        dialog.setMessage(JptUiPersistenceMessages.PersistenceUnitMappingFilesComposite_jarFileDialog_message);
        dialog.setInput(project);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                String filePath = (String)result;
                if (!this.jarFileRefExists(filePath)) {
                    JarFileRef jarFileRef = ((PersistenceUnit)this.getSubject()).addJarFileRef(filePath);
                    this.selectedItemHolder.setValue((Object)jarFileRef);
                }
                ++n2;
            }
        }
    }

    protected ArchiveFileSelectionDialog.DeploymentPathCalculator buildJarFileDeploymentPathCalculator() {
        return new ArchiveFileSelectionDialog.ModuleDeploymentPathCalculator();
    }

    private boolean jarFileRefExists(String fileName) {
        for (JarFileRef each : ((PersistenceUnit)this.getSubject()).getJarFileRefs()) {
            if (!each.getFileName().equals(fileName)) continue;
            return true;
        }
        return false;
    }
}

