/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.platform.base;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.jface.ItemTreeStateProviderFactoryProvider;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.JpaPlatformUiProvider;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.MappingResourceUiDefinition;
import org.eclipse.jpt.jpa.ui.ResourceUiDefinition;
import org.eclipse.jpt.jpa.ui.details.DefaultMappingUiDefinition;
import org.eclipse.jpt.jpa.ui.details.JpaComposite;
import org.eclipse.jpt.jpa.ui.details.JpaDetailsPageManager;
import org.eclipse.jpt.jpa.ui.details.JpaDetailsProvider;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;
import org.eclipse.jpt.jpa.ui.internal.platform.base.EntitiesGenerator;
import org.eclipse.jpt.jpa.ui.internal.wizards.conversion.java.JavaMetadataConversionWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.conversion.java.JavaMetadataConversionWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaPlatformUi
implements JpaPlatformUi {
    private final ItemTreeStateProviderFactoryProvider navigatorFactoryProvider;
    private final JpaPlatformUiProvider platformUiProvider;

    protected AbstractJpaPlatformUi(ItemTreeStateProviderFactoryProvider navigatorFactoryProvider, JpaPlatformUiProvider platformUiProvider) {
        if (navigatorFactoryProvider == null || platformUiProvider == null) {
            throw new NullPointerException();
        }
        this.navigatorFactoryProvider = navigatorFactoryProvider;
        this.platformUiProvider = platformUiProvider;
    }

    @Override
    public ItemTreeStateProviderFactoryProvider getNavigatorFactoryProvider() {
        return this.navigatorFactoryProvider;
    }

    @Override
    public ItemTreeStateProviderFactoryProvider getStructureViewFactoryProvider(JpaFile jpaFile) {
        JptResourceType resourceType = jpaFile.getResourceModel().getResourceType();
        return resourceType == null ? null : this.getStructureViewFactoryProvider(resourceType);
    }

    protected ItemTreeStateProviderFactoryProvider getStructureViewFactoryProvider(JptResourceType resourceType) {
        try {
            return this.getResourceUiDefinition(resourceType).getStructureViewFactoryProvider();
        }
        catch (IllegalArgumentException iae) {
            JptJpaUiPlugin.log(iae);
            return null;
        }
    }

    @Override
    public JpaDetailsPageManager<? extends JpaStructureNode> buildJpaDetailsPageManager(Composite parent, JpaStructureNode structureNode, WidgetFactory widgetFactory) {
        JpaDetailsProvider jpaDetailsProvider = this.getDetailsProvider(structureNode);
        return jpaDetailsProvider == null ? null : jpaDetailsProvider.buildDetailsPageManager(parent, widgetFactory);
    }

    protected JpaDetailsProvider getDetailsProvider(JpaStructureNode structureNode) {
        for (JpaDetailsProvider provider : CollectionTools.iterable(this.detailsProviders())) {
            if (!provider.providesDetails(structureNode)) continue;
            return provider;
        }
        return null;
    }

    protected ListIterator<JpaDetailsProvider> detailsProviders() {
        return this.platformUiProvider.detailsProviders();
    }

    @Override
    public JpaComposite buildTypeMappingComposite(JptResourceType resourceType, String mappingKey, Composite parent, PropertyValueModel<TypeMapping> mappingHolder, WidgetFactory widgetFactory) {
        return this.getMappingResourceUiDefinition(resourceType).buildTypeMappingComposite(mappingKey, mappingHolder, parent, widgetFactory);
    }

    @Override
    public JpaComposite buildAttributeMappingComposite(JptResourceType resourceType, String mappingKey, Composite parent, PropertyValueModel<AttributeMapping> mappingHolder, WidgetFactory widgetFactory) {
        return this.getMappingResourceUiDefinition(resourceType).buildAttributeMappingComposite(mappingKey, mappingHolder, parent, widgetFactory);
    }

    @Override
    public DefaultMappingUiDefinition<ReadOnlyPersistentAttribute, ? extends AttributeMapping> getDefaultAttributeMappingUiDefinition(JptResourceType resourceType, String mappingKey) {
        return this.getMappingResourceUiDefinition(resourceType).getDefaultAttributeMappingUiDefinition(mappingKey);
    }

    @Override
    public Iterator<MappingUiDefinition<ReadOnlyPersistentAttribute, ? extends AttributeMapping>> attributeMappingUiDefinitions(JptResourceType resourceType) {
        return this.getMappingResourceUiDefinition(resourceType).attributeMappingUiDefinitions();
    }

    @Override
    public DefaultMappingUiDefinition<PersistentType, ? extends TypeMapping> getDefaultTypeMappingUiDefinition(JptResourceType resourceType) {
        return this.getMappingResourceUiDefinition(resourceType).getDefaultTypeMappingUiDefinition();
    }

    @Override
    public Iterator<MappingUiDefinition<PersistentType, ? extends TypeMapping>> typeMappingUiDefinitions(JptResourceType resourceType) {
        return this.getMappingResourceUiDefinition(resourceType).typeMappingUiDefinitions();
    }

    protected ListIterator<ResourceUiDefinition> resourceUiDefinitions() {
        return this.platformUiProvider.resourceUiDefinitions();
    }

    @Override
    public ResourceUiDefinition getResourceUiDefinition(JptResourceType resourceType) {
        for (ResourceUiDefinition definition : CollectionTools.iterable(this.resourceUiDefinitions())) {
            if (!definition.providesUi(resourceType)) continue;
            return definition;
        }
        throw new IllegalArgumentException("No resource UI definition for the resource type: " + resourceType);
    }

    public MappingResourceUiDefinition getMappingResourceUiDefinition(JptResourceType resourceType) {
        ResourceUiDefinition def = this.getResourceUiDefinition(resourceType);
        try {
            return (MappingResourceUiDefinition)def;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("No mapping resource UI definition for the resource type: " + resourceType, cce);
        }
    }

    @Override
    public void generateEntities(JpaProject project, IStructuredSelection selection) {
        EntitiesGenerator.generate(project, selection);
    }

    protected void displayMessage(String title, String message) {
        MessageDialog.openInformation((Shell)SWTUtil.getShell(), (String)title, (String)message);
    }

    protected void openInDialog(JavaMetadataConversionWizardPage wizardPage) {
        this.openInDialog((IWizard)new JavaMetadataConversionWizard(wizardPage));
    }

    protected void openInDialog(IWizard wizard) {
        new SizedWizardDialog(wizard).open();
    }

    public class SizedWizardDialog
    extends WizardDialog {
        private final int width;
        private final int height;

        public SizedWizardDialog(IWizard wizard) {
            this(wizard, 520, 460);
        }

        public SizedWizardDialog(IWizard wizard, int width, int height) {
            this(SWTUtil.getShell(), wizard, width, height);
        }

        public SizedWizardDialog(Shell shell, IWizard wizard, int width, int height) {
            super(shell, wizard);
            this.width = width;
            this.height = height;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setSize(this.width, this.height);
            SWTUtil.center((Shell)shell, (Shell)this.getParentShell());
        }
    }
}

