/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.platform.generic;

import org.eclipse.jpt.common.ui.internal.jface.StaticItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProviderFactory;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.JavaPersistentTypeItemContentProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.OrmPersistentTypeItemContentProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.OrmXmlItemContentProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.PersistenceUnitItemContentProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.PersistenceXmlItemContentProvider;

public class GenericNavigatorItemContentProviderFactory
implements ItemTreeContentProviderFactory {
    private static final ItemTreeContentProviderFactory INSTANCE = new GenericNavigatorItemContentProviderFactory();

    public static ItemTreeContentProviderFactory instance() {
        return INSTANCE;
    }

    protected GenericNavigatorItemContentProviderFactory() {
    }

    public ItemTreeContentProvider buildProvider(Object item, ItemTreeContentProvider.Manager manager) {
        if (item instanceof PersistenceXml) {
            return this.buildPersistenceXmlProvider((PersistenceXml)item, manager);
        }
        if (item instanceof PersistenceUnit) {
            return this.buildPersistenceUnitProvider((PersistenceUnit)item, manager);
        }
        if (item instanceof OrmXml) {
            return this.buildOrmXmlProvider((OrmXml)item, manager);
        }
        if (item instanceof OrmPersistentType) {
            return this.buildOrmPersistentTypeProvider((OrmPersistentType)item, manager);
        }
        if (item instanceof JavaPersistentType) {
            return this.buildJavaPersistentTypeProvider((JavaPersistentType)item, manager);
        }
        if (item instanceof PersistentAttribute) {
            return this.buildPersistentAttributeProvider((PersistentAttribute)item, manager);
        }
        return null;
    }

    protected ItemTreeContentProvider buildPersistenceXmlProvider(PersistenceXml item, ItemTreeContentProvider.Manager manager) {
        return new PersistenceXmlItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildPersistenceUnitProvider(PersistenceUnit item, ItemTreeContentProvider.Manager manager) {
        return new PersistenceUnitItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildOrmXmlProvider(OrmXml item, ItemTreeContentProvider.Manager manager) {
        return new OrmXmlItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildOrmPersistentTypeProvider(OrmPersistentType item, ItemTreeContentProvider.Manager manager) {
        return new OrmPersistentTypeItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildJavaPersistentTypeProvider(JavaPersistentType item, ItemTreeContentProvider.Manager manager) {
        return new JavaPersistentTypeItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildPersistentAttributeProvider(PersistentAttribute item, ItemTreeContentProvider.Manager manager) {
        return new StaticItemTreeContentProvider((Object)item.getParent());
    }
}

