/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.selection;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jpt.common.ui.internal.utility.PartAdapter2;
import org.eclipse.jpt.common.utility.internal.AbstractTransformer;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.model.value.DoubleModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.DoublePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaWindowManager;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaWorkbenchManager;
import org.eclipse.jpt.jpa.ui.selection.JpaEditorManager;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.jpt.jpa.ui.selection.JpaViewManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JpaPageManager
implements JpaSelectionManager,
JpaViewManager.PageManager {
    private final JpaWindowManager windowManager;
    private final IWorkbenchPage page;
    private final HashMap<IEditorPart, JpaEditorManager> editorManagers = new HashMap();
    private final SimplePropertyValueModel<JpaEditorManager> editorManagerModel = new SimplePropertyValueModel();
    private final PropertyValueModel<JpaFile> jpaFileModel;
    private final ModifiablePropertyValueModel<JpaStructureNode> jpaSelectionModel;
    private final IPartListener2 partListener = new PartListener();
    private final HashSet<JpaViewManager> viewManagers = new HashSet();
    private volatile boolean disposed = false;
    private static final Transformer<JpaEditorManager, PropertyValueModel<JpaFile>> JPA_FILE_MODEL_TRANSFORMER = new JpaFileModelTransformer();
    private static final Transformer<JpaEditorManager, ModifiablePropertyValueModel<JpaStructureNode>> JPA_SELECTION_MODEL_TRANSFORMER = new JpaSelectionModelTransformer();

    JpaPageManager(JpaWindowManager windowManager, IWorkbenchPage page) {
        if (page == null) {
            throw new NullPointerException();
        }
        this.windowManager = windowManager;
        this.page = page;
        this.jpaFileModel = this.buildJpaFileModel();
        this.jpaSelectionModel = this.buildJpaSelectionModel();
        this.page.addPartListener(this.partListener);
        this.updateEditorManagerModel();
    }

    @Override
    public PropertyValueModel<JpaFile> getJpaFileModel() {
        return this.jpaFileModel;
    }

    private PropertyValueModel<JpaFile> buildJpaFileModel() {
        return new DoublePropertyValueModel(this.buildEditorManagerJpaFileModel());
    }

    private PropertyValueModel<PropertyValueModel<JpaFile>> buildEditorManagerJpaFileModel() {
        return new TransformationPropertyValueModel(this.editorManagerModel, JPA_FILE_MODEL_TRANSFORMER);
    }

    @Override
    public ModifiablePropertyValueModel<JpaStructureNode> getJpaSelectionModel() {
        return this.jpaSelectionModel;
    }

    private ModifiablePropertyValueModel<JpaStructureNode> buildJpaSelectionModel() {
        return new DoubleModifiablePropertyValueModel(this.buildEditorManagerJpaSelectionModel());
    }

    private PropertyValueModel<ModifiablePropertyValueModel<JpaStructureNode>> buildEditorManagerJpaSelectionModel() {
        return new TransformationPropertyValueModel(this.editorManagerModel, JPA_SELECTION_MODEL_TRANSFORMER);
    }

    @Override
    public void setSelection(JpaStructureNode selection) {
        this.jpaSelectionModel.setValue((Object)selection);
    }

    @Override
    public JpaEditorManager getEditorManager(IEditorPart editor) {
        return editor == null ? null : this.getEditorManager_(editor);
    }

    private synchronized JpaEditorManager getEditorManager_(IEditorPart editor) {
        JpaEditorManager editorManager = this.editorManagers.get(editor);
        if (editorManager == null && (editorManager = this.buildEditorManager(editor)) != null) {
            JpaWorkbenchManager.debug("add editor manager:", editor);
            this.editorManagers.put(editor, editorManager);
        }
        return editorManager;
    }

    private JpaEditorManager buildEditorManager(IEditorPart editor) {
        return (JpaEditorManager)editor.getAdapter(JpaEditorManager.class);
    }

    @Override
    public synchronized void addViewManager(JpaViewManager viewManager) {
        JpaWorkbenchManager.debug("add view manager:", viewManager);
        if (this.disposed) {
            throw new IllegalStateException("page manager is disposed: " + this);
        }
        if (!this.viewManagers.add(viewManager)) {
            throw new IllegalArgumentException("duplicate view manager: " + viewManager);
        }
    }

    @Override
    public synchronized void removeViewManager(JpaViewManager viewManager) {
        JpaWorkbenchManager.debug("remove view manager:", viewManager);
        if (!this.viewManagers.remove(viewManager)) {
            throw new IllegalArgumentException("missing view manager: " + viewManager);
        }
        if (this.viewManagers.isEmpty()) {
            this.dispose();
        }
    }

    private void dispose() {
        this.disposed = true;
        this.page.removePartListener(this.partListener);
        for (JpaEditorManager editorManager : this.editorManagers.values()) {
            editorManager.dispose();
        }
        this.windowManager.removePageManager(this.page);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.page);
    }

    synchronized void partClosed(IWorkbenchPart part) {
        JpaEditorManager editorManager = this.editorManagers.remove(part);
        if (editorManager != null) {
            JpaWorkbenchManager.debug("removed editor manager:", part);
            editorManager.dispose();
        }
        this.updateEditorManagerModel();
    }

    void updateEditorManagerModel() {
        this.editorManagerModel.setValue((Object)this.getEditorManager(this.page.getActiveEditor()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaFileModelTransformer
    extends AbstractTransformer<JpaEditorManager, PropertyValueModel<JpaFile>> {
        JpaFileModelTransformer() {
        }

        public PropertyValueModel<JpaFile> transform_(JpaEditorManager editorManager) {
            return editorManager.getJpaFileModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaSelectionModelTransformer
    extends AbstractTransformer<JpaEditorManager, ModifiablePropertyValueModel<JpaStructureNode>> {
        JpaSelectionModelTransformer() {
        }

        public ModifiablePropertyValueModel<JpaStructureNode> transform_(JpaEditorManager editorManager) {
            return editorManager.getJpaSelectionModel();
        }
    }

    class PartListener
    extends PartAdapter2 {
        PartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            JpaPageManager.this.updateEditorManagerModel();
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
            JpaPageManager.this.updateEditorManagerModel();
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                JpaPageManager.this.partClosed(part);
            }
        }
    }
}

