/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.selection;

import java.util.Hashtable;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaPageManager;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaWorkbenchManager;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

class JpaWindowManager
implements JpaSelectionManager {
    private final JpaWorkbenchManager workbenchManager;
    private final IWorkbenchWindow window;
    private final Hashtable<IWorkbenchPage, JpaPageManager> pageManagers = new Hashtable();

    JpaWindowManager(JpaWorkbenchManager workbenchManager, IWorkbenchWindow window) {
        if (window == null) {
            throw new NullPointerException();
        }
        this.workbenchManager = workbenchManager;
        this.window = window;
    }

    public void setSelection(JpaStructureNode selection) {
        this.getPageManager(this.window.getActivePage()).setSelection(selection);
    }

    private JpaSelectionManager getPageManager(IWorkbenchPage page) {
        return page == null ? JpaSelectionManager.Null.instance() : this.getPageManager_(page);
    }

    private JpaSelectionManager getPageManager_(IWorkbenchPage page) {
        JpaPageManager manager = this.pageManagers.get(page);
        return manager == null ? JpaSelectionManager.Null.instance() : manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JpaPageManager getPageManager(IViewPart view) {
        IWorkbenchPage page = view.getSite().getPage();
        Hashtable<IWorkbenchPage, JpaPageManager> hashtable = this.pageManagers;
        synchronized (hashtable) {
            JpaPageManager manager = this.pageManagers.get(page);
            if (manager == null) {
                JpaWorkbenchManager.debug("add page manager:", page);
                manager = new JpaPageManager(this, page);
                this.pageManagers.put(page, manager);
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePageManager(IWorkbenchPage page) {
        Hashtable<IWorkbenchPage, JpaPageManager> hashtable = this.pageManagers;
        synchronized (hashtable) {
            JpaWorkbenchManager.debug("remove page manager:", page);
            this.pageManagers.remove(page);
            if (this.pageManagers.isEmpty()) {
                this.dispose();
            }
        }
    }

    private void dispose() {
        this.workbenchManager.removeWindowManager(this.window);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.window);
    }
}

