/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.structure;

import org.eclipse.jpt.common.ui.internal.jface.StaticItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProviderFactory;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.JavaPersistentTypeItemContentProvider;
import org.eclipse.jpt.jpa.ui.internal.structure.JpaFileItemContentProvider;

public class JavaStructureItemContentProviderFactory
implements ItemTreeContentProviderFactory {
    private static final ItemTreeContentProviderFactory INSTANCE = new JavaStructureItemContentProviderFactory();

    public static ItemTreeContentProviderFactory instance() {
        return INSTANCE;
    }

    protected JavaStructureItemContentProviderFactory() {
    }

    public ItemTreeContentProvider buildProvider(Object item, ItemTreeContentProvider.Manager manager) {
        if (item instanceof JpaFile) {
            return this.buildJpaFileProvider((JpaFile)item, manager);
        }
        if (item instanceof JavaPersistentType) {
            return this.buildJavaPersistentTypeProvider((JavaPersistentType)item, manager);
        }
        if (item instanceof JavaPersistentAttribute) {
            return this.buildJavaPersistentAttributeProvider((JavaPersistentAttribute)item, manager);
        }
        return null;
    }

    protected ItemTreeContentProvider buildJpaFileProvider(JpaFile item, ItemTreeContentProvider.Manager manager) {
        return new JpaFileItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildJavaPersistentTypeProvider(JavaPersistentType item, ItemTreeContentProvider.Manager manager) {
        return new JavaPersistentTypeItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildJavaPersistentAttributeProvider(JavaPersistentAttribute item, ItemTreeContentProvider.Manager manager) {
        return new StaticItemTreeContentProvider((Object)item.getParent());
    }
}

