/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.java.OwnableRelationshipMappingAnnotation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RenameEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.GraphicsUpdater;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPASolver;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public abstract class RefactorEntityFeature
extends AbstractCustomFeature {
    protected JavaPersistentType jpt = null;
    protected Set<JavaPersistentAttribute> ats = null;
    protected boolean hasNameAnnotation = false;

    public RefactorEntityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean isAvailable(IContext context) {
        if (!(context instanceof ICustomContext)) {
            return false;
        }
        ICustomContext ctx = (ICustomContext)context;
        PictogramElement pe = ctx.getInnerPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo instanceof JavaPersistentType) {
            this.jpt = (JavaPersistentType)bo;
            this.hasNameAnnotation = JpaArtifactFactory.instance().hasNameAnnotation(this.jpt);
            return true;
        }
        if (pe instanceof Shape) {
            ContainerShape cs = ((Shape)pe).getContainer();
            if (cs == null) {
                return false;
            }
            bo = this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)cs);
            if (bo instanceof JavaPersistentType) {
                this.jpt = (JavaPersistentType)bo;
                this.hasNameAnnotation = JpaArtifactFactory.instance().hasNameAnnotation(this.jpt);
                return true;
            }
        }
        return false;
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public void execute(ICustomContext context, SelectionDispatchAction action, ICompilationUnit cu) {
        StructuredSelection sel = new StructuredSelection((Object)cu);
        final Shape pict = (Shape)this.getFeatureProvider().getPictogramElementForBusinessObject(this.jpt);
        final JavaPersistentType jpt = (JavaPersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)pict);
        final PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(jpt);
        Semaphore s = new Semaphore(0);
        final JPAProjectListener lsnr = new JPAProjectListener(s);
        jpt.getJpaProject().addCollectionChangeListener("jpaFiles", (CollectionChangeListener)lsnr);
        ShowBusy showBusy = new ShowBusy(s);
        JPASolver.ignoreEvents = true;
        try {
            action.run((IStructuredSelection)sel);
        }
        catch (Exception exception) {}
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)showBusy);
        jpt.getJpaProject().removeCollectionChangeListener("jpaFiles", (CollectionChangeListener)lsnr);
        JPASolver.ignoreEvents = false;
        final boolean rename = RenameEntityFeature.class.isInstance((Object)this);
        if (!showBusy.isMoved()) {
            return;
        }
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)pict);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                RefactorEntityFeature.remapEntity(jpt, pict, pu, rename, lsnr, RefactorEntityFeature.this.getFeatureProvider());
            }
        });
    }

    public void execute(ICustomContext context, String newName, ICompilationUnit cu, JavaPersistentType originalJPT) {
        final Shape pict = (Shape)this.getFeatureProvider().getPictogramElementForBusinessObject(originalJPT);
        final JavaPersistentType jpt = (JavaPersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)pict);
        final PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(jpt);
        Semaphore s = new Semaphore(0);
        final JPAProjectListener lsnr = new JPAProjectListener(s);
        jpt.getJpaProject().addCollectionChangeListener("jpaFiles", (CollectionChangeListener)lsnr);
        ShowBusy showBusy = new ShowBusy(s);
        JPASolver.ignoreEvents = true;
        JpaArtifactFactory.instance().renameEntityClass(jpt, newName, this.getFeatureProvider());
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)showBusy);
        jpt.getJpaProject().removeCollectionChangeListener("jpaFiles", (CollectionChangeListener)lsnr);
        JPASolver.ignoreEvents = false;
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)pict);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                RefactorEntityFeature.remapEntity(jpt, pict, pu, true, lsnr, RefactorEntityFeature.this.getFeatureProvider());
            }
        });
    }

    public static void remapEntity(final JavaPersistentType oldJPT, final Shape pict, final PersistenceUnit pu, final boolean rename, final JPAProjectListener lsnr, final IJPAEditorFeatureProvider fp) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                fp.getDiagramTypeProvider().getDiagramEditor().selectPictogramElements(new PictogramElement[0]);
                String newJPTName = lsnr.getNewJPTName();
                JavaPersistentType newJPT = JpaArtifactFactory.instance().getJPT(newJPTName, pu);
                if (newJPT == null) {
                    return;
                }
                if (!JptJpaCorePlugin.getDiscoverAnnotatedClasses((IProject)newJPT.getJpaProject().getProject())) {
                    JPAEditorUtil.createUnregisterEntityFromXMLJob(newJPT.getJpaProject(), oldJPT.getName());
                    JPAEditorUtil.createRegisterEntityInXMLJob(newJPT.getJpaProject(), newJPTName);
                }
                if (rename) {
                    String tableName = JPAEditorUtil.formTableName(newJPT);
                    JpaArtifactFactory.instance().setTableName(newJPT, tableName);
                }
                GraphicsUpdater.updateHeader((ContainerShape)pict, newJPT.getSimpleName());
                this.linkNewElement(oldJPT, (PictogramElement)pict, fp, newJPT);
                for (JavaPersistentAttribute oldAttr : oldJPT.getAttributes()) {
                    PictogramElement attrPict = fp.getPictogramElementForBusinessObject(oldAttr);
                    if (attrPict == null) continue;
                    for (JavaPersistentAttribute newAttr : newJPT.getAttributes()) {
                        if (!newAttr.getName().equals(oldAttr.getName())) continue;
                        this.linkNewElement(oldAttr, attrPict, fp, newAttr);
                    }
                }
                fp.getDiagramTypeProvider().getDiagramEditor().setPictogramElementForSelection((PictogramElement)pict);
                IWorkbenchPartSite ws = ((IEditorPart)fp.getDiagramTypeProvider().getDiagramEditor()).getSite();
                ICompilationUnit cu = fp.getCompilationUnit(newJPT);
                fp.getJPAEditorUtil().formatCode(cu, (IWorkbenchSite)ws);
            }

            private void linkNewElement(Object oldBO, PictogramElement pict2, IJPAEditorFeatureProvider fp2, Object newBO) {
                String newBoKey;
                fp2.link((PictogramElement)((ContainerShape)pict2), newBO);
                LayoutContext context = new LayoutContext((PictogramElement)((ContainerShape)pict2));
                fp2.layoutIfPossible((ILayoutContext)context);
                String oldBoKey = fp2.getKeyForBusinessObject(oldBO);
                if (oldBoKey != null) {
                    fp2.remove(oldBoKey);
                }
                if (fp2.getBusinessObjectForKey(newBoKey = fp2.getKeyForBusinessObject(newBO)) == null) {
                    fp2.putKeyToBusinessObject(newBoKey, newBO);
                }
            }
        });
    }

    protected Diagram getDiagram() {
        return this.getFeatureProvider().getDiagramTypeProvider().getDiagram();
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public class JPAProjectListener
    implements CollectionChangeListener {
        private Semaphore s = null;
        private String newJptName = null;

        public JPAProjectListener(Semaphore s) {
            this.s = s;
        }

        public void itemsAdded(CollectionAddEvent event) {
            Iterator it = event.getItems().iterator();
            Object o = it.next();
            JpaFile jpaFile = (JpaFile)o;
            JptResourceModel rm = jpaFile.getResourceModel();
            if (rm == null) {
                return;
            }
            if (!JavaResourceCompilationUnit.class.isInstance(rm)) {
                return;
            }
            JavaResourceCompilationUnit jrcu = (JavaResourceCompilationUnit)rm;
            JavaResourceAbstractType jrt = jrcu.getPrimaryType();
            this.newJptName = jrt.getQualifiedName();
            this.s.release();
            if (RefactorEntityFeature.this.ats == null || RefactorEntityFeature.this.hasNameAnnotation) {
                return;
            }
            final Iterator<JavaPersistentAttribute> iter = RefactorEntityFeature.this.ats.iterator();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Hashtable<String, String> atOldToNewName = new Hashtable<String, String>();
                    HashSet<JavaPersistentAttribute> newSelfAts = new HashSet<JavaPersistentAttribute>();
                    while (iter.hasNext()) {
                        JavaPersistentAttribute at = (JavaPersistentAttribute)iter.next();
                        ICompilationUnit cu = RefactorEntityFeature.this.getFeatureProvider().getCompilationUnit((JavaPersistentType)at.getParent());
                        if (!cu.exists()) {
                            at = (JavaPersistentAttribute)at.getPersistenceUnit().getPersistentType(JPAProjectListener.this.newJptName).getAttributeNamed(at.getName());
                            JavaPersistentAttribute newAt = null;
                            try {
                                newAt = JpaArtifactFactory.instance().renameAttribute(at, JPAEditorUtil.returnSimpleName(JPAProjectListener.this.newJptName), JPAProjectListener.this.newJptName, RefactorEntityFeature.this.getFeatureProvider());
                            }
                            catch (InterruptedException e) {
                                JPADiagramEditorPlugin.logError(e);
                            }
                            atOldToNewName.put(at.getName(), newAt.getName());
                            newSelfAts.add(newAt);
                            continue;
                        }
                        try {
                            JpaArtifactFactory.instance().renameAttribute(at, JPAEditorUtil.returnSimpleName(JPAProjectListener.this.newJptName), JPAProjectListener.this.newJptName, RefactorEntityFeature.this.getFeatureProvider());
                        }
                        catch (InterruptedException e) {
                            JPADiagramEditorPlugin.logError(e);
                        }
                    }
                    for (JavaPersistentAttribute at : newSelfAts) {
                        String newMappedBy;
                        OwnableRelationshipMappingAnnotation ownableMappingAnnotation;
                        String oldMappedBy;
                        JpaArtifactFactory.instance().refreshEntityModel(null, (JavaPersistentType)at.getParent());
                        JavaAttributeMapping m = at.getMapping();
                        Annotation mappingAnnotation = m.getMappingAnnotation();
                        if (mappingAnnotation == null) {
                            JpaArtifactFactory.instance().refreshEntityModel(RefactorEntityFeature.this.getFeatureProvider(), (JavaPersistentType)at.getParent());
                            mappingAnnotation = m.getMappingAnnotation();
                        }
                        if (mappingAnnotation == null) {
                            return;
                        }
                        if (!OwnableRelationshipMappingAnnotation.class.isInstance(mappingAnnotation) || (oldMappedBy = (ownableMappingAnnotation = (OwnableRelationshipMappingAnnotation)mappingAnnotation).getMappedBy()) == null || (newMappedBy = (String)atOldToNewName.get(oldMappedBy)) == null) continue;
                        ownableMappingAnnotation.setMappedBy(newMappedBy);
                    }
                }
            };
            Display.getDefault().asyncExec(r);
        }

        public void itemsRemoved(CollectionRemoveEvent arg0) {
            this.s.release();
        }

        public void collectionChanged(CollectionChangeEvent event) {
        }

        public void collectionCleared(CollectionClearEvent arg0) {
        }

        public String getNewJPTName() {
            return this.newJptName;
        }
    }

    class ShowBusy
    implements Runnable {
        private Semaphore s;
        boolean moved = false;

        ShowBusy(Semaphore s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                this.moved = this.s.tryAcquire(2, 4L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Thread interrupted", e);
            }
        }

        boolean isMoved() {
            return this.moved;
        }
    }
}

