/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.IModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.JPAEditorDiagramTypeProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPADiagramEditorInput;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;

public class JPAEditorMatchingStrategy
implements IEditorMatchingStrategy {
    private IJPAEditorFeatureProvider fp = null;
    private static final String CODE_GENERATED = "CODE_GENERATED";
    public static final String DOUBLE_CLICK = "DOUBLE_CLICK";

    public JPAEditorMatchingStrategy() {
    }

    public JPAEditorMatchingStrategy(IJPAEditorFeatureProvider fp) {
        this.fp = fp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            IJPAEditorFeatureProvider featureProvider;
            block13: {
                JPAEditorDiagramTypeProvider diagramProvider;
                JavaPersistentType inputJptType;
                block12: {
                    IFileEditorInput fileInput = (IFileEditorInput)input;
                    IFile entityFile = fileInput.getFile();
                    if (!entityFile.getName().endsWith(".java")) {
                        return false;
                    }
                    try {
                        QualifiedName qn = new QualifiedName(null, DOUBLE_CLICK);
                        if ("true".equals(entityFile.getSessionProperty(qn))) {
                            entityFile.setSessionProperty(qn, null);
                            return false;
                        }
                    }
                    catch (CoreException e1) {
                        JPADiagramEditorPlugin.logError("Cannot get session property DOUBLE_CLICK", e1);
                    }
                    inputJptType = null;
                    inputJptType = this.fp == null ? JPAEditorUtil.getJPType(JavaCore.createCompilationUnitFrom((IFile)entityFile)) : this.fp.getJPAEditorUtil().getJPType(JavaCore.createCompilationUnitFrom((IFile)entityFile));
                    if (inputJptType == null) {
                        return false;
                    }
                    PersistenceUnit persistenceUnit = inputJptType.getPersistenceUnit();
                    JpaProject jpaProject = persistenceUnit.getJpaProject();
                    try {
                        IJPADiagramEditorInput jpInput;
                        Diagram diagram;
                        IEditorInput editorInput = editorRef.getEditorInput();
                        if (!(editorInput instanceof IJPADiagramEditorInput) || (diagram = (jpInput = (IJPADiagramEditorInput)editorInput).getDiagram()) == null) return false;
                        featureProvider = null;
                        diagramProvider = null;
                        if (this.fp != null) {
                            featureProvider = this.fp;
                            diagramProvider = featureProvider.getDiagramTypeProvider();
                        } else {
                            diagramProvider = ModelIntegrationUtil.getProviderByDiagram(diagram.getName());
                            featureProvider = (IJPAEditorFeatureProvider)diagramProvider.getFeatureProvider();
                        }
                        IModelIntegrationUtil moinIntegrationUtil = featureProvider.getMoinIntegrationUtil();
                        JpaProject jpaProjectFromEditor = moinIntegrationUtil.getProjectByDiagram(diagram);
                        if (!jpaProject.equals(jpaProjectFromEditor)) return false;
                        if (fileInput.getName() == CODE_GENERATED) break block12;
                        return false;
                    }
                    catch (PartInitException e) {
                        JPADiagramEditorPlugin.getDefault().getLog().log(e.getStatus());
                        return false;
                    }
                }
                PictogramElement pe = featureProvider.getPictogramElementForBusinessObject(inputJptType);
                if (pe == null) break block13;
                diagramProvider.getDiagramEditor().setPictogramElementForSelection(pe);
                return true;
            }
            ICustomFeature feature = featureProvider.getAddAllEntitiesFeature();
            CustomContext context = new CustomContext();
            feature.execute((ICustomContext)context);
            return true;
        }
        if (!(input instanceof IJPADiagramEditorInput)) return false;
        return editorRef.getPartName().equals(((IJPADiagramEditorInput)input).getProjectName());
    }
}

