/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.gui;

import java.awt.GraphicsEnvironment;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.eclipse.jubula.tools.i18n.I18n;

public class ManualTestStepOptionPane
extends JOptionPane {
    private static final String DIALOG_TITLE = I18n.getString((String)"Cap.ManualTestStepDialogTitle");
    private static final int MAX_CHAR_PER_LINE_COUNT = 75;
    private static final Object[] DIALOG_EXIT_OPTIONS = new Object[]{StepStatus.Passed, StepStatus.Failed};
    private static final String LINE_BREAK = "\n";

    public ManualTestStepOptionPane(Object message, int messageType, int optiontype, Icon icon, Object[] dialogExitOptions, Object defaultexit) {
        super(message, messageType, optiontype, icon, dialogExitOptions, defaultexit);
    }

    public static ManualTestStepResult showDialog(String actionToPerform, String expectedBehavior, int timeout) {
        if (GraphicsEnvironment.isHeadless()) {
            return new ManualTestStepResult("Test step has been skipped due to headless running mode", false);
        }
        StringBuilder message = new StringBuilder();
        message.append("Manual action to perform: ");
        message.append(LINE_BREAK);
        message.append(actionToPerform);
        message.append(LINE_BREAK).append(LINE_BREAK);
        message.append("Expected Behavior: ");
        message.append(LINE_BREAK);
        message.append(expectedBehavior);
        message.append(LINE_BREAK).append(LINE_BREAK);
        message.append("Comment: ");
        return ManualTestStepOptionPane.showManualTestStepDialog(message, timeout);
    }

    private static ManualTestStepResult showManualTestStepDialog(StringBuilder message, int timeout) {
        JFrame parentComponent = new JFrame();
        int messageType = 3;
        ManualTestStepOptionPane pane = new ManualTestStepOptionPane(message, messageType, 2, null, DIALOG_EXIT_OPTIONS, null);
        pane.setWantsInput(true);
        pane.setComponentOrientation((parentComponent == null ? ManualTestStepOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        final JDialog dialog = pane.createDialog(DIALOG_TITLE);
        pane.selectInitialValue();
        Timer closeDialog = new Timer();
        closeDialog.schedule(new TimerTask(){

            @Override
            public void run() {
                dialog.setVisible(false);
            }
        }, timeout);
        dialog.setVisible(true);
        closeDialog.cancel();
        Object inputValue = pane.getInputValue();
        Object value = pane.getValue();
        dialog.dispose();
        if (inputValue instanceof String && value instanceof StepStatus) {
            return new ManualTestStepResult((String)inputValue, (StepStatus)((Object)value) == StepStatus.Passed);
        }
        return new ManualTestStepResult("timeout occured", false);
    }

    @Override
    public int getMaxCharactersPerLineCount() {
        return 75;
    }

    public static class ManualTestStepResult {
        private String m_comment = null;
        private boolean m_successful = false;

        public ManualTestStepResult(String comment, boolean success) {
            this.setComment(comment);
            this.setSuccessful(success);
        }

        private void setComment(String comment) {
            this.m_comment = comment;
        }

        public String getComment() {
            return this.m_comment;
        }

        private void setSuccessful(boolean successful) {
            this.m_successful = successful;
        }

        public boolean isSuccessful() {
            return this.m_successful;
        }
    }

    private static enum StepStatus {
        Passed,
        Failed;

    }
}

