/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze.ui.internal.listener;

import java.util.Map;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jubula.client.analyze.internal.Analyze;
import org.eclipse.jubula.client.analyze.internal.AnalyzeResult;
import org.eclipse.jubula.client.analyze.internal.Renderer;
import org.eclipse.jubula.client.analyze.internal.helper.RendererSelectionHelper;
import org.eclipse.jubula.client.analyze.ui.internal.QueryResult;
import org.eclipse.jubula.client.analyze.ui.internal.definition.IResultRendererUI;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;

public class AnalyzeTreeViewerDoubleClickListener
implements IDoubleClickListener {
    private String m_resultType;
    private IResultRendererUI m_chosenRenderer;
    private final Composite m_comp;

    public AnalyzeTreeViewerDoubleClickListener(Composite composite) {
        this.m_comp = composite;
    }

    public IResultRendererUI getChosenRenderer() {
        return this.m_chosenRenderer;
    }

    public void setChosenRenderer(IResultRendererUI renderer) {
        this.m_chosenRenderer = renderer;
    }

    public String getResultType() {
        return this.m_resultType;
    }

    public void doubleClick(DoubleClickEvent event) {
        QueryResult qr = (QueryResult)event.getViewer().getInput();
        TreeSelection selection = (TreeSelection)event.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof Analyze) {
            Analyze analyze = (Analyze)firstElement;
            AnalyzeResult result = null;
            for (Map.Entry<Analyze, AnalyzeResult> a : qr.getResultMap().entrySet()) {
                if (!analyze.getID().equals(a.getKey().getID())) continue;
                result = a.getValue();
            }
            Renderer ren = RendererSelectionHelper.getActiveRenderer((Analyze)analyze);
            IResultRendererUI rendererUI = (IResultRendererUI)ren.getRendererInstance();
            this.setChosenRenderer(rendererUI);
            rendererUI.renderResult(result, this.m_comp);
            if (this.m_comp.getLayout() instanceof StackLayout) {
                StackLayout sl = (StackLayout)this.m_comp.getLayout();
                sl.topControl = rendererUI.getTopControl();
                this.m_comp.layout();
            }
        }
    }
}

