/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.gef.inspector;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jubula.rc.rcp.gef.factory.DefaultEditPartAdapterFactory;
import org.eclipse.jubula.rc.rcp.gef.identifier.IEditPartIdentifier;
import org.eclipse.jubula.rc.rcp.gef.util.FigureCanvasUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class FigureHighlighter
implements MouseMoveListener {
    private GraphicalViewer m_viewer;
    private Color m_highlightColor;
    private int m_highlightAlpha;
    private org.eclipse.swt.graphics.Rectangle m_currentBounds;
    private PaintListener m_paintListener;

    public FigureHighlighter(GraphicalViewer viewer) {
        this.m_viewer = viewer;
        this.m_highlightColor = viewer.getControl().getDisplay().getSystemColor(9);
        this.m_highlightAlpha = 100;
        this.m_currentBounds = null;
        this.m_paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (FigureHighlighter.this.m_currentBounds != null) {
                    Color bgColor = e.gc.getBackground();
                    int alpha = e.gc.getAlpha();
                    e.gc.setAlpha(FigureHighlighter.this.m_highlightAlpha);
                    e.gc.setBackground(FigureHighlighter.this.m_highlightColor);
                    e.gc.fillRectangle(FigureHighlighter.this.m_currentBounds);
                    e.gc.setAlpha(alpha);
                    e.gc.setBackground(bgColor);
                }
            }
        };
        viewer.getControl().addPaintListener(this.m_paintListener);
    }

    public void mouseMove(MouseEvent e) {
        org.eclipse.swt.graphics.Rectangle bounds;
        Point cursorLocation = new Point(e.x, e.y);
        EditPart editPart = FigureCanvasUtil.findAtCurrentMousePosition(e.display, (EditPartViewer)this.m_viewer);
        if (editPart == this.m_viewer.getContents().getRoot() || editPart == null) {
            if (this.m_currentBounds != null) {
                this.m_currentBounds = null;
                this.m_viewer.getControl().redraw();
            }
            return;
        }
        org.eclipse.swt.graphics.Rectangle anchorBounds = this.getConnectionAnchorBounds(DefaultEditPartAdapterFactory.loadFigureIdentifier(editPart), cursorLocation);
        if (anchorBounds == null && editPart instanceof ConnectionEditPart) {
            ConnectionEditPart connEditPart = (ConnectionEditPart)editPart;
            EditPart srcEditPart = connEditPart.getSource();
            EditPart targetEditPart = connEditPart.getTarget();
            anchorBounds = this.getConnectionAnchorBounds(DefaultEditPartAdapterFactory.loadFigureIdentifier(srcEditPart), cursorLocation);
            if (anchorBounds == null) {
                anchorBounds = this.getConnectionAnchorBounds(DefaultEditPartAdapterFactory.loadFigureIdentifier(targetEditPart), cursorLocation);
            }
        }
        if ((bounds = anchorBounds) == null && editPart != this.m_viewer.getContents().getRoot() && !(editPart instanceof ConnectionEditPart) && editPart instanceof GraphicalEditPart) {
            IFigure figure = ((GraphicalEditPart)editPart).getFigure();
            Rectangle figureBounds = new Rectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)figureBounds);
            bounds = new org.eclipse.swt.graphics.Rectangle(figureBounds.x, figureBounds.y, figureBounds.width, figureBounds.height);
        }
        this.m_currentBounds = bounds;
        this.m_viewer.getControl().redraw();
    }

    private org.eclipse.swt.graphics.Rectangle getConnectionAnchorBounds(IEditPartIdentifier editPartIdentifier, Point cursorLocation) {
        Map anchorMap;
        if (editPartIdentifier != null && (anchorMap = editPartIdentifier.getConnectionAnchors()) != null) {
            Iterator iter = anchorMap.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Object value = anchorMap.get(key);
                if (!(key instanceof String) || !(value instanceof ConnectionAnchor)) continue;
                Point refPoint = ((ConnectionAnchor)value).getReferencePoint();
                org.eclipse.swt.graphics.Rectangle refBounds = new org.eclipse.swt.graphics.Rectangle(refPoint.x - 3, refPoint.y - 3, 7, 7);
                if (!refBounds.contains(cursorLocation.getSWTPoint())) continue;
                return refBounds;
            }
        }
        return null;
    }

    public void removeAddedListeners() {
        Control control = this.m_viewer.getControl();
        if (!control.isDisposed()) {
            control.removePaintListener(this.m_paintListener);
            control.redraw();
        }
    }
}

