/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.implclasses;

import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.swing.swing.implclasses.AbstractSwingImplClass;
import org.eclipse.jubula.rc.swing.swing.interfaces.IJTabbedPaneImplClass;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class JTabbedPaneImplClass
extends AbstractSwingImplClass
implements IJTabbedPaneImplClass {
    private JTabbedPane m_pane;

    public void setComponent(Object graphicsComponent) {
        this.m_pane = (JTabbedPane)graphicsComponent;
    }

    public JComponent getComponent() {
        return this.m_pane;
    }

    private int getIndexOfTab(final String title, final String operator) {
        int index = (Integer)this.getEventThreadQueuer().invokeAndWait("indexOfTab", new IRunnable(){

            public Object run() throws StepExecutionException {
                int tabs = JTabbedPaneImplClass.this.m_pane.getTabCount();
                int a = 0;
                while (a < tabs) {
                    if (MatchUtil.getInstance().match(JTabbedPaneImplClass.this.m_pane.getTitleAt(a), title, operator)) {
                        return new Integer(a);
                    }
                    ++a;
                }
                return new Integer(-1);
            }
        });
        if (index == -1) {
            throw new StepExecutionException("Can not find tab: '" + title + "' using operator: '" + operator + "'", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        return index;
    }

    private void selectTabByImplIndex(int index) {
        this.verifyIndexExists(index);
        this.getRobot().click((Object)this.m_pane, (Object)this.getBoundsAt(index), ClickOptions.create().left(), 25, false, 50, false);
    }

    private Rectangle getBoundsAt(final int index) {
        return (Rectangle)this.getEventThreadQueuer().invokeAndWait("getBoundsAt", new IRunnable(){

            public Object run() throws StepExecutionException {
                return JTabbedPaneImplClass.this.m_pane.getBoundsAt(index);
            }
        });
    }

    private void verifyIndexExists(final int index) throws StepExecutionException {
        Boolean exists = (Boolean)this.getEventThreadQueuer().invokeAndWait("indexOfTab", new IRunnable(){

            public Object run() throws StepExecutionException {
                int i = JTabbedPaneImplClass.this.m_pane.getTabCount();
                return index >= 0 && index < i ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        if (!exists.booleanValue()) {
            throw new StepExecutionException("The tab index doesn't exist: " + index, EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
    }

    public void gdSelectTabByIndex(int index) throws StepExecutionException {
        int implIdx = IndexConverter.toImplementationIndex((int)index);
        this.selectTabByImplIndex(implIdx);
    }

    public void gdSelectTab(String title, String operator) throws StepExecutionException {
        this.selectTabByImplIndex(this.getIndexOfTab(title, operator));
    }

    public void gdVerifySelectedTabByIndex(int index, boolean selected) throws StepExecutionException {
        int implIdx = IndexConverter.toImplementationIndex((int)index);
        int selIndex = (Integer)this.getEventThreadQueuer().invokeAndWait("getSelectedIndex", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(JTabbedPaneImplClass.this.m_pane.getSelectedIndex());
            }
        });
        if (selIndex == -1) {
            if (!selected) {
                return;
            }
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoSelection"), EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        Verifier.equals((boolean)selected, (selIndex == implIdx ? 1 : 0) != 0);
    }

    public void gdVerifySelectedTab(String tabTitlePattern, String operator, boolean selected) throws StepExecutionException {
        String selectedTabTitle = (String)this.getEventThreadQueuer().invokeAndWait("getSelectedTitle", new IRunnable(){

            public Object run() throws StepExecutionException {
                int selectedIndex = JTabbedPaneImplClass.this.m_pane.getSelectedIndex();
                if (selectedIndex == -1) {
                    return null;
                }
                return JTabbedPaneImplClass.this.m_pane.getTitleAt(selectedIndex);
            }
        });
        if (selectedTabTitle == null) {
            if (!selected) {
                return;
            }
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoSelection"), EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        Verifier.match((String)selectedTabTitle, (String)tabTitlePattern, (String)operator, (boolean)selected);
    }

    public void gdVerifyEnabled(String title, String operator, boolean isEnabled) throws StepExecutionException {
        final int tabIndex = this.getIndexOfTab(title, operator);
        this.verify(isEnabled, "isEnabledAt", new IRunnable(){

            public Object run() throws StepExecutionException {
                return JTabbedPaneImplClass.this.m_pane.isEnabledAt(tabIndex) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void gdVerifyEnabledByIndex(int index, boolean enabled) throws StepExecutionException {
        final int implIdx = IndexConverter.toImplementationIndex((int)index);
        this.verifyIndexExists(implIdx);
        this.verify(enabled, "isEnabledAt", new IRunnable(){

            public Object run() throws StepExecutionException {
                return JTabbedPaneImplClass.this.m_pane.isEnabledAt(implIdx) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void gdVerifyTextOfTabByIndex(int index, String text, String operator) throws StepExecutionException {
        final int tabIndex = IndexConverter.toImplementationIndex((int)index);
        String tabTitle = (String)this.getEventThreadQueuer().invokeAndWait("verifyTextOfTabByIndex", new IRunnable(){

            public Object run() throws StepExecutionException {
                JTabbedPaneImplClass.this.checkTabIndex(tabIndex, JTabbedPaneImplClass.this.m_pane.getTabCount());
                return JTabbedPaneImplClass.this.m_pane.getTitleAt(tabIndex);
            }
        });
        Verifier.match((String)tabTitle, (String)text, (String)operator);
    }

    public void gdVerifyExistenceOfTab(String tab, String operator, boolean exists) throws StepExecutionException {
        final int tabIdx = this.getTabIndexFromString(tab, operator);
        Boolean tabExists = (Boolean)this.getEventThreadQueuer().invokeAndWait("verifyExistenceOfTab", new IRunnable(){

            public Object run() throws StepExecutionException {
                if (tabIdx < 0 || tabIdx >= JTabbedPaneImplClass.this.m_pane.getTabCount()) {
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
        });
        Verifier.equals((boolean)exists, (boolean)tabExists);
    }

    /*
     * Unable to fully structure code
     */
    private int getTabIndexFromString(String tab, String operator) {
        block4: {
            tabIndex = -1;
            try {
                tabIndex = IndexConverter.toImplementationIndex((int)Integer.parseInt(tab));
                break block4;
            }
            catch (NumberFormatException v0) {
                i = 0;
                ** while (i < this.m_pane.getTabCount())
            }
lbl-1000:
            // 1 sources

            {
                text = this.m_pane.getTitleAt(i);
                if (MatchUtil.getInstance().match(text, tab, operator)) {
                    return i;
                }
                ++i;
                continue;
            }
        }
        return tabIndex;
    }

    private void checkTabIndex(int index, int count) {
        if (index < 0 || index >= count) {
            throw new StepExecutionException("Invalid Tab Index/Title: " + index, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public String[] getTextArrayFromComponent() {
        String[] componentTextArray = new String[this.m_pane.getTabCount()];
        int i = 0;
        while (i < componentTextArray.length) {
            componentTextArray[i] = this.m_pane.getTitleAt(i);
            ++i;
        }
        return componentTextArray;
    }

    protected String getText() {
        return null;
    }
}

