/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.swt.implclasses.AbstractControlImplClass;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Widget;

public class ListHelper {
    private AbstractControlImplClass m_implClass;

    public ListHelper(AbstractControlImplClass implClass) {
        this.m_implClass = implClass;
    }

    public void clickOnIndex(final org.eclipse.swt.widgets.List list, Integer i, ClickOptions co) {
        final int iVal = i;
        this.scrollIndexToVisible(list, iVal);
        Rectangle clickConstraints = (Rectangle)this.m_implClass.getEventThreadQueuer().invokeAndWait("setClickConstraints", new IRunnable(){

            public Object run() throws StepExecutionException {
                Rectangle constraints = new Rectangle(0, 0, 0, 0);
                int displayedItemCount = ListHelper.this.getDisplayedItemCount(list);
                int numberBelowTop = 0;
                numberBelowTop = displayedItemCount >= list.getItemCount() ? iVal : Math.max(0, iVal - list.getItemCount() + displayedItemCount);
                constraints.height = list.getItemHeight();
                constraints.width = list.getBounds().width;
                constraints.y += numberBelowTop * constraints.height;
                Rectangle actualListBounds = new Rectangle(0, 0, list.getClientArea().width, list.getClientArea().height);
                return constraints.intersection(actualListBounds);
            }
        });
        this.m_implClass.getRobot().click((Object)list, (Object)clickConstraints, co.setScrollToVisible(false));
    }

    public void clickOnIndex(org.eclipse.swt.widgets.List list, Integer i) {
        this.clickOnIndex(list, i, ClickOptions.create().setClickCount(1));
    }

    public Integer[] findIndicesOfValues(final org.eclipse.swt.widgets.List list, final String[] values, final String operator, final String searchType) {
        List indexList = (List)this.m_implClass.getEventThreadQueuer().invokeAndWait("findIndices", new IRunnable(){

            public Object run() {
                int valuesLength = values.length;
                ArrayList<Integer> idxList = new ArrayList<Integer>(values.length);
                int listItemCount = list.getItemCount();
                MatchUtil matchUtil = MatchUtil.getInstance();
                int i = 0;
                while (i < valuesLength) {
                    String value = values[i];
                    int j = ListHelper.this.getStartingIndex(list, searchType);
                    while (j < listItemCount) {
                        String listItem = list.getItem(j);
                        if (matchUtil.match(listItem, value, operator)) {
                            idxList.add(new Integer(j));
                        }
                        ++j;
                    }
                    ++i;
                }
                return idxList;
            }
        });
        Integer[] indices = new Integer[indexList.size()];
        indexList.toArray(indices);
        return indices;
    }

    public boolean containsValue(org.eclipse.swt.widgets.List list, String value) {
        Integer[] indices = this.findIndicesOfValues(list, new String[]{value}, "equals", "absolute");
        return indices.length > 0;
    }

    public boolean containsValue(org.eclipse.swt.widgets.List list, String value, String operator) {
        Integer[] indices = null;
        if (operator.equals("not equals")) {
            indices = this.findIndicesOfValues(list, new String[]{value}, "equals", "absolute");
            return indices.length == 0;
        }
        indices = this.findIndicesOfValues(list, new String[]{value}, operator, "absolute");
        return indices.length > 0;
    }

    public int[] getSelectedIndices(final org.eclipse.swt.widgets.List list) {
        return (int[])this.m_implClass.getEventThreadQueuer().invokeAndWait("getSelectedIndices", new IRunnable(){

            public Object run() {
                return list.getSelectionIndices();
            }
        });
    }

    public String[] getSelectedValues(final org.eclipse.swt.widgets.List list) {
        return (String[])this.m_implClass.getEventThreadQueuer().invokeAndWait("getSelectedValues", new IRunnable(){

            public Object run() {
                return list.getSelection();
            }
        });
    }

    private int getStartingIndex(org.eclipse.swt.widgets.List list, String searchType) {
        int[] selectedIndices;
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative") && (selectedIndices = this.getSelectedIndices(list)).length > 0) {
            startingIndex = selectedIndices[selectedIndices.length - 1] + 1;
        }
        return startingIndex;
    }

    private int getDisplayedItemCount(final org.eclipse.swt.widgets.List list) {
        return (Integer)this.m_implClass.getEventThreadQueuer().invokeAndWait("getDisplayedItemCount", new IRunnable(){

            public Object run() throws StepExecutionException {
                int listHeight = SwtUtils.getWidgetBounds((Widget)list).height;
                int itemHeight = list.getItemHeight();
                return new Integer(listHeight / itemHeight);
            }
        });
    }

    private void scrollIndexToVisible(final org.eclipse.swt.widgets.List list, final int index) {
        this.m_implClass.getEventThreadQueuer().invokeAndWait("scrollIndexToVisible", new IRunnable(){

            public Object run() throws StepExecutionException {
                list.setTopIndex(index);
                return null;
            }
        });
    }
}

