/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.jarutils;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class JarResources {
    private Map m_htSizes = new Hashtable();
    private Map m_htJarContents = new Hashtable();
    private String m_jarFileName;

    public JarResources(String jFileName) {
        this.m_jarFileName = jFileName;
        this.init();
    }

    public byte[] getResource(String name) {
        return (byte[])this.m_htJarContents.get(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() {
        ZipInputStream zis = null;
        try {
            try {
                ZipFile zf = new ZipFile(this.m_jarFileName);
                try {
                    Enumeration<? extends ZipEntry> e = zf.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry ze = e.nextElement();
                        this.m_htSizes.put(ze.getName(), new Integer((int)ze.getSize()));
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    zf.close();
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                }
                zf.close();
                FileInputStream fis = new FileInputStream(this.m_jarFileName);
                BufferedInputStream bis = new BufferedInputStream(fis);
                zis = new ZipInputStream(bis);
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    if (ze.isDirectory()) continue;
                    int size = (int)ze.getSize();
                    if (size == -1) {
                        size = (Integer)this.m_htSizes.get(ze.getName());
                    }
                    byte[] b = new byte[size];
                    int rb = 0;
                    int chunk = 0;
                    while (size - rb > 0 && (chunk = zis.read(b, rb, size - rb)) != -1) {
                        rb += chunk;
                    }
                    this.m_htJarContents.put(ze.getName(), b);
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                if (zis == null) throw throwable;
                zis.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (zis == null) return;
        zis.close();
    }
}

