/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.koneki.ldt.core.LuaUtils;

public final class LuaModuleURIUtil {
    public static final String MODULE_SCHEME = "module";

    private LuaModuleURIUtil() {
    }

    public static URI getModuleURI(ISourceModule module) throws URISyntaxException {
        String moduleFullName = LuaUtils.getModuleFullName((ISourceModule)module);
        return new URI("module:///" + moduleFullName);
    }

    public static Boolean isModuleURI(URI uri) {
        return MODULE_SCHEME.equalsIgnoreCase(uri.getScheme());
    }

    public static String getModuleName(URI uri) {
        String path;
        if (LuaModuleURIUtil.isModuleURI(uri).booleanValue() && (path = uri.getPath()) != null && path.startsWith("/")) {
            return path.substring(1);
        }
        return null;
    }
}

