/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.views;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.text.HTMLPrinter;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.documentation.ScriptDocumentationAccess;
import org.eclipse.dltk.ui.infoviews.AbstractDocumentationView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.koneki.ldt.core.LuaLanguageToolkit;
import org.eclipse.koneki.ldt.ui.Activator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;

public class LuaDocView
extends AbstractDocumentationView {
    private static final long LABEL_FLAGS = ScriptElementLabels.ALL_FULLY_QUALIFIED | 0x20L | 0x4000L | 1L | 2L | 0x10L | 0x200000L;
    private static String fgStyleSheet;
    private RGB fBackgroundColorRGB;

    private static void initStyleSheet() {
        Bundle bundle = Platform.getBundle((String)DLTKUIPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/DocumentationViewStyleSheet.css");
        if (styleSheetURL == null) {
            return;
        }
        try {
            styleSheetURL = FileLocator.toFileURL((URL)styleSheetURL);
            InputStream openStream = styleSheetURL.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(openStream);
            BufferedReader reader = new BufferedReader(inputStreamReader);
            StringBuffer buffer = new StringBuffer(200);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            reader.close();
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.dltk.ui.documentationFont")[0];
            fgStyleSheet = org.eclipse.dltk.ui.text.completion.HTMLPrinter.convertTopLevelFont((String)buffer.toString(), (FontData)fontData);
        }
        catch (IOException ex) {
            DLTKUIPlugin.log((Throwable)ex);
        }
    }

    protected void internalCreatePartControl(Composite parent) {
        super.internalCreatePartControl(parent);
        LuaDocView.initStyleSheet();
    }

    protected void setBackground(Color color) {
        this.fBackgroundColorRGB = color.getRGB();
        super.setBackground(color);
    }

    protected IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected String getNature() {
        return LuaLanguageToolkit.getDefault().getNatureId();
    }

    protected Object computeInput(Object input) {
        if (this.getControl() != null) {
            if (input instanceof IModelElement) {
                IModelElement model = (IModelElement)input;
                String scriptdocHtml = this.getScriptdocHtml(model);
                if (scriptdocHtml == null) {
                    scriptdocHtml = this.getDefaultDocumentation(model);
                }
                return scriptdocHtml;
            }
            return null;
        }
        return null;
    }

    private String getScriptdocHtml(IModelElement modelelement) {
        StringBuffer buffer = new StringBuffer();
        Reader reader = ScriptDocumentationAccess.getHTMLContentReader((String)this.getNature(), (Object)modelelement, (boolean)true, (boolean)true);
        if (reader != null) {
            HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
        }
        return this.addPrologeEpilog(buffer);
    }

    private String getDefaultDocumentation(IModelElement modelElement) {
        if (modelElement instanceof ISourceModule) {
            return this.getDefaultDocumentation((ISourceModule)modelElement);
        }
        if (modelElement instanceof IMember) {
            StringBuffer buffer = new StringBuffer();
            HTMLPrinter.addParagraph((StringBuffer)buffer, (String)this.getInfoText(modelElement));
            HTMLPrinter.addParagraph((StringBuffer)buffer, (String)"<br><em>Note: This element has no attached documentation.</em>");
            return this.addPrologeEpilog(buffer);
        }
        return null;
    }

    private String getDefaultDocumentation(ISourceModule sourcemodule) {
        StringBuffer buffer = new StringBuffer();
        try {
            IModelElement[] children = sourcemodule.getChildren();
            HTMLPrinter.startBulletList((StringBuffer)buffer);
            int i = 0;
            while (i < children.length) {
                IModelElement curr = children[i];
                if (curr instanceof IMember) {
                    IMember member = (IMember)curr;
                    HTMLPrinter.addBullet((StringBuffer)buffer, (String)this.getInfoText(member));
                }
                ++i;
            }
            HTMLPrinter.endBulletList((StringBuffer)buffer);
            HTMLPrinter.addParagraph((StringBuffer)buffer, (String)"<em>Note: This element has no attached documentation.</em>");
        }
        catch (ModelException modelException) {
            return null;
        }
        return this.addPrologeEpilog(buffer);
    }

    private String getInfoText(Object member) {
        if (member instanceof IModelElement) {
            return ScriptElementLabels.getDefault().getElementLabel((IModelElement)member, LABEL_FLAGS);
        }
        return null;
    }

    private String addPrologeEpilog(StringBuffer buffer) {
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (RGB)this.fBackgroundColorRGB, (String)fgStyleSheet);
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return buffer.toString();
        }
        return null;
    }
}

