/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event;

public class CTFCallsite
implements Comparable<CTFCallsite> {
    private static final long MASK32 = 0xFFFFFFFFL;
    private final String EventName;
    private final String FileName;
    private final long ip;
    private final String FunctionName;
    private final long LineNumber;

    public CTFCallsite(String en, String func, long ip, String fn, long line) {
        this.EventName = en;
        this.FileName = fn;
        this.FunctionName = func;
        this.ip = ip;
        this.LineNumber = line;
    }

    public String getEventName() {
        return this.EventName;
    }

    public String getFileName() {
        return this.FileName;
    }

    public long getIp() {
        return this.ip;
    }

    public String getFunctionName() {
        return this.FunctionName;
    }

    public long getLineNumber() {
        return this.LineNumber;
    }

    @Override
    public int compareTo(CTFCallsite o) {
        long other = o.ip;
        long otherHigh = other >> 32 & 0xFFFFFFFFL;
        long otherLow = other & 0xFFFFFFFFL;
        long ownHigh = this.ip >> 32 & 0xFFFFFFFFL;
        long ownLow = this.ip & 0xFFFFFFFFL;
        if (ownHigh > otherHigh) {
            return 1;
        }
        if (ownHigh < otherHigh) {
            return -1;
        }
        if (ownLow > otherLow) {
            return 1;
        }
        if (ownLow < otherLow) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return String.valueOf(this.FileName) + "/" + this.FunctionName + ":" + this.LineNumber;
    }
}

