/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.launch;

import java.net.URI;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.gcov.launch.GcovLaunchPlugin;
import org.eclipse.linuxtools.internal.gcov.launch.GcovLaunchMessages;
import org.eclipse.linuxtools.internal.gcov.parser.CovManager;
import org.eclipse.linuxtools.internal.gcov.view.CovView;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchConfigurationDelegate;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GcovLaunchConfigurationDelegate
extends ProfileLaunchConfigurationDelegate {
    protected ILaunchConfiguration config;

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.config = config;
        IPath exePath = this.getExePath(config);
        IRemoteCommandLauncher launcher = RemoteProxyManager.getInstance().getLauncher(this.getProject());
        URI workingDirURI = this.getProject().getLocationURI();
        Path workingDirPath = new Path(workingDirURI.getPath());
        String[] arguments = this.getProgramArgumentsArray(config);
        ILaunchManager lmgr = DebugPlugin.getDefault().getLaunchManager();
        lmgr.addLaunchListener((ILaunchesListener)new LaunchTerminationWatcher(launch, exePath));
        Process process = launcher.execute(exePath, arguments, this.getEnvironment(config), (IPath)workingDirPath, monitor);
        DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()));
    }

    protected String getPluginID() {
        return GcovLaunchPlugin.getUniqueIdentifier();
    }

    protected IProject getProject() {
        try {
            IProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)this.config).getProject();
            return project;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IPath getExePath(ILaunchConfiguration config) throws CoreException {
        IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
        return exePath;
    }

    public String generateCommand(ILaunchConfiguration config) {
        return "";
    }

    class LaunchTerminationWatcher
    implements ILaunchesListener2 {
        private ILaunch launch;
        private IPath exePath;

        public LaunchTerminationWatcher(ILaunch il, IPath exePath) {
            this.launch = il;
            this.exePath = exePath;
        }

        public void launchesTerminated(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch l = iLaunchArray[n2];
                if (l.equals(this.launch)) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String s = LaunchTerminationWatcher.this.exePath.toOSString();
                            CovManager cvrgeMnger = new CovManager(s, GcovLaunchConfigurationDelegate.this.getProject());
                            try {
                                List gcdaPaths = cvrgeMnger.getGCDALocations();
                                if (gcdaPaths.size() == 0) {
                                    String title = GcovLaunchMessages.GcovCompilerOptions_msg;
                                    String message = GcovLaunchMessages.GcovCompileAgain_msg;
                                    Shell parent = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                                    MessageDialog.openWarning((Shell)parent, (String)title, (String)message);
                                }
                                CovView.displayCovResults((String)s, null);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    });
                }
                ++n2;
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }
    }
}

