/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.ILttControllerService;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.LttControllerServiceProxy;
import org.eclipse.linuxtools.internal.lttng.ui.Activator;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PauseTrace
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private List<TraceResource> fSelectedTraces = new ArrayList<TraceResource>();

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }

    public void run(IAction arg0) {
        int i = 0;
        while (i < this.fSelectedTraces.size()) {
            TraceResource trace = this.fSelectedTraces.get(i);
            TraceSubSystem subSystem = (TraceSubSystem)trace.getSubSystem();
            try {
                LttControllerServiceProxy service = subSystem.getControllerService();
                Boolean cfr_ignored_0 = (Boolean)new TCFTask<Boolean>((ILttControllerService)service, trace){
                    private final /* synthetic */ ILttControllerService val$service;
                    private final /* synthetic */ TraceResource val$trace;
                    {
                        this.val$service = iLttControllerService;
                        this.val$trace = traceResource;
                    }

                    public void run() {
                        this.val$service.pauseTrace(this.val$trace.getParent().getParent().getName(), this.val$trace.getParent().getName(), this.val$trace.getName(), new ILttControllerService.DonePauseTrace(){

                            public void donePauseTrace(IToken token, Exception error, Object str) {
                                if (error != null) {
                                    this.error(error);
                                    return;
                                }
                                this.done(true);
                            }
                        });
                    }
                }.get(10L, TimeUnit.SECONDS);
                trace.setTraceState(TraceResource.TraceState.PAUSED);
                ISystemRegistry registry = SystemStartHere.getSystemRegistry();
                registry.fireRemoteResourceChangeEvent(4, (Object)trace, (Object)trace.getParent(), (ISubSystem)subSystem, null);
            }
            catch (Exception e) {
                SystemMessageException sysExp = e instanceof SystemMessageException ? (SystemMessageException)((Object)e) : new SystemMessageException(Activator.getDefault().getMessage(e));
                SystemBasePlugin.logError((String)(String.valueOf(Messages.Lttng_Control_ErrorPause) + " (" + Messages.Lttng_Resource_Trace + ": " + trace.getName() + ")"), (Throwable)sysExp);
            }
            ++i;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelectedTraces.clear();
            for (Object obj : (IStructuredSelection)selection) {
                if (!(obj instanceof TraceResource)) continue;
                this.fSelectedTraces.add((TraceResource)obj);
            }
        }
    }

    public void setSelectedTraces(List<TraceResource> traces) {
        this.fSelectedTraces = traces;
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
    }
}

