/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.core.stateprovider;

import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemBuilder;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;

class CtfKernelHandler
implements Runnable {
    private final BlockingQueue<CtfTmfEvent> inQueue;
    private IStateSystemBuilder ss;
    private CtfTmfEvent currentEvent;
    private final HashMap<String, Integer> knownEventNames;
    private int cpusNode = -1;
    private int threadsNode = -1;
    private int irqsNode = -1;
    private int softIrqsNode = -1;

    CtfKernelHandler(BlockingQueue<CtfTmfEvent> eventsQueue) {
        assert (eventsQueue != null);
        this.inQueue = eventsQueue;
        this.knownEventNames = CtfKernelHandler.fillEventNames();
    }

    void assignStateSystem(IStateSystemBuilder targetSS) {
        this.ss = targetSS;
    }

    @Override
    public void run() {
        if (this.ss == null) {
            System.err.println("Cannot run event manager without assigning a target state system first!");
            return;
        }
        this.setupCommonLocations();
        try {
            CtfTmfEvent event = this.inQueue.take();
            while (event.getTimestampValue() != -1L) {
                this.processEvent(event);
                event = this.inQueue.take();
            }
            this.closeStateSystem();
            return;
        }
        catch (InterruptedException e) {
            System.out.println("Event handler interrupted!");
            e.printStackTrace();
            return;
        }
    }

    private void closeStateSystem() {
        if (this.currentEvent == null) {
            return;
        }
        try {
            this.ss.closeHistory(this.currentEvent.getTimestamp().getValue());
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
    }

    private void processEvent(CtfTmfEvent event) {
        this.currentEvent = event;
        ITmfEventField content = event.getContent();
        String eventName = event.getEventName();
        long ts = event.getTimestamp().getValue();
        try {
            Integer currentCPUNode = this.ss.getQuarkRelativeAndAdd(this.cpusNode, new String[]{String.valueOf(event.getCPU())});
            int quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Current_thread"});
            ITmfStateValue value = this.ss.queryOngoingState(quark);
            int thread = value.unboxInt();
            Integer currentThreadNode = this.ss.getQuarkRelativeAndAdd(this.threadsNode, new String[]{String.valueOf(thread)});
            switch (this.getEventIndex(eventName)) {
                case 1: {
                    quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"System_call"});
                    value = TmfStateValue.nullValue();
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)2);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)1);
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 2: {
                    Integer irqId = ((Long)content.getField("irq").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.irqsNode, new String[]{irqId.toString()});
                    value = TmfStateValue.newValueInt((int)event.getCPU());
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)4);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)3);
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 3: {
                    Integer irqId = ((Long)content.getField("irq").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.irqsNode, new String[]{irqId.toString()});
                    value = TmfStateValue.nullValue();
                    this.ss.modifyAttribute(ts, value, quark);
                    this.setProcessToRunning(ts, currentThreadNode);
                    this.cpuExitInterrupt(ts, currentCPUNode, currentThreadNode);
                    break;
                }
                case 4: {
                    Integer softIrqId = ((Long)content.getField("vec").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.softIrqsNode, new String[]{softIrqId.toString()});
                    value = TmfStateValue.newValueInt((int)event.getCPU());
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)4);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)4);
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 5: {
                    Integer softIrqId = ((Long)content.getField("vec").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.softIrqsNode, new String[]{softIrqId.toString()});
                    value = TmfStateValue.nullValue();
                    this.ss.modifyAttribute(ts, value, quark);
                    this.setProcessToRunning(ts, currentThreadNode);
                    this.cpuExitInterrupt(ts, currentCPUNode, currentThreadNode);
                    break;
                }
                case 6: {
                    Integer softIrqId = ((Long)content.getField("vec").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.softIrqsNode, new String[]{softIrqId.toString()});
                    value = TmfStateValue.newValueInt((int)-2);
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 7: {
                    Integer prevTid = ((Long)content.getField("prev_tid").getValue()).intValue();
                    String nextProcessName = (String)content.getField("next_comm").getValue();
                    Integer nextTid = ((Long)content.getField("next_tid").getValue()).intValue();
                    Integer formerThreadNode = this.ss.getQuarkRelativeAndAdd(this.threadsNode, new String[]{prevTid.toString()});
                    Integer newCurrentThreadNode = this.ss.getQuarkRelativeAndAdd(this.threadsNode, new String[]{nextTid.toString()});
                    quark = this.ss.getQuarkRelativeAndAdd(formerThreadNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)1);
                    this.ss.modifyAttribute(ts, value, quark);
                    this.setProcessToRunning(ts, newCurrentThreadNode);
                    quark = this.ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"Exec_name"});
                    value = TmfStateValue.newValueString((String)nextProcessName);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"System_call"});
                    if (quark == this.ss.getNbAttributes()) {
                        value = TmfStateValue.nullValue();
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    if ((quark = this.ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"PPID"})) == this.ss.getNbAttributes()) {
                        value = TmfStateValue.nullValue();
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Current_thread"});
                    value = TmfStateValue.newValueInt((int)nextTid);
                    this.ss.modifyAttribute(ts, value, quark);
                    value = nextTid > 0 ? (this.ss.queryOngoingState(quark = this.ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"System_call"})).isNull() ? TmfStateValue.newValueInt((int)1) : TmfStateValue.newValueInt((int)2)) : TmfStateValue.newValueInt((int)0);
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 8: {
                    String childProcessName = (String)content.getField("child_comm").getValue();
                    Integer parentTid = ((Long)content.getField("parent_tid").getValue()).intValue();
                    Integer childTid = ((Long)content.getField("child_tid").getValue()).intValue();
                    Integer parentTidNode = this.ss.getQuarkRelativeAndAdd(this.threadsNode, new String[]{parentTid.toString()});
                    Integer childTidNode = this.ss.getQuarkRelativeAndAdd(this.threadsNode, new String[]{childTid.toString()});
                    quark = this.ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"PPID"});
                    value = TmfStateValue.newValueInt((int)parentTid);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"Exec_name"});
                    value = TmfStateValue.newValueString((String)childProcessName);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)1);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(parentTidNode.intValue(), new String[]{"System_call"});
                    value = this.ss.queryOngoingState(quark);
                    quark = this.ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"System_call"});
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    Integer tid = ((Long)content.getField("tid").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.threadsNode, new String[]{tid.toString()});
                    this.ss.removeAttribute(ts, quark);
                    break;
                }
                case 11: {
                    Integer tid = ((Long)content.getField("tid").getValue()).intValue();
                    int ppid = ((Long)content.getField("ppid").getValue()).intValue();
                    int status = ((Long)content.getField("status").getValue()).intValue();
                    String name = (String)content.getField("name").getValue();
                    int curThreadNode = this.ss.getQuarkRelativeAndAdd(this.threadsNode, new String[]{tid.toString()});
                    quark = this.ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"Exec_name"});
                    if (this.ss.queryOngoingState(quark).isNull()) {
                        value = TmfStateValue.newValueString((String)name);
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    if (this.ss.queryOngoingState(quark = this.ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"PPID"})).isNull()) {
                        value = TmfStateValue.newValueInt((int)ppid);
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    if (this.ss.queryOngoingState(quark = this.ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"Status"})).isNull()) {
                        value = status == 5 ? TmfStateValue.newValueInt((int)1) : TmfStateValue.newValueInt((int)0);
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    break;
                }
                default: {
                    if (eventName.startsWith("sys_") || eventName.startsWith("compat_sys_")) {
                        quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"System_call"});
                        value = TmfStateValue.newValueString((String)eventName);
                        this.ss.modifyAttribute(ts, value, quark);
                        quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"Status"});
                        value = TmfStateValue.newValueInt((int)3);
                        this.ss.modifyAttribute(ts, value, quark);
                        quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                        value = TmfStateValue.newValueInt((int)2);
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    break;
                }
            }
        }
        catch (AttributeNotFoundException ae) {
            ae.printStackTrace();
        }
        catch (TimeRangeException tre) {
            System.err.println("TimeRangeExcpetion caught in the state system's event manager.");
            System.err.println("Are the events in the trace correctly ordered?");
            tre.printStackTrace();
        }
        catch (StateValueTypeException sve) {
            sve.printStackTrace();
        }
    }

    private void setupCommonLocations() {
        this.cpusNode = this.ss.getQuarkAbsoluteAndAdd(new String[]{"CPUs"});
        this.threadsNode = this.ss.getQuarkAbsoluteAndAdd(new String[]{"Threads"});
        this.irqsNode = this.ss.getQuarkAbsoluteAndAdd(new String[]{"Resources", "IRQs"});
        this.softIrqsNode = this.ss.getQuarkAbsoluteAndAdd(new String[]{"Resources", "Soft_IRQs"});
    }

    private static HashMap<String, Integer> fillEventNames() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("exit_syscall", 1);
        map.put("irq_handler_entry", 2);
        map.put("irq_handler_exit", 3);
        map.put("softirq_entry", 4);
        map.put("softirq_exit", 5);
        map.put("softirq_raise", 6);
        map.put("sched_switch", 7);
        map.put("sched_process_fork", 8);
        map.put("sched_process_exit", 9);
        map.put("sched_process_free", 10);
        map.put("lttng_statedump_process_state", 11);
        return map;
    }

    private int getEventIndex(String eventName) {
        Integer ret = this.knownEventNames.get(eventName);
        return ret != null ? ret : -1;
    }

    private void setProcessToRunning(long ts, int currentThreadNode) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        int quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"System_call"});
        TmfStateValue value = this.ss.queryOngoingState(quark).isNull() ? TmfStateValue.newValueInt((int)2) : TmfStateValue.newValueInt((int)3);
        quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"Status"});
        this.ss.modifyAttribute(ts, (ITmfStateValue)value, quark);
    }

    private void cpuExitInterrupt(long ts, int currentCpuNode, int currentThreadNode) throws StateValueTypeException, AttributeNotFoundException, TimeRangeException {
        int quark = this.ss.getQuarkRelativeAndAdd(currentCpuNode, new String[]{"Current_thread"});
        TmfStateValue value = this.ss.queryOngoingState(quark).unboxInt() > 0 ? (this.ss.queryOngoingState(quark = this.ss.getQuarkRelative(currentThreadNode, new String[]{"System_call"})).isNull() ? TmfStateValue.newValueInt((int)1) : TmfStateValue.newValueInt((int)2)) : TmfStateValue.newValueInt((int)0);
        quark = this.ss.getQuarkRelativeAndAdd(currentCpuNode, new String[]{"Status"});
        this.ss.modifyAttribute(ts, (ITmfStateValue)value, quark);
    }
}

