/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Messages;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow.ControlFlowEvent;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow.ControlFlowPresentationProvider;
import org.eclipse.linuxtools.lttng2.kernel.core.trace.CtfKernelTrace;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfStateSystemBuildCompleted;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier2;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphCombo;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;

public class ControlFlowView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.lttng2.kernel.ui.views.controlflow";
    private static final long INITIAL_WINDOW_OFFSET = 100000000L;
    private static final String PROCESS_COLUMN = Messages.ControlFlowView_processColumn;
    private static final String TID_COLUMN = Messages.ControlFlowView_tidColumn;
    private static final String PTID_COLUMN = Messages.ControlFlowView_ptidColumn;
    private static final String BIRTH_TIME_COLUMN = Messages.ControlFlowView_birthTimeColumn;
    private static final String TRACE_COLUMN = Messages.ControlFlowView_traceColumn;
    private final String[] COLUMN_NAMES = new String[]{PROCESS_COLUMN, TID_COLUMN, PTID_COLUMN, BIRTH_TIME_COLUMN, TRACE_COLUMN};
    private TimeGraphCombo fTimeGraphCombo;
    private TmfExperiment<ITmfEvent> fSelectedExperiment;
    private ArrayList<ControlFlowEntry> fEntryList;
    private final Object fEntryListSyncObj = new Object();
    private long fStartTime;
    private long fEndTime;
    private final int fDisplayWidth;
    private ZoomThread fZoomThread;
    private Action fNextResourceAction;
    private Action fPreviousResourceAction;
    private final ControlFlowEntryComparator fControlFlowEntryComparator = new ControlFlowEntryComparator();
    private State fRedrawState = State.IDLE;
    private final Object fSyncObj = new Object();

    public ControlFlowView() {
        super(ID);
        this.fDisplayWidth = Display.getDefault().getBounds().width;
    }

    public void createPartControl(Composite parent) {
        this.fTimeGraphCombo = new TimeGraphCombo(parent, 0);
        this.fTimeGraphCombo.setTreeContentProvider((ITreeContentProvider)new TreeContentProvider());
        this.fTimeGraphCombo.setTreeLabelProvider((ITableLabelProvider)new TreeLabelProvider());
        this.fTimeGraphCombo.setTimeGraphProvider((ITimeGraphPresentationProvider)new ControlFlowPresentationProvider());
        this.fTimeGraphCombo.setTreeColumns(this.COLUMN_NAMES);
        this.fTimeGraphCombo.getTimeGraphViewer().addRangeListener(new ITimeGraphRangeListener(){

            public void timeRangeUpdated(TimeGraphRangeUpdateEvent event) {
                long startTime = event.getStartTime();
                long endTime = event.getEndTime();
                TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new CtfTmfTimestamp(startTime), (ITmfTimestamp)new CtfTmfTimestamp(endTime));
                CtfTmfTimestamp time = new CtfTmfTimestamp(ControlFlowView.this.fTimeGraphCombo.getTimeGraphViewer().getSelectedTime());
                ControlFlowView.this.broadcast((TmfSignal)new TmfRangeSynchSignal((Object)ControlFlowView.this, range, (ITmfTimestamp)time));
                if (ControlFlowView.this.fZoomThread != null) {
                    ControlFlowView.this.fZoomThread.cancel();
                }
                ControlFlowView.this.startZoomThread(startTime, endTime);
            }
        });
        this.fTimeGraphCombo.getTimeGraphViewer().addTimeListener(new ITimeGraphTimeListener(){

            public void timeSelected(TimeGraphTimeEvent event) {
                long time = event.getTime();
                ControlFlowView.this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)ControlFlowView.this, (ITmfTimestamp)new CtfTmfTimestamp(time)));
            }
        });
        this.fTimeGraphCombo.addSelectionListener(new ITimeGraphSelectionListener(){

            public void selectionChanged(TimeGraphSelectionEvent event) {
            }
        });
        this.fTimeGraphCombo.getTimeGraphViewer().setTimeCalendarFormat(true);
        Thread thread = new Thread("ControlFlowView build"){

            @Override
            public void run() {
                if (TmfExperiment.getCurrentExperiment() != null) {
                    ControlFlowView.this.selectExperiment(TmfExperiment.getCurrentExperiment());
                }
            }
        };
        thread.start();
        this.makeActions();
        this.contributeToActionBars();
    }

    public void setFocus() {
        this.fTimeGraphCombo.setFocus();
    }

    @TmfSignalHandler
    public void experimentSelected(final TmfExperimentSelectedSignal<? extends ITmfEvent> signal) {
        if (signal.getExperiment().equals(this.fSelectedExperiment)) {
            return;
        }
        Thread thread = new Thread("ControlFlowView build"){

            @Override
            public void run() {
                ControlFlowView.this.selectExperiment(signal.getExperiment());
            }
        };
        thread.start();
    }

    @TmfSignalHandler
    public void synchToTime(TmfTimeSynchSignal signal) {
        if (signal.getSource() == this || this.fSelectedExperiment == null || this.fSelectedExperiment.getTraces() == null) {
            return;
        }
        final long time = signal.getCurrentTime().normalize(0L, -9).getValue();
        int thread = -1;
        ITmfTrace[] iTmfTraceArray = this.fSelectedExperiment.getTraces();
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtfKernelTrace ctfKernelTrace;
            IStateSystemQuerier ssq;
            ITmfTrace trace = iTmfTraceArray[n2];
            if (thread > 0) break;
            if (trace instanceof CtfKernelTrace && time >= (ssq = (ctfKernelTrace = (CtfKernelTrace)trace).getStateSystem()).getStartTime() && time <= ssq.getCurrentEndTime()) {
                List currentThreadQuarks = ssq.getQuarks(new String[]{"CPUs", "*", "Current_thread"});
                Iterator iterator = currentThreadQuarks.iterator();
                while (iterator.hasNext()) {
                    int currentThreadQuark = (Integer)iterator.next();
                    try {
                        int statusQuark;
                        ITmfStateInterval statusInterval;
                        ITmfStateInterval currentThreadInterval = ssq.querySingleState(time, currentThreadQuark);
                        int currentThread = currentThreadInterval.getStateValue().unboxInt();
                        if (currentThread <= 0 || (statusInterval = ssq.querySingleState(time, statusQuark = ssq.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThread), "Status"}))).getStartTime() != time) continue;
                        thread = currentThread;
                        break;
                    }
                    catch (AttributeNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (TimeRangeException e) {
                        e.printStackTrace();
                    }
                    catch (StateValueTypeException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
        final int selectedThread = thread;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ControlFlowView.this.fTimeGraphCombo.isDisposed()) {
                    return;
                }
                ControlFlowView.this.fTimeGraphCombo.getTimeGraphViewer().setSelectedTime(time, true);
                ControlFlowView.this.startZoomThread(ControlFlowView.this.fTimeGraphCombo.getTimeGraphViewer().getTime0(), ControlFlowView.this.fTimeGraphCombo.getTimeGraphViewer().getTime1());
                if (selectedThread > 0) {
                    ITimeGraphEntry[] iTimeGraphEntryArray = ControlFlowView.this.fTimeGraphCombo.getTimeGraphViewer().getExpandedElements();
                    int n = iTimeGraphEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ControlFlowEntry entry;
                        ITimeGraphEntry element = iTimeGraphEntryArray[n2];
                        if (element instanceof ControlFlowEntry && (entry = (ControlFlowEntry)element).getThreadId() == selectedThread) {
                            ControlFlowView.this.fTimeGraphCombo.setSelection((ITimeGraphEntry)entry);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    @TmfSignalHandler
    public void synchToRange(TmfRangeSynchSignal signal) {
        if (signal.getSource() == this || this.fSelectedExperiment == null) {
            return;
        }
        final long startTime = signal.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
        final long endTime = signal.getCurrentRange().getEndTime().normalize(0L, -9).getValue();
        final long time = signal.getCurrentTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ControlFlowView.this.fTimeGraphCombo.isDisposed()) {
                    return;
                }
                ControlFlowView.this.fTimeGraphCombo.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                ControlFlowView.this.fTimeGraphCombo.getTimeGraphViewer().setSelectedTime(time, false);
                ControlFlowView.this.startZoomThread(startTime, endTime);
            }
        });
    }

    @TmfSignalHandler
    public void stateSystemBuildCompleted(TmfStateSystemBuildCompleted signal) {
        final TmfExperiment<ITmfEvent> selectedExperiment = this.fSelectedExperiment;
        if (selectedExperiment == null || selectedExperiment.getTraces() == null) {
            return;
        }
        ITmfTrace[] iTmfTraceArray = selectedExperiment.getTraces();
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            if (trace == signal.getTrace() && trace instanceof CtfKernelTrace) {
                Thread thread = new Thread("ControlFlowView build"){

                    @Override
                    public void run() {
                        ControlFlowView.this.selectExperiment(selectedExperiment);
                    }
                };
                thread.start();
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectExperiment(TmfExperiment<?> experiment) {
        this.fStartTime = Long.MAX_VALUE;
        this.fEndTime = Long.MIN_VALUE;
        this.fSelectedExperiment = experiment;
        ArrayList<ControlFlowEntry> rootList = new ArrayList<ControlFlowEntry>();
        ITmfTrace[] iTmfTraceArray = experiment.getTraces();
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            if (trace instanceof CtfKernelTrace) {
                ArrayList<ControlFlowEntry> entryList = new ArrayList<ControlFlowEntry>();
                CtfKernelTrace ctfKernelTrace = (CtfKernelTrace)trace;
                IStateSystemQuerier ssq = ctfKernelTrace.getStateSystem();
                long start = ssq.getStartTime();
                long end = ssq.getCurrentEndTime() + 1L;
                this.fStartTime = Math.min(this.fStartTime, start);
                this.fEndTime = Math.max(this.fEndTime, end);
                List threadQuarks = ssq.getQuarks(new String[]{"Threads", "*"});
                Iterator iterator = threadQuarks.iterator();
                while (iterator.hasNext()) {
                    int threadQuark = (Integer)iterator.next();
                    String threadName = ssq.getAttributeName(threadQuark);
                    int threadId = -1;
                    try {
                        threadId = Integer.parseInt(threadName);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    if (threadId == 0) continue;
                    int execNameQuark = -1;
                    try {
                        try {
                            execNameQuark = ssq.getQuarkRelative(threadQuark, new String[]{"Exec_name"});
                        }
                        catch (AttributeNotFoundException attributeNotFoundException) {
                            continue;
                        }
                        int ppidQuark = ssq.getQuarkRelative(threadQuark, new String[]{"PPID"});
                        List execNameIntervals = ssq.queryHistoryRange(execNameQuark, start, end - 1L);
                        long birthTime = -1L;
                        for (ITmfStateInterval execNameInterval : execNameIntervals) {
                            if (!execNameInterval.getStateValue().isNull() && execNameInterval.getStateValue().getType() == 1) {
                                String execName = execNameInterval.getStateValue().unboxStr();
                                long startTime = execNameInterval.getStartTime();
                                long endTime = execNameInterval.getEndTime() + 1L;
                                if (birthTime == -1L) {
                                    birthTime = startTime;
                                }
                                int ppid = -1;
                                if (ppidQuark != -1) {
                                    ITmfStateInterval ppidInterval = ssq.querySingleState(startTime, ppidQuark);
                                    ppid = ppidInterval.getStateValue().unboxInt();
                                }
                                ControlFlowEntry entry = new ControlFlowEntry(threadQuark, ctfKernelTrace, execName, threadId, ppid, birthTime, startTime, endTime);
                                entryList.add(entry);
                                entry.addEvent((ITimeEvent)new TimeEvent((ITimeGraphEntry)entry, startTime, endTime - startTime));
                                continue;
                            }
                            birthTime = -1L;
                        }
                    }
                    catch (AttributeNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (TimeRangeException e) {
                        e.printStackTrace();
                    }
                    catch (StateValueTypeException e) {
                        e.printStackTrace();
                    }
                }
                ControlFlowView.buildTree(entryList, rootList);
            }
            Collections.sort(rootList, this.fControlFlowEntryComparator);
            Object object = this.fEntryListSyncObj;
            synchronized (object) {
                this.fEntryList = (ArrayList)rootList.clone();
            }
            this.refresh(100000000L);
            ++n2;
        }
        for (ControlFlowEntry entry : rootList) {
            this.buildStatusEvents(entry);
        }
    }

    private static void buildTree(ArrayList<ControlFlowEntry> entryList, ArrayList<ControlFlowEntry> rootList) {
        for (ControlFlowEntry entry : entryList) {
            boolean root = true;
            if (entry.getParentThreadId() > 0) {
                for (ControlFlowEntry parent : entryList) {
                    if (parent.getThreadId() != entry.getParentThreadId() || entry.getStartTime() < parent.getStartTime() || entry.getStartTime() > parent.getEndTime()) continue;
                    parent.addChild(entry);
                    root = false;
                    break;
                }
            }
            if (!root) continue;
            rootList.add(entry);
        }
    }

    private void buildStatusEvents(ControlFlowEntry entry) {
        IStateSystemQuerier ssq = entry.getTrace().getStateSystem();
        long start = ssq.getStartTime();
        long end = ssq.getCurrentEndTime() + 1L;
        long resolution = Math.max(1L, (end - start) / (long)this.fDisplayWidth);
        List<ITimeEvent> eventList = ControlFlowView.getEventList(entry, entry.getStartTime(), entry.getEndTime(), resolution, (IProgressMonitor)new NullProgressMonitor());
        entry.setEventList(eventList);
        this.redraw();
        ControlFlowEntry[] controlFlowEntryArray = entry.getChildren();
        int n = controlFlowEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ControlFlowEntry child = controlFlowEntryArray[n2];
            this.buildStatusEvents(child);
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<ITimeEvent> getEventList(ControlFlowEntry entry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        startTime = Math.max(startTime, entry.getStartTime());
        if ((endTime = Math.min(endTime, entry.getEndTime())) <= startTime) {
            return null;
        }
        IStateSystemQuerier2 ssq = (IStateSystemQuerier2)entry.getTrace().getStateSystem();
        ArrayList<ControlFlowEvent> eventList = null;
        try {
            int statusQuark = ssq.getQuarkRelative(entry.getThreadQuark(), new String[]{"Status"});
            List statusIntervals = ssq.queryHistoryRange(statusQuark, startTime, endTime - 1L, resolution, monitor);
            eventList = new ArrayList<ControlFlowEvent>(statusIntervals.size());
            long lastEndTime = -1L;
            Iterator iterator = statusIntervals.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return eventList;
                }
                ITmfStateInterval statusInterval = (ITmfStateInterval)iterator.next();
                if (monitor.isCanceled()) {
                    return null;
                }
                long time = statusInterval.getStartTime();
                long duration = statusInterval.getEndTime() - time + 1L;
                int status = -1;
                try {
                    status = statusInterval.getStateValue().unboxInt();
                }
                catch (StateValueTypeException e) {
                    e.printStackTrace();
                }
                if (lastEndTime != time && lastEndTime != -1L) {
                    eventList.add(new ControlFlowEvent(entry, lastEndTime, time - lastEndTime, 0));
                }
                eventList.add(new ControlFlowEvent(entry, time, duration, status));
                lastEndTime = time + duration;
            }
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
            return eventList;
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
        return eventList;
    }

    private void refresh(final long windowRange) {
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ControlFlowView.this.fTimeGraphCombo.isDisposed()) {
                    return;
                }
                ITimeGraphEntry[] entries = null;
                Object object = ControlFlowView.this.fEntryListSyncObj;
                synchronized (object) {
                    entries = ControlFlowView.this.fEntryList.toArray(new ITimeGraphEntry[0]);
                }
                Arrays.sort(entries, ControlFlowView.this.fControlFlowEntryComparator);
                ControlFlowView.this.fTimeGraphCombo.setInput(entries);
                ControlFlowView.this.fTimeGraphCombo.getTimeGraphViewer().setTimeBounds(ControlFlowView.this.fStartTime, ControlFlowView.this.fEndTime);
                long endTime = ControlFlowView.this.fStartTime + windowRange;
                if (ControlFlowView.this.fEndTime < endTime) {
                    endTime = ControlFlowView.this.fEndTime;
                }
                ControlFlowView.this.fTimeGraphCombo.getTimeGraphViewer().setStartFinishTime(ControlFlowView.this.fStartTime, endTime);
                TreeColumn[] treeColumnArray = ControlFlowView.this.fTimeGraphCombo.getTreeViewer().getTree().getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    column.pack();
                    ++n2;
                }
                ControlFlowView.this.startZoomThread(ControlFlowView.this.fStartTime, endTime);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redraw() {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRedrawState != State.IDLE) {
                this.fRedrawState = State.PENDING;
                return;
            }
            this.fRedrawState = State.BUSY;
        }
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ControlFlowView.this.fTimeGraphCombo.isDisposed()) {
                    return;
                }
                ControlFlowView.this.fTimeGraphCombo.redraw();
                ControlFlowView.this.fTimeGraphCombo.update();
                Object object = ControlFlowView.this.fSyncObj;
                synchronized (object) {
                    if (ControlFlowView.this.fRedrawState == State.PENDING) {
                        ControlFlowView.this.fRedrawState = State.IDLE;
                        ControlFlowView.this.redraw();
                    } else {
                        ControlFlowView.this.fRedrawState = State.IDLE;
                    }
                }
            }
        });
    }

    private void startZoomThread(long startTime, long endTime) {
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
        }
        this.fZoomThread = new ZoomThread(startTime, endTime);
        this.fZoomThread.start();
    }

    private void makeActions() {
        this.fPreviousResourceAction = this.fTimeGraphCombo.getTimeGraphViewer().getPreviousItemAction();
        this.fPreviousResourceAction.setText(Messages.ControlFlowView_previousProcessActionNameText);
        this.fPreviousResourceAction.setToolTipText(Messages.ControlFlowView_previousProcessActionToolTipText);
        this.fNextResourceAction = this.fTimeGraphCombo.getTimeGraphViewer().getNextItemAction();
        this.fNextResourceAction.setText(Messages.ControlFlowView_nextProcessActionNameText);
        this.fNextResourceAction.setToolTipText(Messages.ControlFlowView_nextProcessActionToolTipText);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fTimeGraphCombo.getTimeGraphViewer().getShowLegendAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fTimeGraphCombo.getTimeGraphViewer().getResetScaleAction());
        manager.add((IAction)this.fTimeGraphCombo.getTimeGraphViewer().getPreviousEventAction());
        manager.add((IAction)this.fTimeGraphCombo.getTimeGraphViewer().getNextEventAction());
        manager.add((IAction)this.fPreviousResourceAction);
        manager.add((IAction)this.fNextResourceAction);
        manager.add((IAction)this.fTimeGraphCombo.getTimeGraphViewer().getZoomInAction());
        manager.add((IAction)this.fTimeGraphCombo.getTimeGraphViewer().getZoomOutAction());
        manager.add((IContributionItem)new Separator());
    }

    private static class ControlFlowEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private ControlFlowEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            int result = 0;
            if (o1 instanceof ControlFlowEntry && o2 instanceof ControlFlowEntry) {
                ControlFlowEntry entry1 = (ControlFlowEntry)o1;
                ControlFlowEntry entry2 = (ControlFlowEntry)o2;
                result = entry1.getTrace().getStartTime().compareTo(entry2.getTrace().getStartTime());
                if (result == 0) {
                    result = entry1.getTrace().getName().compareTo(entry2.getTrace().getName());
                }
                if (result == 0) {
                    int n = entry1.getThreadId() < entry2.getThreadId() ? -1 : (result = entry1.getThreadId() > entry2.getThreadId() ? 1 : 0);
                }
            }
            if (result == 0) {
                result = o1.getStartTime() < o2.getStartTime() ? -1 : (o1.getStartTime() > o2.getStartTime() ? 1 : 0);
            }
            return result;
        }
    }

    private static enum State {
        IDLE,
        BUSY,
        PENDING;

    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (ITimeGraphEntry[])inputElement;
        }

        public Object[] getChildren(Object parentElement) {
            ITimeGraphEntry entry = (ITimeGraphEntry)parentElement;
            return entry.getChildren();
        }

        public Object getParent(Object element) {
            ITimeGraphEntry entry = (ITimeGraphEntry)element;
            return entry.getParent();
        }

        public boolean hasChildren(Object element) {
            ITimeGraphEntry entry = (ITimeGraphEntry)element;
            return entry.hasChildren();
        }
    }

    private class TreeLabelProvider
    implements ITableLabelProvider {
        private TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ControlFlowEntry entry = (ControlFlowEntry)element;
            if (columnIndex == 0) {
                return entry.getName();
            }
            if (columnIndex == 1) {
                return Integer.toString(entry.getThreadId());
            }
            if (columnIndex == 2) {
                if (entry.getParentThreadId() > 0) {
                    return Integer.toString(entry.getParentThreadId());
                }
            } else {
                if (columnIndex == 3) {
                    return Utils.formatTime((long)entry.getBirthTime(), (Utils.TimeFormat)Utils.TimeFormat.ABSOLUTE, (Utils.Resolution)Utils.Resolution.NANOSEC);
                }
                if (columnIndex == 4) {
                    return entry.getTrace().getName();
                }
            }
            return "";
        }
    }

    private class ZoomThread
    extends Thread {
        private final long fZoomStartTime;
        private final long fZoomEndTime;
        private final long fResolution;
        private final IProgressMonitor fMonitor;

        public ZoomThread(long startTime, long endTime) {
            super("ControlFlowView zoom");
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fResolution = Math.max(1L, (this.fZoomEndTime - this.fZoomStartTime) / (long)ControlFlowView.this.fDisplayWidth);
            this.fMonitor = new NullProgressMonitor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList entryList = null;
            Object object = ControlFlowView.this.fEntryListSyncObj;
            synchronized (object) {
                entryList = ControlFlowView.this.fEntryList;
            }
            if (entryList == null) {
                return;
            }
            for (ControlFlowEntry entry : entryList) {
                if (this.fMonitor.isCanceled()) break;
                this.zoom(entry, this.fMonitor);
            }
        }

        private void zoom(ControlFlowEntry entry, IProgressMonitor monitor) {
            if (this.fZoomStartTime <= ControlFlowView.this.fStartTime && this.fZoomEndTime >= ControlFlowView.this.fEndTime) {
                entry.setZoomedEventList(null);
            } else {
                List zoomedEventList = ControlFlowView.getEventList(entry, this.fZoomStartTime, this.fZoomEndTime, this.fResolution, monitor);
                if (zoomedEventList != null) {
                    entry.setZoomedEventList(zoomedEventList);
                }
            }
            ControlFlowView.this.redraw();
            ControlFlowEntry[] controlFlowEntryArray = entry.getChildren();
            int n = controlFlowEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ControlFlowEntry child = controlFlowEntryArray[n2];
                if (this.fMonitor.isCanceled()) {
                    return;
                }
                this.zoom(child, monitor);
                ++n2;
            }
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }
}

