/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs;

import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.IGetEventInfoDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceChannelComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceDomainComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionComponent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GetEventInfoDialog
extends Dialog
implements IGetEventInfoDialog {
    public static final String TARGET_NEW_CONNECTION_ICON_FILE = "icons/elcl16/enable_event.gif";
    private Composite fDialogComposite = null;
    private Group fSessionsGroup = null;
    private Group fChannelsGroup = null;
    private CCombo fSessionsCombo = null;
    private CCombo fChannelsCombo = null;
    private TraceSessionComponent[] fSessions;
    private boolean fIsKernel;
    private int fSessionIndex = 0;
    private TraceChannelComponent fChannel;
    private TraceChannelComponent[] fChannels;

    public GetEventInfoDialog(Shell shell) {
        super(shell);
        this.setShellStyle(16);
    }

    @Override
    public TraceSessionComponent getSession() {
        return this.fSessions[this.fSessionIndex];
    }

    @Override
    public TraceChannelComponent getChannel() {
        return this.fChannel;
    }

    @Override
    public void setIsKernel(boolean isKernel) {
        this.fIsKernel = isKernel;
    }

    @Override
    public void setSessions(TraceSessionComponent[] sessions) {
        this.fSessions = Arrays.copyOf(sessions, sessions.length);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_EnableEventsDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(TARGET_NEW_CONNECTION_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        this.fDialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fDialogComposite.setLayout((Layout)layout);
        this.fDialogComposite.setLayoutData((Object)new GridData(1808));
        this.fSessionsGroup = new Group(this.fDialogComposite, 32);
        this.fSessionsGroup.setText(Messages.TraceControl_EnableEventsSessionGroupName);
        layout = new GridLayout(1, true);
        this.fSessionsGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        this.fSessionsGroup.setLayoutData((Object)data);
        this.fSessionsCombo = new CCombo((Composite)this.fSessionsGroup, 8);
        this.fSessionsCombo.setToolTipText(Messages.TraceControl_EnableEventsSessionsTooltip);
        this.fSessionsCombo.setLayoutData((Object)new GridData(768));
        String[] items = new String[this.fSessions.length];
        int i = 0;
        while (i < items.length) {
            items[i] = String.valueOf(this.fSessions[i].getName());
            ++i;
        }
        this.fSessionsCombo.setItems(items);
        this.fSessionsCombo.setEnabled(this.fSessions.length > 0);
        this.fChannelsGroup = new Group(this.fDialogComposite, 32);
        this.fChannelsGroup.setText(Messages.TraceControl_EnableEventsChannelGroupName);
        layout = new GridLayout(1, true);
        this.fChannelsGroup.setLayout((Layout)layout);
        data = new GridData(768);
        this.fChannelsGroup.setLayoutData((Object)data);
        this.fChannelsCombo = new CCombo((Composite)this.fChannelsGroup, 8);
        this.fChannelsCombo.setToolTipText(Messages.TraceControl_EnableEventsChannelsTooltip);
        this.fChannelsCombo.setLayoutData((Object)new GridData(768));
        this.fChannelsCombo.setEnabled(false);
        this.fSessionsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GetEventInfoDialog.this.fSessionIndex = GetEventInfoDialog.this.fSessionsCombo.getSelectionIndex();
                if (GetEventInfoDialog.this.fSessionIndex >= 0) {
                    TraceDomainComponent domain = null;
                    TraceDomainComponent[] domains = GetEventInfoDialog.this.fSessions[GetEventInfoDialog.this.fSessionIndex].getDomains();
                    int i = 0;
                    while (i < domains.length) {
                        if (domains[i].isKernel() == GetEventInfoDialog.this.fIsKernel) {
                            domain = domains[i];
                            break;
                        }
                        ++i;
                    }
                    if (domain != null) {
                        GetEventInfoDialog.this.fChannels = domain.getChannels();
                        String[] selectionItems = new String[GetEventInfoDialog.this.fChannels.length];
                        int i2 = 0;
                        while (i2 < selectionItems.length) {
                            selectionItems[i2] = String.valueOf(GetEventInfoDialog.this.fChannels[i2].getName());
                            ++i2;
                        }
                        GetEventInfoDialog.this.fChannelsCombo.setItems(selectionItems);
                        GetEventInfoDialog.this.fChannelsCombo.setEnabled(GetEventInfoDialog.this.fChannels.length > 0);
                    } else {
                        GetEventInfoDialog.this.fChannelsCombo.setItems(new String[0]);
                        GetEventInfoDialog.this.fChannelsCombo.setEnabled(false);
                        GetEventInfoDialog.this.fChannels = null;
                    }
                    GetEventInfoDialog.this.fChannelsCombo.getParent().getParent().layout();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getShell().setMinimumSize(new Point(300, 200));
        return this.fDialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        if (this.fSessionsCombo.getSelectionIndex() < 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableEventsDialogTitle, (String)Messages.TraceControl_EnableEventsNoSessionError);
            return;
        }
        this.fSessionIndex = this.fSessionsCombo.getSelectionIndex();
        if (this.fChannels != null && this.fChannels.length > 0 && this.fChannelsCombo.getSelectionIndex() < 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableEventsDialogTitle, (String)Messages.TraceControl_EnableEventsNoChannelError);
            return;
        }
        this.fChannel = null;
        if (this.fChannels != null && this.fChannels.length > 0) {
            this.fChannel = this.fChannels[this.fChannelsCombo.getSelectionIndex()];
        }
        super.okPressed();
    }
}

