/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.hidden;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.hidden.TreeExpandCollapseAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.FunctionBrowserView;
import org.eclipse.linuxtools.systemtap.ui.editor.actions.file.NewFileAction;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class FunctionBrowserAction
extends Action
implements ActionFactory.IWorkbenchAction,
ISelectionListener {
    private final IWorkbenchWindow window;
    private final FunctionBrowserView viewer;
    private static final String ID = "org.eclipse.linuxtools.systemtap.ui.ide.FunctionAction";
    private IStructuredSelection selection;
    private TreeExpandCollapseAction expandAction;

    public FunctionBrowserAction(IWorkbenchWindow window, FunctionBrowserView browser) {
        LogManager.logInfo((String)"initialized", (Object)((Object)this));
        this.window = window;
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setText(Localization.getString("FunctionBrowserAction.Insert"));
        this.setToolTipText(Localization.getString("FunctionBrowserAction.InsertFunction"));
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.viewer = browser;
        this.expandAction = new TreeExpandCollapseAction(FunctionBrowserView.class);
    }

    public void dispose() {
        this.window.getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.selection = null;
        this.expandAction.dispose();
        this.expandAction = null;
        LogManager.logInfo((String)"disposed", (Object)((Object)this));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection incoming) {
        if (incoming instanceof IStructuredSelection) {
            LogManager.logDebug((String)"Changing selection", (Object)((Object)this));
            this.selection = (IStructuredSelection)incoming;
            this.setEnabled(this.selection.size() == 1);
        } else {
            LogManager.logDebug((String)"Disabling, selection not IStructuredSelection", (Object)((Object)this));
            this.setEnabled(false);
        }
    }

    public void run() {
        LogManager.logDebug((String)"Start run:", (Object)((Object)this));
        IWorkbenchPage page = this.window.getActivePage();
        ISelection incoming = this.viewer.getViewer().getSelection();
        IStructuredSelection selection = (IStructuredSelection)incoming;
        Object o = selection.getFirstElement();
        if (o instanceof TreeNode) {
            TreeNode t = (TreeNode)o;
            if (t.isClickable()) {
                IEditorPart ed = page.getActiveEditor();
                if (ed == null) {
                    NewFileAction action = new NewFileAction();
                    action.run();
                    if (action.isSuccessful()) {
                        ed = page.getWorkbenchWindow().getActivePage().getActiveEditor();
                    } else {
                        return;
                    }
                }
                IEditorInput input = ed.getEditorInput();
                try {
                    IEditorPart editor = page.openEditor(input, "org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor");
                    if (editor instanceof STPEditor) {
                        STPEditor stpeditor = (STPEditor)editor;
                        String s = String.valueOf(t.toString()) + "\n";
                        stpeditor.insertTextAtCurrent(s);
                    }
                }
                catch (PartInitException e) {
                    LogManager.logCritical((String)("PartInitException run: " + e.getMessage()), (Object)((Object)this));
                }
            } else {
                this.expandAction.run();
            }
        }
        LogManager.logDebug((String)"End run:", (Object)((Object)this));
    }
}

