/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.structures;

import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.StringOutputStream;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeDefinitionNode;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IUpdateListener;

public class TapsetParser
implements Runnable {
    private boolean stopped = true;
    private boolean disposed = true;
    private boolean successfulFinish = false;
    private ArrayList<IUpdateListener> listeners;
    private TreeNode functions;
    private TreeNode probes;
    private String[] tapsets;
    private Thread thread;

    public TapsetParser(String[] tapsets) {
        this.tapsets = tapsets;
        this.listeners = new ArrayList();
    }

    protected void init() {
        this.disposed = false;
        this.functions = new TreeNode((Object)"", false);
        this.probes = new TreeNode((Object)"", false);
        String s = this.readPass1(null);
        this.parseLevel1(s);
        this.cleanupTrees();
    }

    public void start() {
        this.stopped = false;
        this.init();
        this.thread = new Thread((Runnable)this, "TapsetParser");
        this.thread.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public synchronized TreeNode getFunctions() {
        return this.functions;
    }

    public synchronized TreeNode getProbes() {
        return this.probes;
    }

    public boolean isFinishSuccessful() {
        return this.successfulFinish;
    }

    public void run() {
        this.runPass2Functions();
        this.fireUpdateEvent();
        this.successfulFinish = true;
        this.fireUpdateEvent();
    }

    public void addListener(IUpdateListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IUpdateListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireUpdateEvent() {
        int i = 0;
        while (i < this.listeners.size() && !this.stopped) {
            this.listeners.get(i).handleUpdateEvent();
            ++i;
        }
    }

    protected String runStap(String[] options, String probe) {
        int i;
        String[] args = null;
        int size = 2;
        if (this.tapsets != null && this.tapsets.length > 0 && this.tapsets[0].trim().length() > 0) {
            size += this.tapsets.length << 1;
        }
        if (options != null && options.length > 0 && options[0].trim().length() > 0) {
            size += options.length;
        }
        args = new String[size];
        args[0] = "";
        args[size - 1] = probe;
        args[size - 2] = "";
        if (this.tapsets != null && this.tapsets.length > 0 && this.tapsets[0].trim().length() > 0) {
            i = 0;
            while (i < this.tapsets.length) {
                args[2 + (i << 1)] = "-I";
                args[3 + (i << 1)] = this.tapsets[i];
                ++i;
            }
        }
        if (options != null && options.length > 0 && options[0].trim().length() > 0) {
            i = 0;
            while (i < options.length) {
                args[args.length - options.length - 1 + i] = options[i];
                ++i;
            }
        }
        StringOutputStream str = new StringOutputStream();
        StringOutputStream strErr = new StringOutputStream();
        try {
            URI uri = IDEPlugin.getDefault().getPreferenceStore().getBoolean("RemoteProbes") ? IDEPlugin.getDefault().createRemoteUri(null) : new URI(Path.ROOT.toOSString());
            IRemoteCommandLauncher launcher = RemoteProxyManager.getInstance().getLauncher(uri);
            launcher.execute((IPath)new Path("stap"), args, null, null, null);
            launcher.waitAndRead((OutputStream)str, (OutputStream)strErr, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (URISyntaxException e) {
            LogManager.logCritical((String)("URISyntaxException runStap: " + e.getMessage()), (Object)this);
        }
        catch (CoreException e) {
            LogManager.logCritical((String)("CoreException runStap: " + e.getMessage()), (Object)this);
        }
        return str.toString();
    }

    @Deprecated
    protected String runStap(String[] options, String probe, int level) {
        return this.runStap(options, probe);
    }

    private String readPass1(String script) {
        String[] options;
        if (script == null) {
            script = "**";
            options = new String[]{"-p1", "-v", "-L"};
        } else {
            options = null;
        }
        return this.runStap(options, script);
    }

    private void parseLevel1(String s) {
        String prev = null;
        StringBuilder token = new StringBuilder("");
        StringTokenizer st = new StringTokenizer(s, "\n", false);
        st.nextToken();
        while (st.hasMoreTokens()) {
            StringTokenizer next_level = new StringTokenizer(st.nextToken());
            token.setLength(0);
            int total = next_level.countTokens();
            int i = 0;
            while (i < total) {
                TreeNode child;
                TreeNode item;
                prev = next_level.nextToken();
                if (i == 0) {
                    this.probes.add(new TreeNode((Object)prev, prev, true));
                    TreeNode parent = this.probes.getChildAt(this.probes.getChildCount() - 1);
                    parent.add((TreeNode)new TreeDefinitionNode((Object)("probe " + prev), prev, parent.getData().toString(), true));
                } else if (i < total - 1) {
                    if (token.length() == 0) {
                        token.append(prev);
                    } else if (token.length() != 0 && !prev.contains(":")) {
                        token.append(String.valueOf(prev) + " ");
                    } else if (token.length() != 0 && prev.contains(":")) {
                        item = this.probes.getChildAt(this.probes.getChildCount() - 1);
                        child = item.getChildAt(item.getChildCount() - 1);
                        child.add(new TreeNode((Object)token.toString(), token.toString(), false));
                        token.setLength(0);
                        token.append(String.valueOf(prev) + " ");
                    }
                } else if (i == total - 1) {
                    if (prev.contains(":")) {
                        item = this.probes.getChildAt(this.probes.getChildCount() - 1);
                        child = item.getChildAt(item.getChildCount() - 1);
                        child.add(new TreeNode((Object)token.toString(), token.toString(), false));
                        item = this.probes.getChildAt(this.probes.getChildCount() - 1);
                        child = item.getChildAt(item.getChildCount() - 1);
                        child.add(new TreeNode((Object)prev, prev, false));
                    } else {
                        token.append(prev);
                        item = this.probes.getChildAt(this.probes.getChildCount() - 1);
                        child = item.getChildAt(item.getChildCount() - 1);
                        child.add(new TreeNode((Object)token.toString(), token.toString(), false));
                    }
                }
                ++i;
            }
        }
    }

    private void runPass2Functions() {
        int i = 0;
        String script = "probe begin{}";
        String result = this.runStap(new String[]{"-v", "-p1", "-e"}, script);
        StringTokenizer st = new StringTokenizer(result, "\n", false);
        st.nextToken();
        String tok = "";
        while (st.hasMoreTokens()) {
            tok = st.nextToken().toString();
            String regex = "^function .*\\)\n$";
            Pattern p = Pattern.compile(regex, 13);
            Matcher m = p.matcher(tok);
            while (m.find()) {
                String[] us;
                Pattern secondp = Pattern.compile("[\\W]");
                Pattern underscorep = Pattern.compile("^function _.*");
                String[] stringArray = us = underscorep.split(m.group().toString());
                int n = us.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    String[] test = secondp.split(s);
                    i = 0;
                    String[] stringArray2 = test;
                    int n3 = test.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String t = stringArray2[n4];
                        if (i == 1) {
                            this.functions.add(new TreeNode((Object)t, t, true));
                        } else if (i > 1 && t.length() >= 1) {
                            TreeNode parent = this.functions.getChildAt(this.functions.getChildCount() - 1);
                            parent.add((TreeNode)new TreeDefinitionNode((Object)("function " + t), t, parent.getData().toString(), false));
                        }
                        ++i;
                        ++n4;
                    }
                    ++n2;
                }
            }
            this.functions.sortTree();
        }
    }

    protected void cleanupTrees() {
        int i = this.functions.getChildCount() - 1;
        while (i >= 0) {
            if (this.functions.getChildAt(i).getChildCount() == 0) {
                this.functions.remove(i);
            }
            if (this.probes.getChildAt(i).getChildCount() == 0) {
                this.probes.remove(i);
            }
            --i;
        }
        this.functions.sortTree();
        this.probes.sortTree();
        this.formatProbes();
    }

    private void formatProbes() {
        TreeNode probes2 = new TreeNode((Object)"", false);
        int i = 0;
        while (i < this.probes.getChildCount()) {
            TreeNode fileNode = this.probes.getChildAt(i);
            int j = 0;
            while (j < fileNode.getChildCount()) {
                TreeNode probe = fileNode.getChildAt(j);
                String directory = probe.toString();
                if (directory.endsWith(".return") || directory.endsWith(".entry")) {
                    directory = directory.substring(0, directory.lastIndexOf(46));
                }
                String[] folders = directory.split("\\.");
                TreeNode probeGroup = probes2;
                int k = 0;
                while (k < folders.length - 1) {
                    TreeNode probeFolder;
                    boolean added = false;
                    int l = 0;
                    while (l < probeGroup.getChildCount()) {
                        probeFolder = probeGroup.getChildAt(l);
                        if (probeFolder.toString().equals(folders[k])) {
                            probeGroup = probeFolder;
                            added = true;
                            break;
                        }
                        ++l;
                    }
                    if (!added) {
                        probeFolder = new TreeNode((Object)folders[k], false);
                        probeGroup.add(probeFolder);
                        probeGroup = probeFolder;
                    }
                    ++k;
                }
                probeGroup.add(probe);
                ++j;
            }
            ++i;
        }
        this.probes = probes2;
        this.probes.sortTree();
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.functions.dispose();
            this.functions = null;
            this.probes.dispose();
            this.probes = null;
            this.tapsets = null;
            this.listeners.clear();
            this.listeners = null;
        }
    }
}

