/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.tmf.core.component.TmfComponent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.filter.ITmfFilter;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterAndNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfDataRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.viewers.events.ITmfEventsFilterListener;
import org.eclipse.linuxtools.tmf.ui.viewers.events.ITmfEventsFilterProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsCache;
import org.eclipse.linuxtools.tmf.ui.views.colors.ColorSetting;
import org.eclipse.linuxtools.tmf.ui.views.colors.ColorSettingsManager;
import org.eclipse.linuxtools.tmf.ui.views.colors.IColorSettingsListener;
import org.eclipse.linuxtools.tmf.ui.views.filter.FilterManager;
import org.eclipse.linuxtools.tmf.ui.widgets.rawviewer.TmfRawEventViewer;
import org.eclipse.linuxtools.tmf.ui.widgets.virtualtable.ColumnData;
import org.eclipse.linuxtools.tmf.ui.widgets.virtualtable.TmfVirtualTable;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.themes.ColorUtil;

public class TmfEventsTable
extends TmfComponent
implements IGotoMarker,
IColorSettingsListener,
ITmfEventsFilterProvider {
    private static final Image BOOKMARK_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/bookmark_obj.gif");
    private static final Image SEARCH_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/search.gif");
    private static final Image SEARCH_MATCH_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/search_match.gif");
    private static final Image SEARCH_MATCH_BOOKMARK_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/search_match_bookmark.gif");
    private static final Image FILTER_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/filter_items.gif");
    private static final Image STOP_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/stop.gif");
    private static final String SEARCH_HINT = Messages.TmfEventsTable_SearchHint;
    private static final String FILTER_HINT = Messages.TmfEventsTable_FilterHint;
    private static final int MAX_CACHE_SIZE = 1000;
    protected Composite fComposite;
    protected SashForm fSashForm;
    protected TmfVirtualTable fTable;
    protected TmfRawEventViewer fRawViewer;
    protected ITmfTrace<?> fTrace;
    protected boolean fPackDone = false;
    protected HeaderState fHeaderState = HeaderState.SEARCH;
    protected long fSelectedRank = 0L;
    protected long fFilterMatchCount;
    protected long fFilterCheckCount;
    protected FilterThread fFilterThread;
    protected boolean fFilterThreadResume = false;
    protected final Object fFilterSyncObj = new Object();
    protected SearchThread fSearchThread;
    protected final Object fSearchSyncObj = new Object();
    protected List<ITmfEventsFilterListener> fEventsFilterListeners = new ArrayList<ITmfEventsFilterListener>();
    protected Map<Long, Long> fBookmarksMap = new HashMap<Long, Long>();
    protected IFile fBookmarksFile;
    protected long fPendingGotoRank = -1L;
    protected LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    protected Color fGrayColor;
    protected Color fGreenColor;
    protected Font fBoldFont;
    private static final String[] COLUMN_NAMES = new String[]{Messages.TmfEventsTable_TimestampColumnHeader, Messages.TmfEventsTable_SourceColumnHeader, Messages.TmfEventsTable_TypeColumnHeader, Messages.TmfEventsTable_ReferenceColumnHeader, Messages.TmfEventsTable_ContentColumnHeader};
    private static final ColumnData[] COLUMN_DATA = new ColumnData[]{new ColumnData(COLUMN_NAMES[0], 100, 16384), new ColumnData(COLUMN_NAMES[1], 100, 16384), new ColumnData(COLUMN_NAMES[2], 100, 16384), new ColumnData(COLUMN_NAMES[3], 100, 16384), new ColumnData(COLUMN_NAMES[4], 100, 16384)};
    private final TmfEventsCache fCache;
    private boolean fCacheUpdateBusy = false;
    private boolean fCacheUpdatePending = false;
    private boolean fCacheUpdateCompleted = false;
    private final Object fCacheUpdateSyncObj = new Object();
    private boolean fDisposeOnClose;

    public TmfEventsTable(Composite parent, int cacheSize) {
        this(parent, cacheSize, COLUMN_DATA);
    }

    public TmfEventsTable(Composite parent, int cacheSize, ColumnData[] columnData) {
        super("TmfEventsTable");
        this.fComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        this.fComposite.setLayout((Layout)gl);
        this.fSashForm = new SashForm(this.fComposite, 256);
        this.fSashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTable = new TmfVirtualTable((Composite)this.fSashForm, 66308);
        GridData layoutData = new GridData(4, 4, true, true);
        this.fTable.setLayoutData(layoutData);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        this.setColumnHeaders(columnData);
        if (Arrays.equals(columnData, COLUMN_DATA)) {
            this.fTable.getColumns()[0].setData("$field_id", (Object)":timestamp:");
            this.fTable.getColumns()[1].setData("$field_id", (Object)":source:");
            this.fTable.getColumns()[2].setData("$field_id", (Object)":type:");
            this.fTable.getColumns()[3].setData("$field_id", (Object)":reference:");
            this.fTable.getColumns()[4].setData("$field_id", (Object)":content:");
        }
        this.fTable.setFrozenRowCount(1);
        this.createHeaderEditor();
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selectedTableItem;
                TableItem[] selection = TmfEventsTable.this.fTable.getSelection();
                if (selection.length > 0 && (selectedTableItem = selection[0]) != null) {
                    if (selectedTableItem.getData("$rank") instanceof Long) {
                        TmfEventsTable.this.fSelectedRank = (Long)selectedTableItem.getData("$rank");
                        TmfEventsTable.this.fRawViewer.selectAndReveal((Long)selectedTableItem.getData("$rank"));
                    }
                    if (selectedTableItem.getData("$time") instanceof TmfTimestamp) {
                        TmfTimestamp ts = (TmfTimestamp)selectedTableItem.getData("$time");
                        TmfEventsTable.this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)TmfEventsTable.this, (ITmfTimestamp)ts));
                    }
                }
            }
        });
        cacheSize = Math.max(cacheSize, Display.getDefault().getBounds().height / this.fTable.getItemHeight());
        cacheSize = Math.min(cacheSize, 1000);
        this.fCache = new TmfEventsCache(cacheSize, this);
        this.fTable.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TmfEventsCache.CachedEvent cachedEvent;
                TableItem item = (TableItem)event.item;
                int index = event.index - 1;
                if (event.index == 0) {
                    TmfEventsTable.this.setHeaderRowItemData(item);
                    return;
                }
                if (TmfEventsTable.this.fTable.getData("$fltr_obj") != null) {
                    if (event.index == 1 || event.index == TmfEventsTable.this.fTable.getItemCount() - 1) {
                        TmfEventsTable.this.setFilterStatusRowItemData(item);
                        return;
                    }
                    --index;
                }
                if ((cachedEvent = TmfEventsTable.this.fCache.getEvent(index)) != null) {
                    TmfEventsTable.this.setItemData(item, cachedEvent.event, cachedEvent.rank);
                    return;
                }
                event.doit = false;
            }
        });
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (event.button != 1) {
                    return;
                }
                Point point = new Point(event.x, event.y);
                TableItem item = TmfEventsTable.this.fTable.getItem(point);
                if (item != null) {
                    Long rank;
                    Rectangle imageBounds = item.getImageBounds(0);
                    imageBounds.width = BOOKMARK_IMAGE.getBounds().width;
                    if (imageBounds.contains(point) && (rank = (Long)item.getData("$rank")) != null) {
                        TmfEventsTable.this.toggleBookmark(rank);
                    }
                }
            }
        });
        Listener tooltipListener = new Listener(){
            Shell tooltipShell = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 32: {
                        TableItem item = TmfEventsTable.this.fTable.getItem(new Point(event.x, event.y));
                        if (item == null) {
                            return;
                        }
                        Long rank = (Long)item.getData("$rank");
                        if (rank == null) {
                            return;
                        }
                        String tooltipText = (String)item.getData("$bookmark");
                        Rectangle bounds = item.getImageBounds(0);
                        bounds.width = BOOKMARK_IMAGE.getBounds().width;
                        if (!bounds.contains(event.x, event.y)) {
                            return;
                        }
                        if (this.tooltipShell != null && !this.tooltipShell.isDisposed()) {
                            this.tooltipShell.dispose();
                        }
                        this.tooltipShell = new Shell(TmfEventsTable.this.fTable.getShell(), 540676);
                        this.tooltipShell.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tooltipShell.setLayout((Layout)layout);
                        Label label = new Label((Composite)this.tooltipShell, 64);
                        String text = String.valueOf(rank.toString()) + (tooltipText != null ? ": " + tooltipText : "");
                        label.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(28));
                        label.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(29));
                        label.setText(text);
                        label.addListener(7, (Listener)this);
                        label.addListener(3, (Listener)this);
                        label.addListener(37, (Listener)this);
                        Point size = this.tooltipShell.computeSize(-1, -1);
                        int y = event.y;
                        if (System.getProperty("os.name").contains("Linux")) {
                            y += TmfEventsTable.this.fTable.getHeaderHeight();
                        }
                        Point pt = TmfEventsTable.this.fTable.toDisplay(event.x, y);
                        pt.x += BOOKMARK_IMAGE.getBounds().width;
                        pt.y += size.y;
                        this.tooltipShell.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tooltipShell.setVisible(true);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 12: 
                    case 37: {
                        if (this.tooltipShell == null) break;
                        this.tooltipShell.dispose();
                        this.tooltipShell = null;
                        break;
                    }
                }
            }
        };
        this.fTable.addListener(32, tooltipListener);
        this.fTable.addListener(12, tooltipListener);
        this.fTable.addListener(1, tooltipListener);
        this.fTable.addListener(5, tooltipListener);
        this.fTable.addListener(7, tooltipListener);
        this.fTable.addListener(3, tooltipListener);
        this.fTable.addListener(37, tooltipListener);
        this.createResources();
        ColorSettingsManager.addColorSettingsListener(this);
        this.fTable.setItemCount(1);
        this.fRawViewer = new TmfRawEventViewer((Composite)this.fSashForm, 768);
        this.fRawViewer.addSelectionListener(new Listener(){

            public void handleEvent(Event e) {
                TmfTimestamp ts;
                int index;
                long rank;
                if (e.data instanceof Long) {
                    rank = (Long)e.data;
                    index = (int)rank;
                    if (TmfEventsTable.this.fTable.getData("$fltr_obj") != null) {
                        index = TmfEventsTable.this.fCache.getFilteredEventIndex(rank) + 1;
                    }
                } else {
                    if (e.data instanceof ITmfLocation) {
                        return;
                    }
                    return;
                }
                TmfEventsTable.this.fTable.setSelection(index + 1);
                TmfEventsTable.this.fSelectedRank = rank;
                TableItem[] selection = TmfEventsTable.this.fTable.getSelection();
                if (selection != null && selection.length > 0 && (ts = (TmfTimestamp)TmfEventsTable.this.fTable.getSelection()[0].getData("$time")) != null) {
                    TmfEventsTable.this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)TmfEventsTable.this, (ITmfTimestamp)ts));
                }
            }
        });
        this.fSashForm.setWeights(new int[]{1, 1});
        this.fRawViewer.setVisible(false);
        this.createPopupMenu();
    }

    protected void createPopupMenu() {
        Action showTableAction = new Action(Messages.TmfEventsTable_ShowTableActionText){

            public void run() {
                TmfEventsTable.this.fTable.setVisible(true);
                TmfEventsTable.this.fSashForm.layout();
            }
        };
        Action hideTableAction = new Action(Messages.TmfEventsTable_HideTableActionText){

            public void run() {
                TmfEventsTable.this.fTable.setVisible(false);
                TmfEventsTable.this.fSashForm.layout();
            }
        };
        Action showRawAction = new Action(Messages.TmfEventsTable_ShowRawActionText){

            public void run() {
                TmfEventsTable.this.fRawViewer.setVisible(true);
                TmfEventsTable.this.fSashForm.layout();
                int index = TmfEventsTable.this.fTable.getSelectionIndex();
                if (index >= 1) {
                    TmfEventsTable.this.fRawViewer.selectAndReveal(index - 1);
                }
            }
        };
        Action hideRawAction = new Action(Messages.TmfEventsTable_HideRawActionText){

            public void run() {
                TmfEventsTable.this.fRawViewer.setVisible(false);
                TmfEventsTable.this.fSashForm.layout();
            }
        };
        Action showSearchBarAction = new Action(Messages.TmfEventsTable_ShowSearchBarActionText){

            public void run() {
                TmfEventsTable.this.fHeaderState = HeaderState.SEARCH;
                TmfEventsTable.this.fTable.refresh();
            }
        };
        Action showFilterBarAction = new Action(Messages.TmfEventsTable_ShowFilterBarActionText){

            public void run() {
                TmfEventsTable.this.fHeaderState = HeaderState.FILTER;
                TmfEventsTable.this.fTable.refresh();
            }
        };
        Action clearFiltersAction = new Action(Messages.TmfEventsTable_ClearFiltersActionText){

            public void run() {
                TmfEventsTable.this.clearFilters();
            }
        };
        final MenuManager tablePopupMenu = new MenuManager();
        tablePopupMenu.setRemoveAllWhenShown(true);
        tablePopupMenu.addMenuListener(new IMenuListener((IAction)showSearchBarAction, (IAction)showFilterBarAction, (IAction)hideTableAction, (IAction)hideRawAction, (IAction)showTableAction, (IAction)showRawAction, (IAction)clearFiltersAction){
            private final /* synthetic */ IAction val$showSearchBarAction;
            private final /* synthetic */ IAction val$showFilterBarAction;
            private final /* synthetic */ IAction val$hideTableAction;
            private final /* synthetic */ IAction val$hideRawAction;
            private final /* synthetic */ IAction val$showTableAction;
            private final /* synthetic */ IAction val$showRawAction;
            private final /* synthetic */ IAction val$clearFiltersAction;
            {
                this.val$showSearchBarAction = iAction;
                this.val$showFilterBarAction = iAction2;
                this.val$hideTableAction = iAction3;
                this.val$hideRawAction = iAction4;
                this.val$showTableAction = iAction5;
                this.val$showRawAction = iAction6;
                this.val$clearFiltersAction = iAction7;
            }

            public void menuAboutToShow(IMenuManager manager) {
                TableItem item;
                if (TmfEventsTable.this.fTable.getSelectionIndex() == 0) {
                    if (TmfEventsTable.this.fHeaderState == HeaderState.FILTER) {
                        tablePopupMenu.add(this.val$showSearchBarAction);
                    } else {
                        tablePopupMenu.add(this.val$showFilterBarAction);
                    }
                    return;
                }
                Point point = TmfEventsTable.this.fTable.toControl(Display.getDefault().getCursorLocation());
                TableItem tableItem = item = TmfEventsTable.this.fTable.getSelection().length > 0 ? TmfEventsTable.this.fTable.getSelection()[0] : null;
                if (item != null) {
                    Rectangle imageBounds = item.getImageBounds(0);
                    imageBounds.width = BOOKMARK_IMAGE.getBounds().width;
                    if (point.x <= imageBounds.x + imageBounds.width) {
                        Long rank = (Long)item.getData("$rank");
                        if (rank != null && TmfEventsTable.this.fBookmarksFile != null) {
                            class ToggleBookmarkAction
                            extends Action {
                                long fRank;

                                public ToggleBookmarkAction(String text, long rank) {
                                    super(text);
                                    this.fRank = rank;
                                }

                                public void run() {
                                    TmfEventsTable.this.toggleBookmark(this.fRank);
                                }
                            }
                            if (TmfEventsTable.this.fBookmarksMap.containsKey(rank)) {
                                tablePopupMenu.add((IAction)new ToggleBookmarkAction(Messages.TmfEventsTable_RemoveBookmarkActionText, rank));
                            } else {
                                tablePopupMenu.add((IAction)new ToggleBookmarkAction(Messages.TmfEventsTable_AddBookmarkActionText, rank));
                            }
                        }
                        return;
                    }
                }
                if (TmfEventsTable.this.fTable.isVisible() && TmfEventsTable.this.fRawViewer.isVisible()) {
                    tablePopupMenu.add(this.val$hideTableAction);
                    tablePopupMenu.add(this.val$hideRawAction);
                } else if (!TmfEventsTable.this.fTable.isVisible()) {
                    tablePopupMenu.add(this.val$showTableAction);
                } else if (!TmfEventsTable.this.fRawViewer.isVisible()) {
                    tablePopupMenu.add(this.val$showRawAction);
                }
                tablePopupMenu.add((IContributionItem)new Separator());
                tablePopupMenu.add(this.val$clearFiltersAction);
                ITmfFilterTreeNode[] savedFilters = FilterManager.getSavedFilters();
                if (savedFilters.length > 0) {
                    MenuManager subMenu = new MenuManager(Messages.TmfEventsTable_ApplyPresetFilterMenuName);
                    ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = savedFilters;
                    int n = savedFilters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
                        if (node instanceof TmfFilterNode) {
                            final TmfFilterNode filter = (TmfFilterNode)node;
                            subMenu.add((IAction)new Action(filter.getFilterName()){

                                public void run() {
                                    TmfEventsTable.this.applyFilter((ITmfFilter)filter);
                                }
                            });
                        }
                        ++n2;
                    }
                    tablePopupMenu.add((IContributionItem)subMenu);
                }
                TmfEventsTable.this.appendToTablePopupMenu(tablePopupMenu, item);
            }
        });
        final MenuManager rawViewerPopupMenu = new MenuManager();
        rawViewerPopupMenu.setRemoveAllWhenShown(true);
        rawViewerPopupMenu.addMenuListener(new IMenuListener((IAction)hideTableAction, (IAction)hideRawAction, (IAction)showTableAction, (IAction)showRawAction, tablePopupMenu){
            private final /* synthetic */ IAction val$hideTableAction;
            private final /* synthetic */ IAction val$hideRawAction;
            private final /* synthetic */ IAction val$showTableAction;
            private final /* synthetic */ IAction val$showRawAction;
            private final /* synthetic */ MenuManager val$tablePopupMenu;
            {
                this.val$hideTableAction = iAction;
                this.val$hideRawAction = iAction2;
                this.val$showTableAction = iAction3;
                this.val$showRawAction = iAction4;
                this.val$tablePopupMenu = menuManager2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                if (TmfEventsTable.this.fTable.isVisible() && TmfEventsTable.this.fRawViewer.isVisible()) {
                    rawViewerPopupMenu.add(this.val$hideTableAction);
                    rawViewerPopupMenu.add(this.val$hideRawAction);
                } else if (!TmfEventsTable.this.fTable.isVisible()) {
                    rawViewerPopupMenu.add(this.val$showTableAction);
                } else if (!TmfEventsTable.this.fRawViewer.isVisible()) {
                    rawViewerPopupMenu.add(this.val$showRawAction);
                }
                TmfEventsTable.this.appendToRawPopupMenu(this.val$tablePopupMenu);
            }
        });
        Menu menu = tablePopupMenu.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
        menu = rawViewerPopupMenu.createContextMenu((Control)this.fRawViewer);
        this.fRawViewer.setMenu(menu);
    }

    protected void appendToTablePopupMenu(MenuManager tablePopupMenu, TableItem selectedItem) {
    }

    protected void appendToRawPopupMenu(MenuManager rawViewerPopupMenu) {
    }

    public void dispose() {
        this.stopSearchThread();
        this.stopFilterThread();
        ColorSettingsManager.removeColorSettingsListener(this);
        this.fComposite.dispose();
        if (this.fTrace != null && this.fDisposeOnClose) {
            this.fTrace.dispose();
        }
        this.fResourceManager.dispose();
        super.dispose();
    }

    public void setLayoutData(Object layoutData) {
        this.fComposite.setLayoutData(layoutData);
    }

    public TmfVirtualTable getTable() {
        return this.fTable;
    }

    protected void setColumnHeaders(ColumnData[] columnData) {
        this.fTable.setColumnHeaders(columnData);
    }

    protected void setItemData(TableItem item, ITmfEvent event, long rank) {
        ITmfEventField[] fields = this.extractItemFields(event);
        String[] content = new String[fields.length];
        int i = 0;
        while (i < fields.length) {
            content[i] = fields[i].getValue() != null ? fields[i].getValue().toString() : "";
            ++i;
        }
        item.setText(content);
        item.setData("$time", (Object)new TmfTimestamp(event.getTimestamp()));
        item.setData("$rank", (Object)rank);
        boolean bookmark = false;
        Long markerId = this.fBookmarksMap.get(rank);
        if (markerId != null) {
            bookmark = true;
            try {
                IMarker marker = this.fBookmarksFile.findMarker(markerId.longValue());
                item.setData("$bookmark", marker.getAttribute("message"));
            }
            catch (CoreException e) {
                TmfEventsTable.displayException((Exception)((Object)e));
            }
        } else {
            item.setData("$bookmark", null);
        }
        boolean searchMatch = false;
        boolean searchNoMatch = false;
        ITmfFilter searchFilter = (ITmfFilter)this.fTable.getData("$srch_obj");
        if (searchFilter != null) {
            if (searchFilter.matches(event)) {
                searchMatch = true;
            } else {
                searchNoMatch = true;
            }
        }
        ColorSetting colorSetting = ColorSettingsManager.getColorSetting(event);
        if (searchNoMatch) {
            item.setForeground(colorSetting.getDimmedForegroundColor());
            item.setBackground(colorSetting.getDimmedBackgroundColor());
        } else {
            item.setForeground(colorSetting.getForegroundColor());
            item.setBackground(colorSetting.getBackgroundColor());
        }
        if (searchMatch) {
            if (bookmark) {
                item.setImage(SEARCH_MATCH_BOOKMARK_IMAGE);
            } else {
                item.setImage(SEARCH_MATCH_IMAGE);
            }
        } else if (bookmark) {
            item.setImage(BOOKMARK_IMAGE);
        } else {
            item.setImage(null);
        }
    }

    protected void setHeaderRowItemData(TableItem item) {
        String txtKey = null;
        if (this.fHeaderState == HeaderState.SEARCH) {
            item.setImage(SEARCH_IMAGE);
            txtKey = "$srch_txt";
        } else if (this.fHeaderState == HeaderState.FILTER) {
            item.setImage(FILTER_IMAGE);
            txtKey = "$fltr_txt";
        }
        item.setForeground(this.fGrayColor);
        int i = 0;
        while (i < this.fTable.getColumns().length) {
            TableColumn column = this.fTable.getColumns()[i];
            String filter = (String)column.getData(txtKey);
            if (filter == null) {
                if (this.fHeaderState == HeaderState.SEARCH) {
                    item.setText(i, SEARCH_HINT);
                } else if (this.fHeaderState == HeaderState.FILTER) {
                    item.setText(i, FILTER_HINT);
                }
                item.setForeground(i, this.fGrayColor);
                item.setFont(i, this.fTable.getFont());
            } else {
                item.setText(i, filter);
                item.setForeground(i, this.fGreenColor);
                item.setFont(i, this.fBoldFont);
            }
            ++i;
        }
    }

    protected void setFilterStatusRowItemData(TableItem item) {
        int i = 0;
        while (i < this.fTable.getColumns().length) {
            if (i == 0) {
                if (this.fTrace == null || this.fFilterCheckCount == this.fTrace.getNbEvents()) {
                    item.setImage(FILTER_IMAGE);
                } else {
                    item.setImage(STOP_IMAGE);
                }
                item.setText(0, String.valueOf(this.fFilterMatchCount) + "/" + this.fFilterCheckCount);
            } else {
                item.setText(i, "");
            }
            ++i;
        }
        item.setData("$time", null);
        item.setData("$rank", null);
        item.setForeground(null);
        item.setBackground(null);
    }

    protected void createHeaderEditor() {
        final TableEditor tableEditor = this.fTable.createTableEditor();
        tableEditor.horizontalAlignment = 16384;
        tableEditor.verticalAlignment = 0x1000000;
        tableEditor.grabHorizontal = true;
        tableEditor.minimumWidth = 50;
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){
            int columnIndex;
            TableColumn column;
            TableItem item;

            public void mouseDown(MouseEvent event) {
                if (event.button != 1) {
                    return;
                }
                Point point = new Point(event.x, event.y);
                this.item = TmfEventsTable.this.fTable.getItem(point);
                if (this.item != null && TmfEventsTable.this.fTable.indexOf(this.item) == 0) {
                    if (this.item.getImageBounds(0).contains(point)) {
                        if (TmfEventsTable.this.fHeaderState == HeaderState.SEARCH) {
                            TmfEventsTable.this.fHeaderState = HeaderState.FILTER;
                        } else if (TmfEventsTable.this.fHeaderState == HeaderState.FILTER) {
                            TmfEventsTable.this.fHeaderState = HeaderState.SEARCH;
                        }
                        TmfEventsTable.this.fTable.refresh();
                        return;
                    }
                    this.columnIndex = -1;
                    int i = 0;
                    while (i < TmfEventsTable.this.fTable.getColumns().length) {
                        Rectangle rect = this.item.getBounds(i);
                        if (rect.contains(point)) {
                            this.columnIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (this.columnIndex == -1) {
                        return;
                    }
                    this.column = TmfEventsTable.this.fTable.getColumns()[this.columnIndex];
                    String txtKey = null;
                    if (TmfEventsTable.this.fHeaderState == HeaderState.SEARCH) {
                        txtKey = "$srch_txt";
                    } else if (TmfEventsTable.this.fHeaderState == HeaderState.FILTER) {
                        txtKey = "$fltr_txt";
                    }
                    final Text newEditor = (Text)TmfEventsTable.this.fTable.createTableEditorControl(Text.class);
                    String headerString = (String)this.column.getData(txtKey);
                    if (headerString != null) {
                        newEditor.setText(headerString);
                    }
                    newEditor.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent e) {
                            boolean changed = this.updateHeader(newEditor.getText());
                            if (changed) {
                                this.applyHeader();
                            }
                        }
                    });
                    newEditor.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            if (e.character == '\r') {
                                this.updateHeader(newEditor.getText());
                                this.applyHeader();
                            } else if (e.character == '\u001b') {
                                tableEditor.getEditor().dispose();
                            }
                        }
                    });
                    newEditor.selectAll();
                    newEditor.setFocus();
                    tableEditor.setEditor((Control)newEditor, this.item, this.columnIndex);
                }
            }

            private boolean updateHeader(String text) {
                String objKey = null;
                String txtKey = null;
                if (TmfEventsTable.this.fHeaderState == HeaderState.SEARCH) {
                    objKey = "$srch_obj";
                    txtKey = "$srch_txt";
                } else if (TmfEventsTable.this.fHeaderState == HeaderState.FILTER) {
                    objKey = "$fltr_obj";
                    txtKey = "$fltr_txt";
                }
                if (text.trim().length() > 0) {
                    String regex;
                    block9: {
                        try {
                            regex = TmfFilterMatchesNode.regexFix((String)text);
                            Pattern.compile(regex);
                            if (!regex.equals(this.column.getData(txtKey))) break block9;
                            tableEditor.getEditor().dispose();
                            return false;
                        }
                        catch (PatternSyntaxException ex) {
                            tableEditor.getEditor().dispose();
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ex.getDescription(), (String)ex.getMessage());
                            return false;
                        }
                    }
                    TmfFilterMatchesNode filter = new TmfFilterMatchesNode(null);
                    String fieldId = (String)this.column.getData("$field_id");
                    if (fieldId == null) {
                        fieldId = this.column.getText();
                    }
                    filter.setField(fieldId);
                    filter.setRegex(regex);
                    this.column.setData(objKey, (Object)filter);
                    this.column.setData(txtKey, (Object)regex);
                }
                if (this.column.getData(txtKey) == null) {
                    tableEditor.getEditor().dispose();
                    return false;
                }
                this.column.setData(objKey, null);
                this.column.setData(txtKey, null);
                return true;
            }

            private void applyHeader() {
                if (TmfEventsTable.this.fHeaderState == HeaderState.SEARCH) {
                    TmfEventsTable.this.stopSearchThread();
                    TmfFilterAndNode filter = new TmfFilterAndNode(null);
                    TableColumn[] tableColumnArray = TmfEventsTable.this.fTable.getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn column = tableColumnArray[n2];
                        Object filterObj = column.getData("$srch_obj");
                        if (filterObj instanceof ITmfFilterTreeNode) {
                            filter.addChild((ITmfFilterTreeNode)filterObj);
                        }
                        ++n2;
                    }
                    if (filter.getChildrenCount() > 0) {
                        TmfEventsTable.this.fTable.setData("$srch_obj", filter);
                        TmfEventsTable.this.fTable.refresh();
                        TmfEventsTable.this.searchNext();
                        TmfEventsTable.this.fireSearchApplied((ITmfFilter)filter);
                    } else {
                        TmfEventsTable.this.fTable.setData("$srch_obj", null);
                        TmfEventsTable.this.fTable.refresh();
                        TmfEventsTable.this.fireSearchApplied(null);
                    }
                } else if (TmfEventsTable.this.fHeaderState == HeaderState.FILTER) {
                    TmfFilterAndNode filter = new TmfFilterAndNode(null);
                    TableColumn[] tableColumnArray = TmfEventsTable.this.fTable.getColumns();
                    int n = tableColumnArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TableColumn column = tableColumnArray[n3];
                        Object filterObj = column.getData("$fltr_obj");
                        if (filterObj instanceof ITmfFilterTreeNode) {
                            filter.addChild((ITmfFilterTreeNode)filterObj);
                        }
                        ++n3;
                    }
                    if (filter.getChildrenCount() > 0) {
                        TmfEventsTable.this.applyFilter((ITmfFilter)filter);
                    } else {
                        TmfEventsTable.this.clearFilters();
                    }
                }
                tableEditor.getEditor().dispose();
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                e.doit = false;
                if (e.character == '\u001b') {
                    TmfEventsTable.this.stopFilterThread();
                    TmfEventsTable.this.stopSearchThread();
                    TmfEventsTable.this.fTable.refresh();
                } else if (e.character == '\u007f') {
                    if (TmfEventsTable.this.fHeaderState == HeaderState.SEARCH) {
                        TmfEventsTable.this.stopSearchThread();
                        TableColumn[] tableColumnArray = TmfEventsTable.this.fTable.getColumns();
                        int n = tableColumnArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableColumn column = tableColumnArray[n2];
                            column.setData("$srch_obj", null);
                            column.setData("$srch_txt", null);
                            ++n2;
                        }
                        TmfEventsTable.this.fTable.setData("$srch_obj", null);
                        TmfEventsTable.this.fTable.refresh();
                        TmfEventsTable.this.fireSearchApplied(null);
                    } else if (TmfEventsTable.this.fHeaderState == HeaderState.FILTER) {
                        TmfEventsTable.this.clearFilters();
                    }
                } else if (e.character == '\r') {
                    if ((e.stateMask & 0x20000) == 0) {
                        TmfEventsTable.this.searchNext();
                    } else {
                        TmfEventsTable.this.searchPrevious();
                    }
                }
            }
        });
    }

    protected void fireFilterApplied(ITmfFilter filter) {
        for (ITmfEventsFilterListener listener : this.fEventsFilterListeners) {
            listener.filterApplied(filter, this.fTrace);
        }
    }

    protected void fireSearchApplied(ITmfFilter filter) {
        for (ITmfEventsFilterListener listener : this.fEventsFilterListeners) {
            listener.searchApplied(filter, this.fTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startFilterThread() {
        Object object = this.fFilterSyncObj;
        synchronized (object) {
            ITmfFilterTreeNode filter = (ITmfFilterTreeNode)this.fTable.getData("$fltr_obj");
            if (this.fFilterThread == null || this.fFilterThread.filter != filter) {
                if (this.fFilterThread != null) {
                    this.fFilterThread.cancel();
                    this.fFilterThreadResume = false;
                }
                this.fFilterThread = new FilterThread(filter);
                this.fFilterThread.start();
            } else {
                this.fFilterThreadResume = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopFilterThread() {
        Object object = this.fFilterSyncObj;
        synchronized (object) {
            if (this.fFilterThread != null) {
                this.fFilterThread.cancel();
                this.fFilterThread = null;
                this.fFilterThreadResume = false;
            }
        }
    }

    protected void applyFilter(ITmfFilter filter) {
        this.stopFilterThread();
        this.stopSearchThread();
        this.fFilterMatchCount = 0L;
        this.fFilterCheckCount = 0L;
        this.fCache.applyFilter(filter);
        this.fTable.clearAll();
        this.fTable.setData("$fltr_obj", filter);
        this.fTable.setItemCount(3);
        this.startFilterThread();
        this.fireFilterApplied(filter);
    }

    protected void clearFilters() {
        if (this.fTable.getData("$fltr_obj") == null) {
            return;
        }
        this.stopFilterThread();
        this.stopSearchThread();
        this.fCache.clearFilter();
        this.fTable.clearAll();
        TableColumn[] tableColumnArray = this.fTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setData("$fltr_obj", null);
            column.setData("$fltr_txt", null);
            ++n2;
        }
        this.fTable.setData("$fltr_obj", null);
        if (this.fTrace != null) {
            this.fTable.setItemCount((int)this.fTrace.getNbEvents() + 1);
        } else {
            this.fTable.setItemCount(1);
        }
        this.fFilterMatchCount = 0L;
        this.fFilterCheckCount = 0L;
        if (this.fSelectedRank >= 0L) {
            this.fTable.setSelection((int)this.fSelectedRank + 1);
        } else {
            this.fTable.setSelection(0);
        }
        this.fireFilterApplied(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void searchNext() {
        Object object = this.fSearchSyncObj;
        synchronized (object) {
            if (this.fSearchThread != null) {
                return;
            }
            ITmfFilterTreeNode searchFilter = (ITmfFilterTreeNode)this.fTable.getData("$srch_obj");
            if (searchFilter == null) {
                return;
            }
            int selectionIndex = this.fTable.getSelectionIndex();
            int startIndex = selectionIndex > 0 ? selectionIndex : Math.max(0, this.fTable.getTopIndex() - 1);
            ITmfFilterTreeNode eventFilter = (ITmfFilterTreeNode)this.fTable.getData("$fltr_obj");
            if (eventFilter != null) {
                startIndex = Math.max(0, startIndex - 1);
            }
            this.fSearchThread = new SearchThread(searchFilter, eventFilter, startIndex, this.fSelectedRank, 1);
            this.fSearchThread.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void searchPrevious() {
        Object object = this.fSearchSyncObj;
        synchronized (object) {
            if (this.fSearchThread != null) {
                return;
            }
            ITmfFilterTreeNode searchFilter = (ITmfFilterTreeNode)this.fTable.getData("$srch_obj");
            if (searchFilter == null) {
                return;
            }
            int selectionIndex = this.fTable.getSelectionIndex();
            int startIndex = selectionIndex > 0 ? selectionIndex - 2 : this.fTable.getTopIndex() - 2;
            ITmfFilterTreeNode eventFilter = (ITmfFilterTreeNode)this.fTable.getData("$fltr_obj");
            if (eventFilter != null) {
                --startIndex;
            }
            this.fSearchThread = new SearchThread(searchFilter, eventFilter, startIndex, this.fSelectedRank, -1);
            this.fSearchThread.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopSearchThread() {
        this.fPendingGotoRank = -1L;
        Object object = this.fSearchSyncObj;
        synchronized (object) {
            if (this.fSearchThread != null) {
                this.fSearchThread.cancel();
                this.fSearchThread = null;
            }
        }
    }

    protected void createResources() {
        this.fGrayColor = this.fResourceManager.createColor(ColorUtil.blend((RGB)this.fTable.getBackground().getRGB(), (RGB)this.fTable.getForeground().getRGB()));
        this.fGreenColor = this.fTable.getDisplay().getSystemColor(6);
        this.fBoldFont = this.fResourceManager.createFont(FontDescriptor.createFrom((Font)this.fTable.getFont()).setStyle(1));
    }

    protected void packColumns() {
        if (this.fPackDone) {
            return;
        }
        TableColumn[] tableColumnArray = this.fTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            int headerWidth = column.getWidth();
            column.pack();
            if (column.getWidth() < headerWidth) {
                column.setWidth(headerWidth);
            }
            ++n2;
        }
        this.fPackDone = true;
    }

    protected ITmfEventField[] extractItemFields(ITmfEvent event) {
        TmfEventField[] fields = new TmfEventField[]{};
        if (event != null) {
            String timestamp = event.getTimestamp().toString();
            String source = event.getSource();
            String type = event.getType().getName();
            String reference = event.getReference();
            ITmfEventField content = event.getContent();
            String value = content.getValue() != null ? content.getValue().toString() : content.toString();
            fields = new TmfEventField[]{new TmfEventField(":timestamp:", (Object)timestamp), new TmfEventField(":source:", (Object)source), new TmfEventField(":type:", (Object)type), new TmfEventField(":reference:", (Object)reference), new TmfEventField(":content:", (Object)value)};
        }
        return fields;
    }

    public void setFocus() {
        this.fTable.setFocus();
    }

    public void setTrace(ITmfTrace<?> trace, boolean disposeOnClose) {
        if (this.fTrace != null && this.fDisposeOnClose) {
            this.fTrace.dispose();
        }
        this.fTrace = trace;
        this.fPackDone = false;
        this.fSelectedRank = 0L;
        this.fDisposeOnClose = disposeOnClose;
        this.fTable.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TmfEventsTable.this.fTable.removeAll();
                TmfEventsTable.this.fCache.setTrace(TmfEventsTable.this.fTrace);
                if (TmfEventsTable.this.fTrace != null) {
                    if (!TmfEventsTable.this.fTable.isDisposed() && TmfEventsTable.this.fTrace != null) {
                        if (TmfEventsTable.this.fTable.getData("$fltr_obj") == null) {
                            TmfEventsTable.this.fTable.setItemCount((int)TmfEventsTable.this.fTrace.getNbEvents() + 1);
                        } else {
                            TmfEventsTable.this.stopFilterThread();
                            TmfEventsTable.this.fFilterMatchCount = 0L;
                            TmfEventsTable.this.fFilterCheckCount = 0L;
                            TmfEventsTable.this.fTable.setItemCount(3);
                            TmfEventsTable.this.startFilterThread();
                        }
                    }
                    TmfEventsTable.this.fRawViewer.setTrace(TmfEventsTable.this.fTrace);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheUpdated(final boolean completed) {
        Object object = this.fCacheUpdateSyncObj;
        synchronized (object) {
            if (this.fCacheUpdateBusy) {
                this.fCacheUpdatePending = true;
                this.fCacheUpdateCompleted = completed;
                return;
            }
            this.fCacheUpdateBusy = true;
        }
        if (!this.fTable.isDisposed()) {
            this.fTable.getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!TmfEventsTable.this.fTable.isDisposed()) {
                        TmfEventsTable.this.fTable.refresh();
                        TmfEventsTable.this.packColumns();
                    }
                    if (completed) {
                        TmfEventsTable.this.populateCompleted();
                    }
                    Object object = TmfEventsTable.this.fCacheUpdateSyncObj;
                    synchronized (object) {
                        TmfEventsTable.this.fCacheUpdateBusy = false;
                        if (TmfEventsTable.this.fCacheUpdatePending) {
                            TmfEventsTable.this.fCacheUpdatePending = false;
                            TmfEventsTable.this.cacheUpdated(TmfEventsTable.this.fCacheUpdateCompleted);
                        }
                    }
                }
            });
        }
    }

    protected void populateCompleted() {
    }

    public void addBookmark(IFile bookmarksFile) {
        TableItem tableItem;
        this.fBookmarksFile = bookmarksFile;
        TableItem[] selection = this.fTable.getSelection();
        if (selection.length > 0 && (tableItem = selection[0]).getData("$rank") != null) {
            StringBuffer defaultMessage = new StringBuffer();
            int i = 0;
            while (i < this.fTable.getColumns().length) {
                if (i > 0) {
                    defaultMessage.append(", ");
                }
                defaultMessage.append(tableItem.getText(i));
                ++i;
            }
            InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.TmfEventsTable_AddBookmarkDialogTitle, Messages.TmfEventsTable_AddBookmarkDialogText, defaultMessage.toString(), null);
            if (dialog.open() == 0) {
                String message = dialog.getValue();
                try {
                    IMarker bookmark = bookmarksFile.createMarker("org.eclipse.core.resources.bookmark");
                    if (bookmark.exists()) {
                        bookmark.setAttribute("message", (Object)message.toString());
                        long rank = (Long)tableItem.getData("$rank");
                        int location = (int)rank;
                        bookmark.setAttribute("location", (Object)location);
                        this.fBookmarksMap.put(rank, bookmark.getId());
                        this.fTable.refresh();
                    }
                }
                catch (CoreException e) {
                    TmfEventsTable.displayException((Exception)((Object)e));
                }
            }
        }
    }

    public void removeBookmark(IMarker bookmark) {
        for (Map.Entry<Long, Long> entry : this.fBookmarksMap.entrySet()) {
            if (!entry.getValue().equals(bookmark.getId())) continue;
            this.fBookmarksMap.remove(entry.getKey());
            this.fTable.refresh();
            return;
        }
    }

    private void toggleBookmark(long rank) {
        if (this.fBookmarksFile == null) {
            return;
        }
        if (this.fBookmarksMap.containsKey(rank)) {
            Long markerId = this.fBookmarksMap.remove(rank);
            this.fTable.refresh();
            try {
                IMarker bookmark = this.fBookmarksFile.findMarker(markerId.longValue());
                if (bookmark != null) {
                    bookmark.delete();
                }
            }
            catch (CoreException e) {
                TmfEventsTable.displayException((Exception)((Object)e));
            }
        } else {
            this.addBookmark(this.fBookmarksFile);
        }
    }

    public void refreshBookmarks(IFile bookmarksFile) {
        this.fBookmarksFile = bookmarksFile;
        if (bookmarksFile == null) {
            this.fBookmarksMap.clear();
            this.fTable.refresh();
            return;
        }
        try {
            this.fBookmarksMap.clear();
            IMarker[] iMarkerArray = bookmarksFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker bookmark = iMarkerArray[n2];
                int location = bookmark.getAttribute("location", -1);
                if (location != -1) {
                    long rank = location;
                    this.fBookmarksMap.put(rank, bookmark.getId());
                }
                ++n2;
            }
            this.fTable.refresh();
        }
        catch (CoreException e) {
            TmfEventsTable.displayException((Exception)((Object)e));
        }
    }

    public void gotoMarker(IMarker marker) {
        int rank = marker.getAttribute("location", -1);
        if (rank != -1) {
            int index = rank;
            if (this.fTable.getData("$fltr_obj") != null) {
                index = this.fCache.getFilteredEventIndex(rank) + 1;
            } else if (rank >= this.fTable.getItemCount()) {
                this.fPendingGotoRank = rank;
            }
            this.fTable.setSelection(index + 1);
        }
    }

    @Override
    public void colorSettingsChanged(ColorSetting[] colorSettings) {
        this.fTable.refresh();
    }

    @Override
    public void addEventsFilterListener(ITmfEventsFilterListener listener) {
        if (!this.fEventsFilterListeners.contains(listener)) {
            this.fEventsFilterListeners.add(listener);
        }
    }

    @Override
    public void removeEventsFilterListener(ITmfEventsFilterListener listener) {
        this.fEventsFilterListeners.remove(listener);
    }

    @TmfSignalHandler
    public void experimentUpdated(TmfExperimentUpdatedSignal signal) {
        if (signal.getExperiment() != this.fTrace || this.fTable.isDisposed()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!TmfEventsTable.this.fTable.isDisposed() && TmfEventsTable.this.fTrace != null) {
                    if (TmfEventsTable.this.fTable.getData("$fltr_obj") == null) {
                        TmfEventsTable.this.fTable.setItemCount((int)TmfEventsTable.this.fTrace.getNbEvents() + 1);
                        if (TmfEventsTable.this.fPendingGotoRank != -1L && TmfEventsTable.this.fPendingGotoRank + 1L < (long)TmfEventsTable.this.fTable.getItemCount()) {
                            TmfEventsTable.this.fTable.setSelection((int)TmfEventsTable.this.fPendingGotoRank + 1);
                            TmfEventsTable.this.fPendingGotoRank = -1L;
                        }
                    } else {
                        TmfEventsTable.this.startFilterThread();
                    }
                }
                if (!TmfEventsTable.this.fRawViewer.isDisposed() && TmfEventsTable.this.fTrace != null) {
                    TmfEventsTable.this.fRawViewer.refreshEventCount();
                }
            }
        });
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (signal.getTrace() != this.fTrace || this.fTable.isDisposed()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!TmfEventsTable.this.fTable.isDisposed() && TmfEventsTable.this.fTrace != null) {
                    if (TmfEventsTable.this.fTable.getData("$fltr_obj") == null) {
                        TmfEventsTable.this.fTable.setItemCount((int)TmfEventsTable.this.fTrace.getNbEvents() + 1);
                        if (TmfEventsTable.this.fPendingGotoRank != -1L && TmfEventsTable.this.fPendingGotoRank + 1L < (long)TmfEventsTable.this.fTable.getItemCount()) {
                            TmfEventsTable.this.fTable.setSelection((int)TmfEventsTable.this.fPendingGotoRank + 1);
                            TmfEventsTable.this.fPendingGotoRank = -1L;
                        }
                    } else {
                        TmfEventsTable.this.startFilterThread();
                    }
                }
                if (!TmfEventsTable.this.fRawViewer.isDisposed() && TmfEventsTable.this.fTrace != null) {
                    TmfEventsTable.this.fRawViewer.refreshEventCount();
                }
            }
        });
    }

    @TmfSignalHandler
    public void currentTimeUpdated(TmfTimeSynchSignal signal) {
        if (signal.getSource() != this && this.fTrace != null && !this.fTable.isDisposed()) {
            TmfDataRequest<ITmfEvent> subRequest = new TmfDataRequest<ITmfEvent>(ITmfEvent.class, 0L, 1, ITmfDataRequest.ExecutionType.FOREGROUND, signal){
                TmfTimestamp ts;
                {
                    this.ts = new TmfTimestamp(tmfTimeSynchSignal.getCurrentTime());
                }

                public void handleData(ITmfEvent event) {
                    super.handleData(event);
                }

                public void handleCompleted() {
                    super.handleCompleted();
                    if (TmfEventsTable.this.fTrace == null) {
                        return;
                    }
                    TmfTimestamp timestamp = this.ts;
                    if (timestamp.compareTo(TmfEventsTable.this.fTrace.getStartTime(), true) == -1) {
                        timestamp = TmfEventsTable.this.fTrace.getStartTime();
                    }
                    if (timestamp.compareTo(TmfEventsTable.this.fTrace.getEndTime(), true) == 1) {
                        timestamp = TmfEventsTable.this.fTrace.getEndTime();
                    }
                    ITmfContext context = TmfEventsTable.this.fTrace.seekEvent((ITmfTimestamp)timestamp);
                    final long rank = context.getRank();
                    context.dispose();
                    TmfEventsTable.this.fSelectedRank = rank;
                    TmfEventsTable.this.fTable.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TmfEventsTable.this.fTable.isDisposed()) {
                                return;
                            }
                            int index = (int)rank;
                            if ((this).TmfEventsTable.this.fTable.isDisposed()) {
                                return;
                            }
                            if ((this).TmfEventsTable.this.fTable.getData("$fltr_obj") != null) {
                                index = TmfEventsTable.this.fCache.getFilteredEventIndex(rank) + 1;
                            }
                            (this).TmfEventsTable.this.fTable.setSelection(index + 1);
                            (this).TmfEventsTable.this.fRawViewer.selectAndReveal(rank);
                        }
                    });
                }
            };
            this.fTrace.sendRequest((ITmfDataRequest)subRequest);
        }
    }

    private static void displayException(Exception e) {
        MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        mb.setText(e.getClass().getName());
        mb.setMessage(e.getMessage());
        mb.open();
    }

    static interface Direction {
        public static final int FORWARD = 1;
        public static final int BACKWARD = -1;
    }

    protected class FilterThread
    extends Thread {
        private final ITmfFilterTreeNode filter;
        private TmfDataRequest<ITmfEvent> request;
        private boolean refreshBusy;
        private boolean refreshPending;
        private final Object syncObj;

        public FilterThread(ITmfFilterTreeNode filter) {
            super("Filter Thread");
            this.refreshBusy = false;
            this.refreshPending = false;
            this.syncObj = new Object();
            this.filter = filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TmfEventsTable.this.fTrace == null) {
                return;
            }
            int nbRequested = (int)(TmfEventsTable.this.fTrace.getNbEvents() - TmfEventsTable.this.fFilterCheckCount);
            if (nbRequested <= 0) {
                return;
            }
            this.request = new TmfDataRequest<ITmfEvent>(ITmfEvent.class, (long)((int)TmfEventsTable.this.fFilterCheckCount), nbRequested, TmfEventsTable.this.fTrace.getCacheSize(), ITmfDataRequest.ExecutionType.BACKGROUND){

                public void handleData(ITmfEvent event) {
                    super.handleData(event);
                    if (FilterThread.this.request.isCancelled()) {
                        return;
                    }
                    if (FilterThread.this.filter.matches(event)) {
                        long rank = ((FilterThread)FilterThread.this).TmfEventsTable.this.fFilterCheckCount;
                        int index = (int)((FilterThread)FilterThread.this).TmfEventsTable.this.fFilterMatchCount;
                        ++((FilterThread)FilterThread.this).TmfEventsTable.this.fFilterMatchCount;
                        TmfEventsTable.this.fCache.storeEvent(event.clone(), rank, index);
                        FilterThread.this.refreshTable();
                    } else if (((FilterThread)FilterThread.this).TmfEventsTable.this.fFilterCheckCount % 100L == 0L) {
                        FilterThread.this.refreshTable();
                    }
                    ++((FilterThread)FilterThread.this).TmfEventsTable.this.fFilterCheckCount;
                }
            };
            TmfEventsTable.this.fTrace.sendRequest(this.request);
            try {
                this.request.waitForCompletion();
            }
            catch (InterruptedException interruptedException) {}
            this.refreshTable();
            Object object = TmfEventsTable.this.fFilterSyncObj;
            synchronized (object) {
                TmfEventsTable.this.fFilterThread = null;
                if (TmfEventsTable.this.fFilterThreadResume) {
                    TmfEventsTable.this.fFilterThreadResume = false;
                    TmfEventsTable.this.fFilterThread = new FilterThread(this.filter);
                    TmfEventsTable.this.fFilterThread.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshTable() {
            Object object = this.syncObj;
            synchronized (object) {
                if (this.refreshBusy) {
                    this.refreshPending = true;
                    return;
                }
                this.refreshBusy = true;
            }
            Display.getDefault().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (FilterThread.this.request.isCancelled()) {
                        return;
                    }
                    if (((FilterThread)FilterThread.this).TmfEventsTable.this.fTable.isDisposed()) {
                        return;
                    }
                    ((FilterThread)FilterThread.this).TmfEventsTable.this.fTable.setItemCount((int)((FilterThread)FilterThread.this).TmfEventsTable.this.fFilterMatchCount + 3);
                    ((FilterThread)FilterThread.this).TmfEventsTable.this.fTable.refresh();
                    Object object = FilterThread.this.syncObj;
                    synchronized (object) {
                        FilterThread.this.refreshBusy = false;
                        if (FilterThread.this.refreshPending) {
                            FilterThread.this.refreshPending = false;
                            FilterThread.this.refreshTable();
                        }
                    }
                }
            });
        }

        public void cancel() {
            if (this.request != null) {
                this.request.cancel();
            }
        }
    }

    public static enum HeaderState {
        SEARCH,
        FILTER;

    }

    public static interface Key {
        public static final String SEARCH_TXT = "$srch_txt";
        public static final String SEARCH_OBJ = "$srch_obj";
        public static final String FILTER_TXT = "$fltr_txt";
        public static final String FILTER_OBJ = "$fltr_obj";
        public static final String TIMESTAMP = "$time";
        public static final String RANK = "$rank";
        public static final String FIELD_ID = "$field_id";
        public static final String BOOKMARK = "$bookmark";
    }

    protected class SearchThread
    extends Job {
        protected ITmfFilterTreeNode searchFilter;
        protected ITmfFilterTreeNode eventFilter;
        protected int startIndex;
        protected int direction;
        protected long rank;
        protected long foundRank;
        protected TmfDataRequest<ITmfEvent> request;
        private ITmfTimestamp foundTimestamp;

        public SearchThread(ITmfFilterTreeNode searchFilter, ITmfFilterTreeNode eventFilter, int startIndex, long currentRank, int direction) {
            super(Messages.TmfEventsTable_SearchingJobName);
            this.foundRank = -1L;
            this.foundTimestamp = null;
            this.searchFilter = searchFilter;
            this.eventFilter = eventFilter;
            this.startIndex = startIndex;
            this.rank = currentRank;
            this.direction = direction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(final IProgressMonitor monitor) {
            if (TmfEventsTable.this.fTrace == null) {
                return Status.OK_STATUS;
            }
            Display display = Display.getDefault();
            if (this.startIndex < 0) {
                this.rank = (int)TmfEventsTable.this.fTrace.getNbEvents() - 1;
            } else if (this.startIndex >= TmfEventsTable.this.fTable.getItemCount() - (this.eventFilter == null ? 1 : 3)) {
                this.rank = 0L;
            } else {
                int idx = this.startIndex;
                while (this.foundRank == -1L) {
                    TmfEventsCache.CachedEvent event = TmfEventsTable.this.fCache.peekEvent(idx);
                    if (event == null) break;
                    this.rank = event.rank;
                    if (this.searchFilter.matches(event.event) && (this.eventFilter == null || this.eventFilter.matches(event.event))) {
                        this.foundRank = event.rank;
                        this.foundTimestamp = event.event.getTimestamp();
                        break;
                    }
                    if (this.direction == 1) {
                        ++idx;
                        continue;
                    }
                    --idx;
                }
                if (this.foundRank == -1L) {
                    if (this.direction == 1) {
                        ++this.rank;
                        if (this.rank > TmfEventsTable.this.fTrace.getNbEvents() - 1L) {
                            this.rank = 0L;
                        }
                    } else {
                        --this.rank;
                        if (this.rank < 0L) {
                            this.rank = (int)TmfEventsTable.this.fTrace.getNbEvents() - 1;
                        }
                    }
                }
            }
            int startRank = (int)this.rank;
            boolean wrapped = false;
            while (!monitor.isCanceled() && this.foundRank == -1L && TmfEventsTable.this.fTrace != null) {
                int nbRequested;
                int n = nbRequested = this.direction == 1 ? Integer.MAX_VALUE : Math.min((int)this.rank + 1, TmfEventsTable.this.fTrace.getCacheSize());
                if (this.direction == -1) {
                    this.rank = Math.max(0L, this.rank - (long)TmfEventsTable.this.fTrace.getCacheSize() + 1L);
                }
                this.request = new TmfDataRequest<ITmfEvent>(ITmfEvent.class, (long)((int)this.rank), nbRequested, TmfEventsTable.this.fTrace.getCacheSize(), ITmfDataRequest.ExecutionType.BACKGROUND){
                    long currentRank;
                    {
                        this.currentRank = SearchThread.this.rank;
                    }

                    public void handleData(ITmfEvent event) {
                        super.handleData(event);
                        if (SearchThread.this.searchFilter.matches(event) && (SearchThread.this.eventFilter == null || SearchThread.this.eventFilter.matches(event))) {
                            SearchThread.this.foundRank = this.currentRank;
                            SearchThread.this.foundTimestamp = event.getTimestamp();
                            if (SearchThread.this.direction == 1) {
                                this.done();
                                return;
                            }
                        }
                        ++this.currentRank;
                    }
                };
                TmfEventsTable.this.fTrace.sendRequest(this.request);
                try {
                    this.request.waitForCompletion();
                    if (this.request.isCancelled()) {
                        return Status.OK_STATUS;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Object object = TmfEventsTable.this.fSearchSyncObj;
                    synchronized (object) {
                        TmfEventsTable.this.fSearchThread = null;
                    }
                    return Status.OK_STATUS;
                }
                if (this.foundRank != -1L) continue;
                if (this.direction == 1) {
                    if (this.rank == 0L) {
                        Object object = TmfEventsTable.this.fSearchSyncObj;
                        synchronized (object) {
                            TmfEventsTable.this.fSearchThread = null;
                        }
                        return Status.OK_STATUS;
                    }
                    nbRequested = (int)this.rank;
                    this.rank = 0L;
                    wrapped = true;
                    continue;
                }
                --this.rank;
                if (this.rank < 0L) {
                    this.rank = (int)TmfEventsTable.this.fTrace.getNbEvents() - 1;
                    wrapped = true;
                }
                if (this.rank > (long)startRank || !wrapped) continue;
                Object object = TmfEventsTable.this.fSearchSyncObj;
                synchronized (object) {
                    TmfEventsTable.this.fSearchThread = null;
                }
                return Status.OK_STATUS;
            }
            int index = (int)this.foundRank;
            if (this.eventFilter != null) {
                index = TmfEventsTable.this.fCache.getFilteredEventIndex(this.foundRank);
            }
            final int selection = index + 1 + (this.eventFilter != null ? 1 : 0);
            display.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    if (((SearchThread)SearchThread.this).TmfEventsTable.this.fTable.isDisposed()) {
                        return;
                    }
                    ((SearchThread)SearchThread.this).TmfEventsTable.this.fTable.setSelection(selection);
                    ((SearchThread)SearchThread.this).TmfEventsTable.this.fSelectedRank = SearchThread.this.foundRank;
                    ((SearchThread)SearchThread.this).TmfEventsTable.this.fRawViewer.selectAndReveal(((SearchThread)SearchThread.this).TmfEventsTable.this.fSelectedRank);
                    if (SearchThread.this.foundTimestamp != null) {
                        TmfEventsTable.this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)TmfEventsTable.this, SearchThread.this.foundTimestamp));
                    }
                    Object object = ((SearchThread)SearchThread.this).TmfEventsTable.this.fSearchSyncObj;
                    synchronized (object) {
                        ((SearchThread)SearchThread.this).TmfEventsTable.this.fSearchThread = null;
                    }
                }
            });
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void canceling() {
            this.request.cancel();
            Object object = TmfEventsTable.this.fSearchSyncObj;
            synchronized (object) {
                TmfEventsTable.this.fSearchThread = null;
            }
        }
    }
}

