/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.model.edit.pom.Model;
import org.eclipse.m2e.model.edit.pom.PropertyElement;
import org.eclipse.m2e.model.edit.pom.util.PomResourceImpl;
import org.eclipse.m2e.refactoring.AbstractPomRefactoring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactoringModelResources {
    private static final Logger log = LoggerFactory.getLogger(RefactoringModelResources.class);
    private static final String TMP_PROJECT_NAME = ".m2eclipse_refactoring";
    protected IFile pomFile;
    protected IFile tmpFile;
    protected ITextFileBuffer pomBuffer;
    protected ITextFileBuffer tmpBuffer;
    protected Model tmpModel;
    protected org.apache.maven.model.Model effective;
    protected ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
    protected Map<String, PropertyInfo> properties;
    protected MavenProject project;
    protected CompoundCommand command;
    protected static IProject tmpProject;

    protected IProject getTmpProject() {
        if (tmpProject == null) {
            tmpProject = ResourcesPlugin.getWorkspace().getRoot().getProject(TMP_PROJECT_NAME);
        }
        if (!tmpProject.exists()) {
            try {
                tmpProject.create(null);
                tmpProject.open(null);
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return tmpProject;
    }

    public RefactoringModelResources(IMavenProjectFacade projectFacade) throws CoreException, IOException {
        this.project = projectFacade.getMavenProject(null);
        this.effective = this.project.getModel();
        this.pomFile = projectFacade.getPom();
        this.pomBuffer = this.getBuffer(this.pomFile);
        IProject project = this.getTmpProject();
        File f = File.createTempFile("pom", ".xml", project.getLocation().toFile());
        f.delete();
        this.tmpFile = project.getFile(f.getName());
        this.pomFile.copy(this.tmpFile.getFullPath(), true, null);
        PomResourceImpl resource = AbstractPomRefactoring.loadResource(this.tmpFile);
        this.tmpModel = (Model)resource.getContents().get(0);
        this.tmpBuffer = this.getBuffer(this.tmpFile);
    }

    public CompoundCommand getCommand() {
        return this.command;
    }

    public void setCommand(CompoundCommand command) {
        this.command = command;
    }

    public IFile getPomFile() {
        return this.pomFile;
    }

    public IFile getTmpFile() {
        return this.tmpFile;
    }

    public ITextFileBuffer getPomBuffer() {
        return this.pomBuffer;
    }

    public ITextFileBuffer getTmpBuffer() {
        return this.tmpBuffer;
    }

    public Model getTmpModel() {
        return this.tmpModel;
    }

    public org.apache.maven.model.Model getEffective() {
        return this.effective;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Map<String, PropertyInfo> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, PropertyInfo> properties) {
        this.properties = properties;
    }

    public void releaseAllResources() throws CoreException {
        this.releaseBuffer(this.pomBuffer, this.pomFile);
        if (this.tmpFile != null && this.tmpFile.exists()) {
            this.releaseBuffer(this.tmpBuffer, this.tmpFile);
        }
        if (this.tmpModel != null) {
            this.tmpModel.eResource().unload();
        }
    }

    public static void cleanupTmpProject() throws CoreException {
        if (tmpProject.exists()) {
            tmpProject.delete(true, true, null);
        }
    }

    protected ITextFileBuffer getBuffer(IFile file) throws CoreException {
        this.textFileBufferManager.connect(file.getLocation(), LocationKind.NORMALIZE, null);
        return this.textFileBufferManager.getTextFileBuffer(file.getLocation(), LocationKind.NORMALIZE);
    }

    protected void releaseBuffer(ITextFileBuffer buffer, IFile file) throws CoreException {
        buffer.revert(null);
        this.textFileBufferManager.disconnect(file.getLocation(), LocationKind.NORMALIZE, null);
    }

    public String getName() {
        return this.pomFile.getProject().getName();
    }

    public static class PropertyInfo {
        protected PropertyElement pair;
        protected RefactoringModelResources resource;
        protected Command newValue;

        public Command getNewValue() {
            return this.newValue;
        }

        public void setNewValue(Command newValue) {
            this.newValue = newValue;
        }

        public PropertyElement getPair() {
            return this.pair;
        }

        public void setPair(PropertyElement pair) {
            this.pair = pair;
        }

        public RefactoringModelResources getResource() {
            return this.resource;
        }

        public void setResource(RefactoringModelResources resource) {
            this.resource = resource;
        }
    }
}

