/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.scm.internal.wizards;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.actions.OpenMavenConsoleAction;
import org.eclipse.m2e.core.ui.internal.wizards.AbstactCreateMavenProjectJob;
import org.eclipse.m2e.core.ui.internal.wizards.MavenImportWizard;
import org.eclipse.m2e.scm.MavenCheckoutOperation;
import org.eclipse.m2e.scm.MavenProjectScmInfo;
import org.eclipse.m2e.scm.internal.Messages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MavenProjectCheckoutJob
extends WorkspaceJob {
    private static final Logger log = LoggerFactory.getLogger(MavenProjectCheckoutJob.class);
    final ProjectImportConfiguration configuration;
    boolean checkoutAllProjects;
    Collection<MavenProjectInfo> projects;
    File location;
    List<String> collectedLocations = new ArrayList<String>();
    final List<IWorkingSet> workingSets;

    public MavenProjectCheckoutJob(ProjectImportConfiguration importConfiguration, boolean checkoutAllProjects, List<IWorkingSet> workingSets) {
        super(Messages.MavenProjectCheckoutJob_title);
        this.configuration = importConfiguration;
        this.checkoutAllProjects = checkoutAllProjects;
        this.workingSets = workingSets;
        this.setProperty(IProgressConstants.ACTION_PROPERTY, new OpenMavenConsoleAction());
        this.addJobChangeListener((IJobChangeListener)new CheckoutJobChangeListener());
    }

    public void setLocation(File location) {
        this.location = location;
    }

    protected abstract Collection<MavenProjectScmInfo> getProjects(IProgressMonitor var1) throws InterruptedException;

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            MavenCheckoutOperation operation = new MavenCheckoutOperation(this.location, this.getProjects(monitor));
            operation.run(monitor);
            this.collectedLocations.addAll(operation.getLocations());
            IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
            MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
            LocalProjectScanner scanner = new LocalProjectScanner(workspace.getLocation().toFile(), operation.getLocations(), true, modelManager);
            scanner.run(monitor);
            this.projects = MavenPlugin.getProjectConfigurationManager().collectProjects((Collection)scanner.getProjects());
            if (this.checkoutAllProjects) {
                for (MavenProjectInfo projectInfo : this.projects) {
                    String projectName;
                    IProject project;
                    Model model = projectInfo.getModel();
                    if (model == null) {
                        model = modelManager.readMavenModel(projectInfo.getPomFile());
                        projectInfo.setModel(model);
                    }
                    if (!(project = workspace.getProject(projectName = this.configuration.getProjectName(model))).exists()) continue;
                    this.checkoutAllProjects = false;
                    break;
                }
            }
            return Status.OK_STATUS;
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class CheckoutJobChangeListener
    extends JobChangeAdapter {
        CheckoutJobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            IStatus result = event.getResult();
            if (result.getSeverity() == 8) {
                return;
            }
            if (!result.isOK()) {
                return;
            }
            if (MavenProjectCheckoutJob.this.projects.isEmpty()) {
                log.info("No Maven projects to import");
                if (MavenProjectCheckoutJob.this.collectedLocations.size() == 1) {
                    final String location = MavenProjectCheckoutJob.this.collectedLocations.get(0);
                    DirectoryScanner projectScanner = new DirectoryScanner();
                    projectScanner.setBasedir(location);
                    projectScanner.setIncludes(new String[]{"**/.project"});
                    projectScanner.scan();
                    String[] projectFiles = projectScanner.getIncludedFiles();
                    if (projectFiles != null && projectFiles.length > 0) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                boolean res = MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.MavenProjectCheckoutJob_confirm_title, (String)Messages.MavenProjectCheckoutJob_confirm_message);
                                if (res) {
                                    ExternalProjectImportWizard wizard = new ExternalProjectImportWizard(((CheckoutJobChangeListener)CheckoutJobChangeListener.this).MavenProjectCheckoutJob.this.collectedLocations.get(0));
                                    WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
                                    dialog.open();
                                } else {
                                    CheckoutJobChangeListener.this.cleanup(((CheckoutJobChangeListener)CheckoutJobChangeListener.this).MavenProjectCheckoutJob.this.collectedLocations);
                                }
                            }
                        });
                        return;
                    }
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            boolean res = MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.MavenProjectCheckoutJob_confirm2_title, (String)Messages.MavenProjectCheckoutJob_confirm2_message);
                            if (res) {
                                Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
                                clipboard.setContents(new Object[]{location}, new Transfer[]{TextTransfer.getInstance()});
                                NewProjectAction newProjectAction = new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                                newProjectAction.run();
                            } else {
                                CheckoutJobChangeListener.this.cleanup(((CheckoutJobChangeListener)CheckoutJobChangeListener.this).MavenProjectCheckoutJob.this.collectedLocations);
                            }
                        }
                    });
                    return;
                }
                this.cleanup(MavenProjectCheckoutJob.this.collectedLocations);
            }
            if (MavenProjectCheckoutJob.this.checkoutAllProjects) {
                LifecycleMappingConfiguration mappingConfiguration;
                if (M2EUIPluginActivator.getDefault().getMavenDiscovery() != null && !(mappingConfiguration = LifecycleMappingConfiguration.calculate(MavenProjectCheckoutJob.this.projects, (ProjectImportConfiguration)MavenProjectCheckoutJob.this.configuration, (IProgressMonitor)new NullProgressMonitor())).isMappingComplete(true)) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MavenImportWizard wizard = new MavenImportWizard(((CheckoutJobChangeListener)CheckoutJobChangeListener.this).MavenProjectCheckoutJob.this.configuration, ((CheckoutJobChangeListener)CheckoutJobChangeListener.this).MavenProjectCheckoutJob.this.collectedLocations, mappingConfiguration);
                            wizard.setBasedirRemameRequired(true);
                            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
                            int res = dialog.open();
                            if (res == 1) {
                                CheckoutJobChangeListener.this.cleanup(((CheckoutJobChangeListener)CheckoutJobChangeListener.this).MavenProjectCheckoutJob.this.collectedLocations);
                            }
                        }
                    });
                    return;
                }
                AbstactCreateMavenProjectJob job = new AbstactCreateMavenProjectJob(Messages.MavenProjectCheckoutJob_job, MavenProjectCheckoutJob.this.workingSets){

                    protected List<IProject> doCreateMavenProjects(IProgressMonitor monitor) throws CoreException {
                        Set projectSet = MavenPlugin.getProjectConfigurationManager().collectProjects(((CheckoutJobChangeListener)CheckoutJobChangeListener.this).MavenProjectCheckoutJob.this.projects);
                        List results = MavenPlugin.getProjectConfigurationManager().importProjects((Collection)projectSet, ((CheckoutJobChangeListener)CheckoutJobChangeListener.this).MavenProjectCheckoutJob.this.configuration, monitor);
                        return 4.toProjects((List)results);
                    }
                };
                ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)ResourcesPlugin.getWorkspace().getRoot());
                job.setRule(rule);
                job.schedule();
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MavenImportWizard wizard = new MavenImportWizard(((CheckoutJobChangeListener)CheckoutJobChangeListener.this).MavenProjectCheckoutJob.this.configuration, ((CheckoutJobChangeListener)CheckoutJobChangeListener.this).MavenProjectCheckoutJob.this.collectedLocations);
                        wizard.setBasedirRemameRequired(true);
                        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
                        int res = dialog.open();
                        if (res == 1) {
                            CheckoutJobChangeListener.this.cleanup(((CheckoutJobChangeListener)CheckoutJobChangeListener.this).MavenProjectCheckoutJob.this.collectedLocations);
                        }
                    }
                });
            }
        }

        protected void cleanup(List<String> locations) {
            for (String location : locations) {
                try {
                    FileUtils.deleteDirectory((String)location);
                }
                catch (IOException ex) {
                    String msg = "Can't delete " + location + "; " + (ex.getMessage() == null ? ex.toString() : ex.getMessage());
                    log.error(msg, (Throwable)ex);
                }
            }
        }
    }
}

