/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.io.PositionInputStream;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.MessageUtil;

abstract class AbstractParser {
    protected PositionInputStream in;
    protected Version version;
    protected int idSize;

    AbstractParser() {
    }

    static Version readVersion(InputStream in) throws IOException {
        StringBuilder version = new StringBuilder();
        for (int bytesRead = 0; bytesRead < 20; ++bytesRead) {
            byte b = (byte)in.read();
            if (b != 0) {
                version.append((char)b);
                continue;
            }
            Version answer = Version.byLabel(version.toString());
            if (answer == null) {
                if (bytesRead <= 13) {
                    throw new IOException(Messages.AbstractParser_Error_NotHeapDump);
                }
                throw new IOException(MessageUtil.format((String)Messages.AbstractParser_Error_UnknownHPROFVersion, (Object[])new Object[]{version.toString()}));
            }
            if (answer == Version.JDK12BETA3) {
                throw new IOException(MessageUtil.format((String)Messages.AbstractParser_Error_UnsupportedHPROFVersion, (Object[])new Object[]{answer.getLabel()}));
            }
            return answer;
        }
        throw new IOException(Messages.AbstractParser_Error_InvalidHPROFHeader);
    }

    protected long readUnsignedInt() throws IOException {
        return 0xFFFFFFFFL & (long)this.in.readInt();
    }

    protected long readID() throws IOException {
        return this.idSize == 4 ? 0xFFFFFFFFL & (long)this.in.readInt() : this.in.readLong();
    }

    protected Object readValue(ISnapshot snapshot) throws IOException {
        byte type = this.in.readByte();
        return this.readValue(snapshot, type);
    }

    protected Object readValue(ISnapshot snapshot, int type) throws IOException {
        switch (type) {
            case 2: {
                long id = this.readID();
                return id == 0L ? null : new ObjectReference(snapshot, id);
            }
            case 4: {
                if (this.in.readByte() != 0) {
                    return true;
                }
                return false;
            }
            case 5: {
                return Character.valueOf(this.in.readChar());
            }
            case 6: {
                return Float.valueOf(this.in.readFloat());
            }
            case 7: {
                return this.in.readDouble();
            }
            case 8: {
                return this.in.readByte();
            }
            case 9: {
                return this.in.readShort();
            }
            case 10: {
                return this.in.readInt();
            }
            case 11: {
                return this.in.readLong();
            }
        }
        throw new IOException(MessageUtil.format((String)Messages.AbstractParser_Error_IllegalType, (Object[])new Object[]{type}));
    }

    protected void skipValue() throws IOException {
        byte type = this.in.readByte();
        this.skipValue(type);
    }

    protected void skipValue(int type) throws IOException {
        if (type == 2) {
            this.in.skipBytes(this.idSize);
        } else {
            this.in.skipBytes(IPrimitiveArray.ELEMENT_SIZE[type]);
        }
    }

    protected int determineDumpNumber() {
        String dumpNr = System.getProperty("MAT_HPROF_DUMP_NR");
        return dumpNr == null ? 0 : Integer.parseInt(dumpNr);
    }

    static interface Constants {

        public static interface DumpSegment {
            public static final int ROOT_UNKNOWN = 255;
            public static final int ROOT_JNI_GLOBAL = 1;
            public static final int ROOT_JNI_LOCAL = 2;
            public static final int ROOT_JAVA_FRAME = 3;
            public static final int ROOT_NATIVE_STACK = 4;
            public static final int ROOT_STICKY_CLASS = 5;
            public static final int ROOT_THREAD_BLOCK = 6;
            public static final int ROOT_MONITOR_USED = 7;
            public static final int ROOT_THREAD_OBJECT = 8;
            public static final int CLASS_DUMP = 32;
            public static final int INSTANCE_DUMP = 33;
            public static final int OBJECT_ARRAY_DUMP = 34;
            public static final int PRIMITIVE_ARRAY_DUMP = 35;
        }

        public static interface Record {
            public static final int STRING_IN_UTF8 = 1;
            public static final int LOAD_CLASS = 2;
            public static final int UNLOAD_CLASS = 3;
            public static final int STACK_FRAME = 4;
            public static final int STACK_TRACE = 5;
            public static final int ALLOC_SITES = 6;
            public static final int HEAP_SUMMARY = 7;
            public static final int START_THREAD = 10;
            public static final int END_THREAD = 11;
            public static final int HEAP_DUMP = 12;
            public static final int HEAP_DUMP_SEGMENT = 28;
            public static final int HEAP_DUMP_END = 44;
            public static final int CPU_SAMPLES = 13;
            public static final int CONTROL_SETTINGS = 14;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Version {
        JDK12BETA3("JAVA PROFILE 1.0"),
        JDK12BETA4("JAVA PROFILE 1.0.1"),
        JDK6("JAVA PROFILE 1.0.2");

        private String label;

        private Version(String label) {
            this.label = label;
        }

        public static final Version byLabel(String label) {
            Version[] versionArray = Version.values();
            int n = versionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Version v = versionArray[n2];
                if (v.label.equals(label)) {
                    return v;
                }
                ++n2;
            }
            return null;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

