/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttachmentMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaFlagMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaUtil;
import org.eclipse.mylyn.internal.bugzilla.core.Messages;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaxMultiBugReportContentHandler
extends DefaultHandler {
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ID_STRING_BEGIN = " (id=";
    private static final String ID_STRING_END = ")";
    private StringBuffer characters;
    private TaskComment taskComment;
    private Map<String, TaskCommentMapper> attachIdToComment = new HashMap<String, TaskCommentMapper>();
    private int commentNum = 0;
    private BugzillaAttachmentMapper attachment;
    private final Map<String, TaskData> taskDataMap;
    private TaskData repositoryTaskData;
    private List<TaskComment> longDescs;
    private String errorMessage = null;
    private final List<BugzillaCustomField> customFields;
    private final TaskDataCollector collector;
    private boolean isDeprecated = false;
    private boolean isPatch = false;
    private String token;
    private String exporter;
    private TaskAttribute attachmentAttribute;
    private boolean bugParseErrorOccurred;
    private final BugzillaRepositoryConnector connector;
    private boolean useIsPrivate;
    private final TaskAttributeMapper mapper;
    private final SimpleDateFormat simpleFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final SimpleDateFormat simpleFormatter_deltaTS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public SaxMultiBugReportContentHandler(TaskAttributeMapper mapper, TaskDataCollector collector, Map<String, TaskData> taskDataMap, List<BugzillaCustomField> customFields, BugzillaRepositoryConnector connector) {
        this.mapper = mapper;
        this.taskDataMap = taskDataMap;
        this.customFields = customFields;
        this.collector = collector;
        this.connector = connector;
        TaskRepository taskRepository = mapper.getTaskRepository();
        String useParam = taskRepository.getProperty("bugzilla.insider.group");
        this.useIsPrivate = useParam == null || useParam != null && useParam.equals("true");
    }

    public boolean errorOccurred() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.characters = new StringBuffer();
        BugzillaAttribute tag = BugzillaAttribute.UNKNOWN;
        if (localName.startsWith("cf_")) {
            return;
        }
        try {
            tag = BugzillaAttribute.valueOf(localName.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (RuntimeException e) {
            if (e instanceof IllegalArgumentException) {
                return;
            }
            throw e;
        }
        switch (tag) {
            case BUGZILLA: {
                this.exporter = attributes.getValue("exporter");
                break;
            }
            case BUG: {
                if (attributes != null && attributes.getValue("error") != null) {
                    this.errorMessage = attributes.getValue("error");
                    this.bugParseErrorOccurred = true;
                    this.repositoryTaskData = null;
                }
                this.attachIdToComment = new HashMap<String, TaskCommentMapper>();
                this.commentNum = 0;
                this.taskComment = null;
                this.longDescs = new ArrayList<TaskComment>();
                this.token = null;
                break;
            }
            case LONG_DESC: {
                String is_private = attributes.getValue("isprivate");
                this.taskComment = new TaskComment(is_private);
                break;
            }
            case WHO: {
                String name;
                if (this.taskComment == null || attributes == null || attributes.getLength() <= 0 || (name = attributes.getValue(ATTRIBUTE_NAME)) == null || name.length() <= 0) break;
                this.taskComment.authorName = name;
                break;
            }
            case REPORTER: {
                String name;
                if (attributes == null || attributes.getLength() <= 0 || (name = attributes.getValue(ATTRIBUTE_NAME)) == null) break;
                BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, BugzillaAttribute.REPORTER_NAME).setValue(name);
                break;
            }
            case QA_CONTACT: {
                String name;
                if (attributes == null || attributes.getLength() <= 0 || (name = attributes.getValue(ATTRIBUTE_NAME)) == null) break;
                BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, BugzillaAttribute.QA_CONTACT_NAME).setValue(name);
                break;
            }
            case ASSIGNED_TO: {
                String name;
                if (attributes == null || attributes.getLength() <= 0 || (name = attributes.getValue(ATTRIBUTE_NAME)) == null) break;
                BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, BugzillaAttribute.ASSIGNED_TO_NAME).setValue(name);
                break;
            }
            case ATTACHMENT: {
                if (attributes == null) break;
                this.isDeprecated = "1".equals(attributes.getValue(BugzillaAttribute.IS_OBSOLETE.getKey()));
                this.isPatch = "1".equals(attributes.getValue(BugzillaAttribute.IS_PATCH.getKey()));
                break;
            }
            case FLAG: {
                String name;
                if (attributes == null || attributes.getLength() <= 0 || (name = attributes.getValue(ATTRIBUTE_NAME)) == null) break;
                BugzillaFlagMapper mapper = new BugzillaFlagMapper(this.connector);
                String requestee = attributes.getValue("requestee");
                mapper.setRequestee(requestee);
                String setter = attributes.getValue("setter");
                mapper.setSetter(setter);
                String status = attributes.getValue("status");
                mapper.setState(status);
                mapper.setFlagId(name);
                String id = attributes.getValue("id");
                if (id == null || id.equals("")) break;
                try {
                    mapper.setNumber(Integer.valueOf(id));
                    TaskAttribute attribute = this.attachmentAttribute != null ? this.attachmentAttribute.createAttribute("task.common.kind.flag" + id) : this.repositoryTaskData.getRoot().createAttribute("task.common.kind.flag" + id);
                    mapper.applyTo(attribute);
                    break;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        while (this.characters.length() > 0 && Character.isWhitespace(this.characters.charAt(this.characters.length() - 1))) {
            this.characters.setLength(this.characters.length() - 1);
        }
        String parsedText = this.characters.toString();
        if (localName.startsWith("cf_")) {
            TaskAttribute endAttribute = this.repositoryTaskData.getRoot().getAttribute(localName);
            if (endAttribute == null) {
                String desc = "???";
                BugzillaCustomField customField = null;
                for (BugzillaCustomField bugzillaCustomField : this.customFields) {
                    if (!localName.equals(bugzillaCustomField.getName())) continue;
                    customField = bugzillaCustomField;
                    break;
                }
                if (customField != null) {
                    TaskAttribute atr = this.repositoryTaskData.getRoot().createAttribute(localName);
                    desc = customField.getDescription();
                    atr.getMetaData().defaults().setLabel(desc).setReadOnly(false);
                    atr.getMetaData().setKind("task.common.kind.default");
                    atr.getMetaData().setType("shortText");
                    switch (customField.getFieldType()) {
                        case FreeText: {
                            atr.getMetaData().setType("shortText");
                            break;
                        }
                        case DropDown: {
                            atr.getMetaData().setType("singleSelect");
                            break;
                        }
                        case MultipleSelection: {
                            atr.getMetaData().setType("multiSelect");
                            break;
                        }
                        case LargeText: {
                            atr.getMetaData().setType("longText");
                            break;
                        }
                        case DateTime: {
                            atr.getMetaData().setType("dateTime");
                            break;
                        }
                        default: {
                            List<String> options = customField.getOptions();
                            if (options.size() > 0) {
                                atr.getMetaData().setType("singleSelect");
                                break;
                            }
                            atr.getMetaData().setType("shortText");
                        }
                    }
                    atr.getMetaData().setReadOnly(false);
                    atr.setValue(parsedText);
                }
            } else {
                endAttribute.addValue(parsedText);
            }
        }
        BugzillaAttribute tag = BugzillaAttribute.UNKNOWN;
        try {
            tag = BugzillaAttribute.valueOf(localName.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (RuntimeException e) {
            if (e instanceof IllegalArgumentException) {
                return;
            }
            throw e;
        }
        switch (tag) {
            case BUG_ID: {
                this.repositoryTaskData = this.taskDataMap.get(parsedText.trim());
                if (this.repositoryTaskData == null) {
                    this.errorMessage = String.valueOf(parsedText) + Messages.SaxMultiBugReportContentHandler_id_not_found;
                    this.bugParseErrorOccurred = true;
                    break;
                }
                TaskAttribute attr = this.repositoryTaskData.getRoot().getMappedAttribute(tag.getKey());
                if (attr == null) {
                    attr = BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, tag);
                }
                attr.setValue(parsedText);
                if (this.exporter != null) {
                    this.createAttrribute(this.exporter, BugzillaAttribute.EXPORTER_NAME);
                    break;
                }
                this.createAttrribute("", BugzillaAttribute.EXPORTER_NAME);
                break;
            }
            case WHO: {
                if (this.taskComment == null) break;
                this.taskComment.author = parsedText;
                break;
            }
            case BUG_WHEN: {
                if (this.taskComment == null) break;
                this.taskComment.createdTimeStamp = parsedText;
                break;
            }
            case WORK_TIME: {
                if (this.taskComment == null) break;
                this.taskComment.timeWorked = parsedText;
                break;
            }
            case THETEXT: {
                if (this.taskComment == null) break;
                this.taskComment.commentText = parsedText;
                break;
            }
            case LONG_DESC: {
                if (this.taskComment == null) break;
                this.longDescs.add(this.taskComment);
                break;
            }
            case ATTACHID: {
                this.attachmentAttribute = this.repositoryTaskData.getRoot().createAttribute("task.common.attachment-" + parsedText);
                this.attachment = BugzillaAttachmentMapper.createFrom(this.attachmentAttribute);
                this.attachment.setLength(new Long(-1L));
                this.attachment.setAttachmentId(parsedText);
                this.attachment.setPatch(this.isPatch);
                this.attachment.setDeprecated(this.isDeprecated);
                this.attachment.setToken(null);
                break;
            }
            case DATE: {
                if (this.attachment == null) break;
                try {
                    this.attachment.setCreationDate(this.simpleFormatter.parse(parsedText));
                }
                catch (ParseException parseException) {
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case DESC: {
                if (this.attachment == null) break;
                this.attachment.setDescription(parsedText);
                break;
            }
            case FILENAME: {
                if (this.attachment == null) break;
                this.attachment.setFileName(parsedText);
                break;
            }
            case CTYPE: 
            case TYPE: {
                if (this.attachment == null) break;
                this.attachment.setContentType(parsedText);
                break;
            }
            case DELTA_TS: {
                if (this.attachment != null) {
                    try {
                        if (parsedText == null) break;
                        try {
                            this.attachment.setDeltaDate(this.simpleFormatter_deltaTS.parse(parsedText));
                        }
                        catch (ParseException parseException) {
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                this.createAttrribute(parsedText, tag);
                break;
            }
            case SIZE: {
                if (this.attachment == null) break;
                try {
                    if (parsedText == null) break;
                    this.attachment.setLength(Long.parseLong(parsedText));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case ATTACHMENT: {
                if (this.attachment != null) {
                    this.attachment.applyTo(this.attachmentAttribute);
                }
                this.isPatch = false;
                this.isDeprecated = false;
                this.attachment = null;
                this.attachmentAttribute = null;
                break;
            }
            case DATA: {
                break;
            }
            case BUGZILLA: {
                break;
            }
            case BUG: {
                if (this.bugParseErrorOccurred) {
                    this.bugParseErrorOccurred = false;
                    break;
                }
                this.addDescriptionAndComments();
                TaskAttribute numCommentsAttribute = this.repositoryTaskData.getRoot().getMappedAttribute(BugzillaAttribute.LONGDESCLENGTH.getKey());
                if (numCommentsAttribute == null) {
                    numCommentsAttribute = BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, BugzillaAttribute.LONGDESCLENGTH);
                }
                numCommentsAttribute.setValue("" + this.commentNum);
                this.updateAttachmentMetaData();
                TaskAttribute attrCreation = this.repositoryTaskData.getRoot().getAttribute(BugzillaAttribute.CREATION_TS.getKey());
                this.updateCustomFields(this.repositoryTaskData);
                if (this.token != null) {
                    TaskAttribute tokenAttribute = BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, BugzillaAttribute.TOKEN);
                    tokenAttribute.setValue(this.token);
                }
                TaskAttribute estimatedTimeAttr = this.repositoryTaskData.getRoot().getMappedAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey());
                TaskAttribute deadlineAttr = this.repositoryTaskData.getRoot().getMappedAttribute(BugzillaAttribute.DEADLINE.getKey());
                if (estimatedTimeAttr != null && deadlineAttr == null) {
                    BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, BugzillaAttribute.DEADLINE);
                }
                if (attrCreation != null && !attrCreation.equals((Object)"")) {
                    this.collector.accept(this.repositoryTaskData);
                }
                this.repositoryTaskData = null;
                break;
            }
            case BLOCKED: 
            case DEPENDSON: {
                TaskAttribute blockOrDepends = this.repositoryTaskData.getRoot().getMappedAttribute(tag.getKey());
                if (blockOrDepends == null) {
                    BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, tag).setValue(parsedText);
                    break;
                }
                if (blockOrDepends.getValue().equals("")) {
                    blockOrDepends.setValue(parsedText);
                    break;
                }
                blockOrDepends.setValue(String.valueOf(blockOrDepends.getValue()) + ", " + parsedText);
                break;
            }
            case DUP_ID: {
                TaskAttribute duplicateOf = this.repositoryTaskData.getRoot().getMappedAttribute(tag.getKey());
                if (duplicateOf == null) {
                    BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, tag).setValue(parsedText);
                    break;
                }
                if (!duplicateOf.getValue().equals("")) break;
                duplicateOf.setValue(parsedText);
                break;
            }
            case UNKNOWN: {
                break;
            }
            case FLAG: {
                break;
            }
            case TOKEN: {
                if (this.attachment != null) {
                    this.attachment.setToken(parsedText);
                    break;
                }
                this.token = parsedText;
                break;
            }
            case ATTACHER: {
                if (this.attachment == null) break;
                IRepositoryPerson author = this.repositoryTaskData.getAttributeMapper().getTaskRepository().createPerson(parsedText);
                this.attachment.setAuthor(author);
                break;
            }
            case TARGET_MILESTONE: {
                BugzillaUtil.createAttributeWithKindDefaultIfUsed(parsedText, tag, this.repositoryTaskData, "bugzilla.param.usetargetmilestone", true);
                break;
            }
            case QA_CONTACT: {
                BugzillaUtil.createAttributeWithKindDefaultIfUsed(parsedText, tag, this.repositoryTaskData, "bugzilla.param.useqacontact", true);
                break;
            }
            case STATUS_WHITEBOARD: {
                BugzillaUtil.createAttributeWithKindDefaultIfUsed(parsedText, tag, this.repositoryTaskData, "bugzilla.param.usestatuswhiteboard", true);
                break;
            }
            case CLASSIFICATION: {
                BugzillaUtil.createAttributeWithKindDefaultIfUsed(parsedText, tag, this.repositoryTaskData, "bugzilla.param.use.classification", false);
                break;
            }
            case ALIAS: {
                BugzillaUtil.createAttributeWithKindDefaultIfUsed(parsedText, tag, this.repositoryTaskData, "bugzilla.param.usebugaliases", false);
                break;
            }
            case SEE_ALSO: {
                BugzillaUtil.createAttributeWithKindDefaultIfUsed(parsedText, tag, this.repositoryTaskData, "bugzilla.param.use_see_also", false);
                break;
            }
            case COMMENTID: {
                if (this.taskComment == null) break;
                this.taskComment.id = Integer.parseInt(parsedText);
                break;
            }
            default: {
                this.createAttrribute(parsedText, tag);
            }
        }
    }

    private TaskAttribute createAttrribute(String parsedText, BugzillaAttribute tag) {
        TaskAttribute attribute = this.repositoryTaskData.getRoot().getMappedAttribute(tag.getKey());
        if (attribute == null) {
            attribute = BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, tag);
            attribute.setValue(parsedText);
        } else {
            attribute.addValue(parsedText);
        }
        return attribute;
    }

    private void updateCustomFields(TaskData taskData) {
        RepositoryConfiguration config = this.connector.getRepositoryConfiguration(this.repositoryTaskData.getRepositoryUrl());
        if (config != null) {
            for (BugzillaCustomField bugzillaCustomField : config.getCustomFields()) {
                TaskAttribute atr = taskData.getRoot().getAttribute(bugzillaCustomField.getName());
                if (atr == null) {
                    atr = taskData.getRoot().createAttribute(bugzillaCustomField.getName());
                }
                if (atr == null) continue;
                atr.getMetaData().defaults().setLabel(bugzillaCustomField.getDescription());
                atr.getMetaData().setKind("task.common.kind.default");
                switch (bugzillaCustomField.getFieldType()) {
                    case FreeText: {
                        atr.getMetaData().setType("shortText");
                        break;
                    }
                    case DropDown: {
                        atr.getMetaData().setType("singleSelect");
                        break;
                    }
                    case MultipleSelection: {
                        atr.getMetaData().setType("multiSelect");
                        break;
                    }
                    case LargeText: {
                        atr.getMetaData().setType("longText");
                        break;
                    }
                    case DateTime: {
                        atr.getMetaData().setType("dateTime");
                        break;
                    }
                    default: {
                        List<String> options = bugzillaCustomField.getOptions();
                        if (options.size() > 0) {
                            atr.getMetaData().setType("singleSelect");
                            break;
                        }
                        atr.getMetaData().setType("shortText");
                    }
                }
                atr.getMetaData().setReadOnly(false);
            }
        }
    }

    private void updateAttachmentMetaData() {
        List taskAttachments = this.repositoryTaskData.getAttributeMapper().getAttributesByType(this.repositoryTaskData, "attachment");
        for (TaskAttribute attachment : taskAttachments) {
            TaskCommentMapper taskComment;
            BugzillaAttachmentMapper attachmentMapper = BugzillaAttachmentMapper.createFrom(attachment);
            if ((attachmentMapper.getAuthor() == null || attachmentMapper.getCreationDate() == null) && (taskComment = this.attachIdToComment.get(attachmentMapper.getAttachmentId())) != null) {
                attachmentMapper.setAuthor(taskComment.getAuthor());
                attachmentMapper.setCreationDate(taskComment.getCreationDate());
            }
            attachmentMapper.setUrl(String.valueOf(this.repositoryTaskData.getRepositoryUrl()) + "/attachment.cgi?id=" + attachmentMapper.getAttachmentId());
            attachmentMapper.applyTo(attachment);
        }
    }

    private void addDescriptionAndComments() {
        block13: {
            int longDescsSize;
            block14: {
                block12: {
                    longDescsSize = this.longDescs.size() - 1;
                    this.commentNum = 1;
                    if (longDescsSize != 0) break block12;
                    this.addDescription(this.longDescs.get(0));
                    break block13;
                }
                if (longDescsSize != 1) break block14;
                if (this.longDescs.get((int)0).createdTimeStamp.compareTo(this.longDescs.get((int)1).createdTimeStamp) <= 0) {
                    this.addDescription(this.longDescs.get(0));
                    this.addComment(this.longDescs.get(1));
                } else {
                    this.addDescription(this.longDescs.get(1));
                    this.addComment(this.longDescs.get(0));
                }
                break block13;
            }
            if (longDescsSize <= 1) break block13;
            String created_0 = this.longDescs.get((int)0).createdTimeStamp;
            String created_1 = this.longDescs.get((int)1).createdTimeStamp;
            String created_n = this.longDescs.get((int)longDescsSize).createdTimeStamp;
            if (created_0.compareTo(created_1) <= 0 && created_0.compareTo(created_n) < 0) {
                this.addDescription(this.longDescs.get(0));
                if (created_1.compareTo(created_n) < 0) {
                    int i = 1;
                    while (i <= longDescsSize) {
                        this.addComment(this.longDescs.get(i));
                        ++i;
                    }
                } else {
                    int i = longDescsSize;
                    while (i > 0) {
                        this.addComment(this.longDescs.get(i));
                        --i;
                    }
                }
            } else {
                this.addDescription(this.longDescs.get(longDescsSize));
                if (created_0.compareTo(created_1) < 0) {
                    int i = 0;
                    while (i < longDescsSize) {
                        this.addComment(this.longDescs.get(i));
                        ++i;
                    }
                } else {
                    int i = longDescsSize - 1;
                    while (i >= 0) {
                        this.addComment(this.longDescs.get(i));
                        --i;
                    }
                }
            }
        }
    }

    private void addDescription(TaskComment comment) {
        TaskAttribute attrDescription = BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, BugzillaAttribute.LONG_DESC);
        TaskAttribute idAttribute = attrDescription.createAttribute("id");
        TaskAttribute isprivateAttribute = attrDescription.createAttribute("isprivate");
        attrDescription.setValue(comment.commentText);
        idAttribute.setValue(Integer.toString(comment.id));
        if (comment.isPrivate != null) {
            isprivateAttribute.setValue(comment.isPrivate);
        }
        if (!this.useIsPrivate && "1".equals(comment.isPrivate)) {
            TaskRepository taskRepository = this.mapper.getTaskRepository();
            taskRepository.setProperty("bugzilla.insider.group", "true");
            this.useIsPrivate = true;
        }
    }

    private void addComment(TaskComment comment) {
        TaskAttribute attribute = this.repositoryTaskData.getRoot().createAttribute("task.common.comment-" + this.commentNum);
        TaskCommentMapper taskComment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
        taskComment.setCommentId(String.valueOf(comment.id));
        taskComment.setNumber(Integer.valueOf(this.commentNum));
        IRepositoryPerson author = this.repositoryTaskData.getAttributeMapper().getTaskRepository().createPerson(comment.author);
        author.setName(comment.authorName);
        taskComment.setAuthor(author);
        if (this.useIsPrivate) {
            taskComment.setIsPrivate(Boolean.valueOf("1".equals(comment.isPrivate)));
        } else if ("1".equals(comment.isPrivate)) {
            TaskRepository taskRepository = this.mapper.getTaskRepository();
            taskRepository.setProperty("bugzilla.insider.group", "true");
            this.useIsPrivate = true;
            taskComment.setIsPrivate(Boolean.valueOf("1".equals(comment.isPrivate)));
        } else {
            taskComment.setIsPrivate(null);
        }
        TaskAttribute attrTimestamp = attribute.createAttribute(BugzillaAttribute.BUG_WHEN.getKey());
        attrTimestamp.setValue(comment.createdTimeStamp);
        taskComment.setCreationDate(this.repositoryTaskData.getAttributeMapper().getDateValue(attrTimestamp));
        if (comment.commentText != null) {
            String commentText = comment.commentText.trim();
            taskComment.setText(commentText);
        }
        taskComment.applyTo(attribute);
        ++this.commentNum;
        if (comment.timeWorked != null) {
            TaskAttribute workTime = BugzillaTaskDataHandler.createAttribute(attribute, BugzillaAttribute.WORK_TIME);
            workTime.setValue(comment.timeWorked);
        }
        this.parseAttachment(taskComment);
    }

    private void parseAttachment(TaskCommentMapper comment) {
        int endIndex;
        int startIndex;
        String attachmentID = "";
        String commentText = comment.getText();
        int firstDelimiter = commentText.indexOf("\n");
        if (firstDelimiter < 0) {
            firstDelimiter = commentText.length();
        }
        if ((startIndex = commentText.indexOf(ID_STRING_BEGIN)) > 0 && startIndex < firstDelimiter && (endIndex = commentText.indexOf(ID_STRING_END, startIndex)) > 0 && endIndex < firstDelimiter) {
            int p = startIndex += ID_STRING_BEGIN.length();
            while (p < endIndex) {
                char c = commentText.charAt(p);
                if (c < '0' || c > '9') break;
                ++p;
            }
            if (p == endIndex && !(attachmentID = commentText.substring(startIndex, endIndex)).equals("")) {
                this.attachIdToComment.put(attachmentID, comment);
            }
        }
    }

    private static class TaskComment {
        public int number;
        public int id;
        public String author;
        public String authorName;
        public String createdTimeStamp;
        public String commentText;
        public String timeWorked;
        public String isPrivate;

        public TaskComment(String isprivate) {
            this.isPrivate = isprivate;
        }
    }
}

