/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.spi.GetBuildsRequest;
import org.eclipse.mylyn.builds.internal.core.operations.GetBuildsOperation;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeEvent;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeListener;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorInput;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenHandler
extends AbstractHandler {
    public static EditorHandle fetchAndOpen(final IWorkbenchPage page, IBuild build) {
        final EditorHandle handle = new EditorHandle();
        final IBuildPlan plan = build.getPlan();
        final String label = build.getLabel();
        GetBuildsRequest request = new GetBuildsRequest(build.getPlan(), Collections.singletonList(label), GetBuildsRequest.Scope.FULL);
        GetBuildsOperation operation = BuildsUiInternal.getFactory().getGetBuildsOperation(request);
        operation.addOperationChangeListener(new OperationChangeListener(){

            public void done(OperationChangeEvent event) {
                if (event.getStatus().isOK() && !Display.getDefault().isDisposed()) {
                    GetBuildsOperation operation = (GetBuildsOperation)event.getOperation();
                    List builds = operation.getBuilds();
                    if (builds != null && builds.size() > 0) {
                        final IBuild build2 = (IBuild)builds.get(0);
                        build2.setPlan(plan);
                        build2.setServer(plan.getServer());
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                if (!page.getWorkbenchWindow().getShell().isDisposed()) {
                                    BuildEditorInput input = new BuildEditorInput(build2);
                                    try {
                                        IEditorPart part = page.openEditor((IEditorInput)input, "org.eclipse.mylyn.builds.ui.editors.Build");
                                        handle.setPart((IWorkbenchPart)part);
                                        handle.setStatus(Status.OK_STATUS);
                                    }
                                    catch (PartInitException e) {
                                        Status status = new Status(4, "org.eclipse.mylyn.builds.ui", "Unexpected error while opening build", (Throwable)e);
                                        StatusHandler.log((IStatus)status);
                                        handle.setStatus((IStatus)status);
                                    }
                                }
                            }
                        });
                    } else {
                        Status status = new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"The requested build ''{0}'' was not found", (Object)label));
                        handle.setStatus((IStatus)status);
                    }
                } else {
                    handle.setStatus(event.getStatus());
                }
            }
        });
        operation.execute();
        return handle;
    }

    public static List<EditorHandle> open(IWorkbenchPage page, List<? extends IBuildElement> elements) {
        ArrayList<EditorHandle> handles = new ArrayList<EditorHandle>();
        for (IBuildElement iBuildElement : elements) {
            EditorHandle handle;
            IBuildPlan plan;
            IBuildElement openElement = null;
            if (iBuildElement instanceof IBuildPlan && (plan = (IBuildPlan)iBuildElement).getLastBuild() != null) {
                openElement = plan.getLastBuild();
            }
            if (openElement == null) {
                openElement = iBuildElement;
            }
            if (openElement instanceof IBuild && OpenHandler.isPartial((IBuild)openElement)) {
                handle = OpenHandler.fetchAndOpen(page, (IBuild)openElement);
                handles.add(handle);
                continue;
            }
            handle = OpenHandler.openInEditor(page, openElement);
            handles.add(handle);
        }
        return handles;
    }

    public static EditorHandle openInEditor(IWorkbenchPage page, IBuildElement item) {
        BuildEditorInput input = null;
        if (item instanceof IBuild) {
            input = new BuildEditorInput((IBuild)item);
        }
        if (input != null) {
            try {
                IEditorPart part = page.openEditor((IEditorInput)input, "org.eclipse.mylyn.builds.ui.editors.Build");
                EditorHandle handle = new EditorHandle(Status.OK_STATUS);
                handle.setPart((IWorkbenchPart)part);
                return handle;
            }
            catch (PartInitException e) {
                Status status = new Status(4, "org.eclipse.mylyn.builds.ui", "Unexpected error while opening build", (Throwable)e);
                StatusHandler.log((IStatus)status);
                EditorHandle handle = new EditorHandle((IStatus)status);
                return handle;
            }
        }
        Status status = new Status(4, "org.eclipse.mylyn.builds.ui", "No editor available to open " + item);
        return new EditorHandle((IStatus)status);
    }

    private static boolean isPartial(IBuild element) {
        return element.getName() == null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            throw new ExecutionException("No active workbench window");
        }
        List<IBuildElement> elements = BuildsUiInternal.getElements(event);
        OpenHandler.open(page, elements);
        return null;
    }
}

