/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.commons.workbench.browser.AbstractUrlHandler;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.IWorkbenchPage;

public class GerritUrlHandler
extends AbstractUrlHandler {
    private static final Pattern URL_PATTERN = Pattern.compile("/?(#/c)?/(\\d+)");

    public EditorHandle openUrl(IWorkbenchPage page, String url, int customFlags) {
        for (TaskRepository repository : TasksUi.getRepositoryManager().getRepositories("org.eclipse.mylyn.gerrit")) {
            String taskId = this.getTaskId(repository, url);
            if (taskId == null) continue;
            return TasksUiUtil.openTaskWithResult((TaskRepository)repository, (String)taskId);
        }
        return null;
    }

    public String getTaskId(TaskRepository repository, String url) {
        String path;
        Matcher matcher;
        if (url.startsWith(repository.getRepositoryUrl()) && (matcher = URL_PATTERN.matcher(path = "/" + url.substring(repository.getRepositoryUrl().length()))).find()) {
            return matcher.group(2);
        }
        return null;
    }
}

