/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.parser.html;

import junit.framework.Assert;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.HtmlCleaner;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.junit.Test;

public class HtmlCleanerTest {
    @Test
    public void testFirstNode_MoveWhitespaceOutside() {
        String result = this.clean("<p>foo <span style=\"color:blue;\"> bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((String)result, (boolean)result.contains("<p>foo <span style=\"color: blue;\">bar</span></p>"));
    }

    @Test
    public void testFirstNode_MoveWhitespaceOutside2() {
        String result = this.clean("<p>foo <span style=\"color:blue;\"> <br/>bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p>foo <br /><span style=\"color: blue;\">bar</span></p>"));
    }

    @Test
    public void testLastNode_MoveWhitespaceOutside() {
        String result = this.clean("<p>foo <span style=\"color:blue;\"><br/>bar<br/> </span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p>foo <br /><span style=\"color: blue;\">bar</span><br /></p>"));
    }

    @Test
    public void testLastNode_MoveWhitespaceOutside2() {
        String result = this.clean("<p>foo <span style=\"color:blue;\"><br/>bar<br/>ab </span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p>foo <br /><span style=\"color: blue;\">bar<br />ab</span></p>"));
    }

    @Test
    public void testEmptyFontTag() {
        String result = this.clean("<p>foo <font color=\"red\"> </font>bar</p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p>foo  bar</p>"));
    }

    @Test
    public void testFontTag_Black() {
        String result = this.clean("<p>foo <font color=\"black\"> bar</font></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p>foo <span style=\"color: black;\">bar</span></p>"));
    }

    @Test
    public void testFontTag_Nothing() {
        String result = this.clean("<p>foo <font color=\"  \"> bar</font></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p>foo bar</p>"));
    }

    @Test
    public void testRemoveExcessiveStyles() {
        String result = this.clean("<p>foo <span > bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p>foo bar</p>"));
    }

    @Test
    public void testRemoveExcessiveStyles_lots_of_styles() {
        String result = this.clean("<p>foo <span style=\"font-style: italic;font-weight: bold; color: blue; bogus: bad; ignoreThis: too\"> bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p>foo <span style=\"font-style: italic;font-weight: bold;color: blue;\">bar</span></p>"));
    }

    @Test
    public void testRemoveExcessiveStyles_lots_of_styles2() {
        String result = this.clean("<p>foo <span style=\"bogus: bad; ignoreThis: too\"> bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p>foo bar</p>"));
    }

    @Test
    public void testRemoveSpanContainingOnlyWhitespace() {
        String result = this.clean("<p>foo<span> </span>bar</p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p>foo bar</p>"));
    }

    @Test
    public void testRepairSpanContainingMalformedCssColorStyle3CharactersNonHex() {
        String result = this.clean("<p><span style=\"color: 123\">foo bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p><span style=\"color: #123;\">foo bar</span></p>"));
    }

    @Test
    public void testRepairSpanContainingMalformedCssColorStyle6CharactersNonHex() {
        String result = this.clean("<p><span style=\"color: 123456\">foo bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p><span style=\"color: #123456;\">foo bar</span></p>"));
    }

    @Test
    public void testRepairSpanContainingMalformedCssColorStyle3CharactersHex() {
        String result = this.clean("<p><span style=\"color: adc\">foo bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p><span style=\"color: #adc;\">foo bar</span></p>"));
    }

    @Test
    public void testRepairSpanContainingMalformedCssColorStyle6CharactersHex() {
        String result = this.clean("<p><span style=\"color: afcebd\">foo bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p><span style=\"color: #afcebd;\">foo bar</span></p>"));
    }

    @Test
    public void testRepairSpanContainingMalformedCssColorStyle6CharactersMixed() {
        String result = this.clean("<p><span style=\"color: A1B2C3\">foo bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p><span style=\"color: #A1B2C3;\">foo bar</span></p>"));
    }

    @Test
    public void testRepairSpanContainingValidCssColorStyleHexNotChanged() {
        String result = this.clean("<p><span style=\"color: #ABCDEF\">foo bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p><span style=\"color: #ABCDEF;\">foo bar</span></p>"));
    }

    @Test
    public void testRepairSpanContainingValidCssColorStyleNonHexNotChanged() {
        String result = this.clean("<p><span style=\"color: red\">foo bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p><span style=\"color: red;\">foo bar</span></p>"));
    }

    @Test
    public void testRepairSpanContainingValidCssColorStyleNonHexLotsOfStylesNotChanged() {
        String result = this.clean("<p><span style=\"font-style: italic;font-weight: bold;color: red\">foo bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p><span style=\"font-style: italic;font-weight: bold;color: red;\">foo bar</span></p>"));
    }

    @Test
    public void testRepairSpanContainingMalformedCssColorStyle6CharactersMixedWithImportantDeclaration() {
        String result = this.clean("<p><span style=\"color: A1B2C3 !important\">foo bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p><span style=\"color: #A1B2C3 !important;\">foo bar</span></p>"));
    }

    @Test
    public void testRepairSpanContainingMalformedCssColorStyle6CharactersMixedWithImportantDeclarationLotsOfWhitespace() {
        String result = this.clean("<p><span style=\"  color: A1B2C3 !    important   \">foo bar</span></p>");
        TestUtil.println(result);
        Assert.assertTrue((boolean)result.contains("<p><span style=\"color: #A1B2C3 !    important;\">foo bar</span></p>"));
    }

    private String clean(String originalHtml) {
        Document document = Jsoup.parse((String)originalHtml);
        new HtmlCleaner().apply(document);
        String result = document.outerHtml();
        return result;
    }
}

