/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.util.concurrent.Worker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueueWorker<E>
extends Worker {
    public static final int DEFAULT_POLL_MILLIS = 100;
    private BlockingQueue<E> queue;
    private long pollMillis;

    public QueueWorker() {
        this.setPollMillis(100L);
    }

    public long getPollMillis() {
        return this.pollMillis;
    }

    public void setPollMillis(long pollMillis) {
        this.pollMillis = pollMillis;
    }

    public void clearQueue() {
        if (this.queue != null) {
            this.queue.clear();
        }
    }

    public boolean addWork(E element) {
        if (this.queue != null) {
            return this.queue.offer(element);
        }
        return false;
    }

    @Override
    protected void work(Worker.WorkContext context) throws Exception {
        if (this.queue == null) {
            context.terminate();
        } else {
            this.doWork(context);
        }
    }

    private void doWork(Worker.WorkContext context) throws InterruptedException {
        E element = this.queue.poll(this.pollMillis, TimeUnit.MILLISECONDS);
        if (element != null) {
            this.work(context, element);
        }
    }

    protected abstract void work(Worker.WorkContext var1, E var2);

    protected BlockingQueue<E> createQueue() {
        return new LinkedBlockingQueue();
    }

    protected boolean doRemainingWorkBeforeDeactivate() {
        return false;
    }

    @Override
    protected void doActivate() throws Exception {
        this.queue = this.createQueue();
        super.doActivate();
    }

    @Override
    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        if (this.queue != null) {
            if (this.doRemainingWorkBeforeDeactivate()) {
                Worker.WorkContext context = new Worker.WorkContext(this);
                while (!this.queue.isEmpty()) {
                    this.doWork(context);
                }
            } else {
                this.queue.clear();
            }
            this.queue = null;
        }
    }
}

