/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.internal.hook;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import org.eclipse.objectteams.otequinox.hook.ClassScanner;
import org.eclipse.objectteams.otequinox.hook.HookConfigurator;
import org.eclipse.objectteams.otequinox.hook.IByteCodeAnalyzer;
import org.eclipse.objectteams.otequinox.hook.ILogger;
import org.eclipse.objectteams.otequinox.hook.IOTEquinoxService;
import org.eclipse.objectteams.otequinox.hook.IOTTransformer;
import org.eclipse.objectteams.otequinox.hook.ITeamLoader;
import org.eclipse.objectteams.otequinox.internal.hook.AspectBundleRole;
import org.eclipse.objectteams.otequinox.internal.hook.BaseBundleRole;
import org.eclipse.objectteams.otequinox.internal.hook.BundleRegistry;
import org.eclipse.objectteams.otequinox.internal.hook.ByteCodeAnalyzer;
import org.eclipse.objectteams.otequinox.internal.hook.SafeAspectRegistry;
import org.eclipse.objectteams.otequinox.internal.hook.Util;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerHook
implements ClassLoadingHook,
BundleWatcher,
ClassLoaderDelegateHook,
ClassLoadingStatsHook {
    public static final String TRANSFORMER_PLUGIN_ID = "org.eclipse.objectteams.otequinox";
    private static final String TRANSFORMER_HOOK_ID = "org.eclipse.objectteams.otequinox.hook";
    private static final String WORKSPACE_INITIALIZER_PLUGIN_ID = "org.eclipse.objectteams.otdt.earlyui";
    private static final String OTDT_QUALIFIER = "OTDT";
    private static final String ASM_PLUGIN_ID = "org.objectweb.asm";
    private static final String BCEL_PLUGIN_ID = "org.apache.bcel";
    private static final String BCEL_PATH_DIR = "bcelpatch/";
    private static final String ORG_OBJECTTEAMS_TEAM = "org.objectteams.Team";
    private static final String ORG_OBJECTTEAMS_TEAMTHREADMANAGER = "org.objectteams.TeamThreadManager";
    private Class<?> teamThreadManagerClass;
    private static final HashSet<String> WEAVE_BUNDLES = new HashSet();
    private ClassLoader parentClassLoader;
    private final BundleRegistry bundleRegistry = new BundleRegistry();
    final HashMap<String, ClassKind> transformableClasses = new HashMap();
    protected final HashMap<BundleData, ProtectionDomain> domains = new HashMap();
    private PackageAdmin packageAdmin;
    Bundle otEquinoxBundle;
    private ITeamLoader teamLoadingService;
    private final SafeAspectRegistry aspectRegistry = new SafeAspectRegistry(this);
    private IByteCodeAnalyzer byteCodeAnalyzer;
    private final ILogger logger;
    private IOTTransformer transformerService;
    private final HashSet<Bundle> uninstalling = new HashSet();
    private HashMap<Bundle, BaseClassLoader> pendingClassLoaders = new HashMap();
    public HashSet<Bundle> pendingNonLazyActivationBundles = new HashSet();
    Stack<String> currentlyDefiningClasses = new Stack();
    List<Bundle> activatableBundles = new ArrayList<Bundle>();
    ThreadLocal<String> currentlyProcessedClassName = new ThreadLocal();
    ThreadLocal<String> currentlySearchedClassName = new ThreadLocal();

    static {
        String value = System.getProperty("otequinox.weave");
        if (value != null && value.length() > 0) {
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                WEAVE_BUNDLES.add(st.nextToken());
            }
        }
    }

    private void addTransformableClass(String className, ClassKind kind) {
        this.transformableClasses.put(className, kind);
        String ifcName = className.replace("__OT__", "");
        if (ifcName != className) {
            this.transformableClasses.put(ifcName, kind);
        }
    }

    private ClassKind fetchTransformationKind(byte[] classBytes, String className, ClassLoader resourceLoader, Bundle bundle) {
        ClassKind kind = this.transformableClasses.get(className);
        if (kind == ClassKind.BASE && !this.bundleRegistry.isAdaptedBaseBundle(bundle.getSymbolicName())) {
            kind = null;
        }
        if (kind != null || this.byteCodeAnalyzer == null) {
            return kind;
        }
        String superName = this.byteCodeAnalyzer.getSuperclass(classBytes, className);
        if (superName != null) {
            return this.fetchInheritedTransformationKind(superName, resourceLoader, bundle.getSymbolicName());
        }
        return kind;
    }

    private ClassKind fetchInheritedTransformationKind(String className, ClassLoader resourceLoader, String bundleName) {
        ClassKind kind = this.transformableClasses.get(className);
        if (kind == ClassKind.BASE && !this.bundleRegistry.isAdaptedBaseBundle(bundleName)) {
            kind = null;
        }
        if (kind != null) {
            return kind;
        }
        if ("java.lang.Object".equals(className)) {
            return null;
        }
        String superName = null;
        InputStream is = resourceLoader.getResourceAsStream(String.valueOf(className.replace('.', '/')) + ".class");
        if (is != null) {
            try {
                superName = this.byteCodeAnalyzer.getSuperclass(is, className);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (superName != null) {
            if ("java.lang.Thread".equals(superName)) {
                return ClassKind.BASE;
            }
            return this.fetchInheritedTransformationKind(superName, resourceLoader, bundleName);
        }
        return kind;
    }

    public TransformerHook(BaseAdaptor adaptor) {
        this.logger = HookConfigurator.getLogger();
        this.parentClassLoader = this.getClass().getClassLoader();
        this.logger.log(1, "Created equinox adaptor hook: " + this.getClass().getName() + ".\n \t(To disable this and subsequent INFO messages from OT/Equinox set otequinox.debug to WARN or ERROR).");
    }

    void connectOTEquinoxService(IOTEquinoxService otEquinoxService) {
        this.teamLoadingService = otEquinoxService;
        this.aspectRegistry.connectOTEquinoxService(otEquinoxService, this.logger);
        this.byteCodeAnalyzer = otEquinoxService.getByteCodeAnalyzer();
        this.logger.log(1, "OT/Equinox: connected the transformer service");
    }

    void connectOTTransformerService(IOTTransformer transformerService) {
        this.transformerService = transformerService;
    }

    void connectPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        block28: {
            var6_6 = this.currentlyDefiningClasses;
            synchronized (var6_6) {
                this.currentlyDefiningClasses.add(name);
            }
            previousClassName = this.currentlyProcessedClassName.get();
            this.currentlyProcessedClassName.set(name);
            try {
                block29: {
                    block30: {
                        bundle = manager.getBaseData().getBundle();
                        domain = this.domains.get(manager.getBaseData());
                        if (bundle == this.otEquinoxBundle) {
                            var17_10 = classbytes;
                            return var17_10;
                        }
                        if ("org.objectweb.asm".equals(bundle.getSymbolicName())) {
                            var17_11 = classbytes;
                            return var17_11;
                        }
                        if ("org.apache.bcel".equals(bundle.getSymbolicName())) {
                            var17_12 = this.fixBCEL(name, classbytes);
                            return var17_12;
                        }
                        if (name.equals(previousClassName)) {
                            this.logger.log(new Exception("unexpected loading situation"), "Recursion occurred loading class " + name + " from bundle " + bundle.getSymbolicName());
                            return null;
                        }
                        objectTeamsTransformer = null;
                        resourceLoader = null;
                        if (ClassScanner.REPOSITORY_USE_RESOURCE_LOADER) {
                            resourceLoader = (ClassLoader)manager.getBaseClassLoader();
                        }
                        time = 0L;
                        if (Util.PROFILE) {
                            time = System.nanoTime();
                        }
                        classKind = this.fetchTransformationKind(classbytes, name, resourceLoader, bundle);
                        if (Util.PROFILE) {
                            Util.profile(time, Util.ProfileKind.SuperClassFetching, "", this.logger);
                        }
                        if (classKind == ClassKind.BASE) {
                            objectTeamsTransformer = this.transformerService.getNewTransformer();
                            classbytes = this.transformClass(objectTeamsTransformer, resourceLoader, name, classbytes, domain, "potential base", Util.ProfileKind.BaseTransformation);
                            break block28;
                        }
                        if (classKind == ClassKind.ROLE) {
                            objectTeamsTransformer = this.transformerService.getNewTransformer();
                            classbytes = this.transformClass(objectTeamsTransformer, resourceLoader, name, classbytes, domain, "role", Util.ProfileKind.AspectTransformation);
                            break block28;
                        }
                        isLoading = AspectBundleRole.isLoadingTeams(this.bundleRegistry, bundle.getSymbolicName());
                        if (!isLoading && !ByteCodeAnalyzer.isTeam(classbytes)) ** GOTO lbl66
                        if (bundle.getState() >= 8 || !this.aspectRegistry.hasInternalTeams(bundle)) break block29;
                        this.logger.doLog(4, "Illegal state: loading team class " + name + " from bundle " + bundle.getSymbolicName() + " \n" + "while this bundle has not been activated yet (state=" + bundle.getState() + ").\n" + "Aspect bindings will not be woven.\n" + "Note: Perhaps the bundle lacks an activation policy (lazy)?");
                        if (isLoading) break block30;
                        {
                            catch (Throwable var15_18) {
                                throw var15_18;
                            }
                        }
                        AspectBundleRole.markLoadingTeams(this.bundleRegistry, bundle.getSymbolicName(), false);
                    }
                    return null;
                }
                try {
                    try {
                        AspectBundleRole.markLoadingTeams(this.bundleRegistry, bundle.getSymbolicName(), true);
                        objectTeamsTransformer = this.transformerService.getNewTransformer();
                        classbytes = this.transformClass(objectTeamsTransformer, resourceLoader, name, classbytes, domain, "team", Util.ProfileKind.AspectTransformation);
                        break block28;
                    }
                    finally {
                        if (!isLoading) {
                            AspectBundleRole.markLoadingTeams(this.bundleRegistry, bundle.getSymbolicName(), false);
                        }
                    }
lbl66:
                    // 1 sources

                    if (this.otEquinoxBundle != null && TransformerHook.WEAVE_BUNDLES.contains(bundle.getSymbolicName()) && this.aspectRegistry.isAdaptedBasePlugin(bundle.getSymbolicName())) {
                        objectTeamsTransformer = this.transformerService.getNewTransformer();
                        classbytes = this.transformClass(objectTeamsTransformer, resourceLoader, name, classbytes, domain, "ordinary class (could be sub base class)", Util.ProfileKind.BaseTransformation);
                    }
                }
                catch (IllegalClassFormatException icfe) {
                    icfe.printStackTrace();
                }
            }
            finally {
                this.currentlyProcessedClassName.set(previousClassName);
            }
        }
        return classbytes;
    }

    /*
     * Loose catch block
     */
    private byte[] fixBCEL(String name, byte[] classbytes) {
        String detail;
        long crc;
        CRC32 crc32;
        boolean shouldPatch = false;
        if ("org.apache.bcel.generic.InstructionHandle".equals(name)) {
            crc32 = new CRC32();
            crc32.update(classbytes);
            crc = crc32.getValue();
            detail = "";
            if (classbytes.length != 5667) {
                detail = String.valueOf(detail) + "\n\tlength=" + classbytes.length;
            }
            if (crc != 1108549767L && crc != 3676018777L) {
                detail = String.valueOf(detail) + "\n\tcrc=" + crc;
            }
            if (classbytes[3840] != 24) {
                detail = String.valueOf(detail) + "\n\tmodifiers of getInstructionHandle=" + classbytes[3840];
            }
            if (classbytes[4188] != 4) {
                detail = String.valueOf(detail) + "\n\tmodifiers of addHandle=" + classbytes[4188];
            }
            if (detail.length() == 0) {
                shouldPatch = true;
            } else {
                this.logger.log(2, "Class org.apache.bcel.generic.InstructionHandle needs a hot-patch but has unexpected byte code:" + detail);
            }
        } else if ("org.apache.bcel.generic.BranchHandle".equals(name)) {
            crc32 = new CRC32();
            crc32.update(classbytes);
            crc = crc32.getValue();
            detail = "";
            if (classbytes.length != 2545) {
                detail = String.valueOf(detail) + "\n\tlength=" + classbytes.length;
            }
            if (crc != 3552803865L && crc != 1958668062L) {
                detail = String.valueOf(detail) + "\n\tcrc=" + crc;
            }
            if (classbytes[1662] != 24) {
                detail = String.valueOf(detail) + "\n\tmodifiers of getBranchHandle=" + classbytes[1662];
            }
            if (classbytes[1784] != 4) {
                detail = String.valueOf(detail) + "\n\tmodifiers of addHandle=" + classbytes[1784];
            }
            if (detail.length() == 0) {
                shouldPatch = true;
            } else {
                this.logger.log(2, "Class org.apache.bcel.generic.BranchHandle needs a hot-patch but has unexpected byte code:" + detail);
            }
        }
        if (shouldPatch) {
            byte[] byArray;
            InputStream stream;
            block27: {
                Bundle transformer = this.packageAdmin.getBundles(TRANSFORMER_HOOK_ID, null)[0];
                URL entry = transformer.getEntry(BCEL_PATH_DIR + name + ".class");
                stream = null;
                stream = entry.openStream();
                int len = stream.available();
                byte[] newBytes = new byte[len];
                stream.read(newBytes);
                this.logger.log(1, "hot-patched a bug in class " + name + "\n" + "\tsee https://bugs.eclipse.org/bugs/show_bug.cgi?id=344350");
                byArray = newBytes;
                if (stream == null) break block27;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            return byArray;
            catch (IOException e) {
                byte[] byArray2;
                block28: {
                    try {
                        this.logger.log(e, "Failed to hot-patch bcel class " + name);
                        byArray2 = classbytes;
                        if (stream == null) break block28;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                return byArray2;
            }
        }
        return classbytes;
    }

    private byte[] transformClass(ClassFileTransformer objectTeamsTransformer, ClassLoader resourceLoader, String name, byte[] classbytes, ProtectionDomain domain, String kind, Util.ProfileKind profileKind) throws IllegalClassFormatException {
        this.logger.log(0, "about to transform " + kind + " class " + name);
        long time = 0L;
        if (Util.PROFILE) {
            time = System.nanoTime();
        }
        classbytes = objectTeamsTransformer.transform(resourceLoader, name.replace('.', '/'), null, domain, classbytes);
        if (Util.PROFILE) {
            Util.profile(time, profileKind, name, this.logger);
        }
        return classbytes;
    }

    public boolean addClassPathEntry(ArrayList<ClasspathEntry> cpEntries, String cp, ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) {
        return false;
    }

    public String findLibrary(BaseData data, String libName) {
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return this.parentClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseClassLoader createClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, BundleProtectionDomain domain, BaseData data, String[] bundleclasspath) {
        BaseBundleRole baseBundle;
        Bundle bundle = data.getBundle();
        HashMap<Bundle, BaseClassLoader> hashMap = this.pendingClassLoaders;
        synchronized (hashMap) {
            if (this.pendingClassLoaders.containsKey(bundle)) {
                return this.pendingClassLoaders.get(bundle);
            }
        }
        if (bundle != this.otEquinoxBundle && !this.uninstalling.contains(bundle) && this.aspectRegistry.isAdaptedBasePlugin(bundle.getSymbolicName()) && (baseBundle = this.bundleRegistry.adaptedBaseBundles.get(bundle.getSymbolicName())) != null && baseBundle.state != BaseBundleRole.State.INITIAL) {
            HashMap<Bundle, BaseClassLoader> hashMap2 = this.pendingClassLoaders;
            synchronized (hashMap2) {
                if (!this.pendingClassLoaders.containsKey(bundle)) {
                    this.logger.log(2, "False alarm regarding circular class path for " + bundle.getSymbolicName() + ", bundle state is " + (Object)((Object)baseBundle.state));
                    return null;
                }
            }
            this.logger.log(new ClassCircularityError(), "Circular class path for " + bundle.getSymbolicName() + ", bundle state is " + (Object)((Object)baseBundle.state));
            return new DefaultClassLoader(parent, delegate, (ProtectionDomain)domain, data, bundleclasspath){

                public Class<?> findLocalClass(String classname) throws ClassNotFoundException {
                    throw new ClassNotFoundException("Has already reported class path circularity");
                }

                public URL findLocalResource(String resource) {
                    return null;
                }

                public void initialize() {
                }

                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    throw new ClassNotFoundException("Has already reported class path circularity");
                }
            };
        }
        return null;
    }

    public void initializedClassLoader(BaseClassLoader bundleClassLoader, BaseData data) {
        Bundle bundle;
        ProtectionDomain domain = bundleClassLoader.getDomain();
        if (domain != null) {
            this.domains.put((BundleData)data, domain);
        }
        if ((bundle = data.getBundle()) == this.otEquinoxBundle) {
            return;
        }
        if (this.uninstalling.contains(bundle)) {
            return;
        }
        if (this.pendingClassLoaders.containsKey(bundle)) {
            return;
        }
        String[] adaptedBaseBundles = this.aspectRegistry.getAdaptedBasePlugins(bundle);
        if (adaptedBaseBundles != null) {
            String[] stringArray = adaptedBaseBundles;
            int n = adaptedBaseBundles.length;
            int n2 = 0;
            while (n2 < n) {
                String baseID = stringArray[n2];
                Bundle baseBundle = null;
                if (baseID.toUpperCase().equals("SELF")) {
                    baseBundle = bundle;
                } else {
                    Bundle[] baseBundles = this.packageAdmin.getBundles(baseID, null);
                    if (baseBundles == null) {
                        this.logger.log(4, "Adapted base bundle " + baseID + " not found.");
                    } else if (baseBundles.length > 1) {
                        baseBundle = baseBundles[0];
                        int i = 1;
                        while (i < baseBundles.length) {
                            if (baseBundle.getVersion().compareTo(baseBundles[i].getVersion()) < 0) {
                                baseBundle = baseBundles[i];
                            }
                            ++i;
                        }
                        this.logger.log(2, "Found more than one version of adapted base bundle " + baseID + ", picked version " + baseBundle.getVersion() + ".");
                    } else {
                        baseBundle = baseBundles[0];
                    }
                }
                if (baseBundle != null) {
                    BaseBundleRole.createBaseBundleRole(this.bundleRegistry, baseBundle, bundle);
                }
                ++n2;
            }
        }
        if (this.teamLoadingService != null) {
            this.checkLoadTeams(bundleClassLoader, bundle);
        } else if (!Util.isPlatformBundle(bundle.getSymbolicName())) {
            this.logger.log(2, "Not loading teams for bundle " + bundle.getSymbolicName() + " (transformerPlugin not yet initialized)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLoadTeams(BaseClassLoader bundleClassLoader, Bundle bundle) {
        HashMap<Bundle, BaseClassLoader> hashMap = this.pendingClassLoaders;
        synchronized (hashMap) {
            this.pendingClassLoaders.put(bundle, bundleClassLoader);
        }
        ClassScanner scanner = new ClassScanner(this.transformerService);
        this.bundleRegistry.checkLoadTeams(bundle, this.aspectRegistry, this.teamLoadingService, scanner);
        this.recordRolesAndBases(scanner);
    }

    private void recordRolesAndBases(ClassScanner scanner) {
        Collection<String> roleClassNames;
        Collection<String> baseClassNames = scanner.getCollectedBaseClassNames();
        if (baseClassNames != null) {
            for (String baseClassName : baseClassNames) {
                this.addTransformableClass(baseClassName, ClassKind.BASE);
            }
        }
        if ((roleClassNames = scanner.getCollectedRoleClassNames()) != null) {
            for (String roleClassName : roleClassNames) {
                this.addTransformableClass(roleClassName, ClassKind.ROLE);
            }
        }
    }

    public void watchBundle(Bundle bundle, int type) {
        if (type == 4) {
            if (TRANSFORMER_PLUGIN_ID.equals(bundle.getSymbolicName())) {
                this.otEquinoxBundle = bundle;
            }
            this.checkJdtCoreOrig(bundle);
            this.checkInternalTeams(bundle);
        }
        if (type == 8) {
            Util.reportBundleStateChange(bundle, type, this.logger);
            if ("org.eclipse.core.runtime".equals(bundle.getSymbolicName())) {
                this.startTransformerBundle();
            }
            if (bundle != this.otEquinoxBundle) {
                BaseBundleRole.endActivation(this.bundleRegistry, bundle, this.aspectRegistry, this.teamLoadingService);
            }
        } else if (type == 64) {
            this.uninstalling.add(bundle);
        } else if (type == 128) {
            this.uninstalling.remove(bundle);
        }
    }

    private void checkInternalTeams(Bundle bundle) {
        if (this.aspectRegistry.hasInternalTeams(bundle)) {
            this.bundleRegistry.createAspectRole(bundle.getSymbolicName());
            this.logger.log(0, "Will load internal teams of " + bundle.getSymbolicName());
            ClassScanner scanner = new ClassScanner(this.transformerService);
            if (this.teamLoadingService.loadInternalTeams(bundle, scanner)) {
                this.recordRolesAndBases(scanner);
                BaseBundleRole baseRole = BaseBundleRole.createBaseBundleRole(this.bundleRegistry, bundle, bundle);
                baseRole.state = BaseBundleRole.State.TEAMS_LOADED;
                this.logger.log(1, "Loaded internal teams of " + bundle.getSymbolicName());
            } else {
                this.logger.log(4, "Failed to load internal teams of " + bundle.getSymbolicName());
            }
        }
    }

    private void checkJdtCoreOrig(Bundle bundle) {
        BundleHost host;
        if (!this.aspectRegistry.isOTDT()) {
            return;
        }
        if ("org.eclipse.jdt.core".equals(bundle.getSymbolicName()) && bundle instanceof BundleHost && !(host = (BundleHost)bundle).getVersion().getQualifier().contains(OTDT_QUALIFIER)) {
            throw new Error("Fatal dependency problem: loading wrong version '" + host.getVersion() + "' of plug-in " + bundle.getSymbolicName());
        }
    }

    private void startTransformerBundle() {
        if (this.otEquinoxBundle != null) {
            return;
        }
        this.otEquinoxBundle = this.startBundle(TRANSFORMER_PLUGIN_ID, true);
        this.startBundle(WORKSPACE_INITIALIZER_PLUGIN_ID, false);
    }

    private Bundle startBundle(String bundleID, boolean logError) {
        Bundle bundle;
        block4: {
            Bundle[] candidates = this.packageAdmin.getBundles(bundleID, null);
            if (candidates == null) {
                if (logError) {
                    this.logger.log(4, "Bundle " + bundleID + " not found");
                }
                return null;
            }
            bundle = candidates[0];
            try {
                bundle.start();
            }
            catch (Exception e) {
                if (!logError) break block4;
                this.logger.log(e, "Error starting the OT/Equinox transformer plug-in");
            }
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> preFindClass(String name, BundleClassLoader classLoader, BundleData data) throws ClassNotFoundException {
        if (this.aspectRegistry.isDeniedAspectPlugin(data.getSymbolicName())) {
            throw new ClassNotFoundException(String.valueOf(name) + " from denied aspect bundle " + data.getSymbolicName());
        }
        BaseBundleRole baseBundle = this.bundleRegistry.adaptedBaseBundles.get(data.getSymbolicName());
        if (baseBundle == null) {
            return null;
        }
        BaseBundleRole baseBundleRole = baseBundle;
        synchronized (baseBundleRole) {
            if (baseBundle.missingClassNames.contains(name)) {
                throw new ClassNotFoundException(name);
            }
        }
        return baseBundle.knownAlienClasses.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> postFindClass(String name, BundleClassLoader classLoader, BundleData data) {
        if (name.equals(this.currentlySearchedClassName.get())) {
            return null;
        }
        if (name.equals(ORG_OBJECTTEAMS_TEAMTHREADMANAGER)) {
            return this.teamThreadManagerClass;
        }
        String bundleSymbolicName = data.getSymbolicName();
        BaseBundleRole baseBundle = this.bundleRegistry.adaptedBaseBundles.get(bundleSymbolicName);
        if (baseBundle == null) {
            return null;
        }
        if (baseBundle.state == BaseBundleRole.State.WAIT_FOR_TEAM) {
            this.logger.log(2, "Base plugin " + bundleSymbolicName + " is not yet ready for delegated classloading");
        } else if (baseBundle.aspectBundles.isEmpty()) {
            this.logger.log(2, ">>> adapting aspect bundles not yet wired when loading: " + name);
        } else {
            this.currentlySearchedClassName.set(name);
            try {
                for (Bundle aspectBundle : baseBundle.aspectBundles) {
                    if (aspectBundle.getBundleId() == data.getBundleID()) continue;
                    try {
                        Class result = aspectBundle.loadClass(name);
                        if (result == null) continue;
                        baseBundle.knownAlienClasses.put(name, result);
                        this.logger.log(0, "loaded alien class from aspect plugin: " + name);
                        Class clazz = result;
                        return clazz;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
            finally {
                this.currentlySearchedClassName.set(null);
            }
            BaseBundleRole baseBundleRole = baseBundle;
            synchronized (baseBundleRole) {
                baseBundle.missingClassNames.add(name);
            }
        }
        return null;
    }

    public String postFindLibrary(String name, BundleClassLoader classLoader, BundleData data) {
        return null;
    }

    public URL postFindResource(String name, BundleClassLoader classLoader, BundleData data) {
        return null;
    }

    public Enumeration<URL> postFindResources(String name, BundleClassLoader classLoader, BundleData data) {
        return null;
    }

    public String preFindLibrary(String name, BundleClassLoader classLoader, BundleData data) {
        return null;
    }

    public URL preFindResource(String name, BundleClassLoader classLoader, BundleData data) {
        return null;
    }

    public Enumeration<URL> preFindResources(String name, BundleClassLoader classLoader, BundleData data) {
        return null;
    }

    public void preFindLocalClass(String name, ClasspathManager manager) throws ClassNotFoundException {
    }

    public synchronized void postFindLocalClass(String name, Class<?> clazz, ClasspathManager manager) throws ClassNotFoundException {
    }

    public void preFindLocalResource(String name, ClasspathManager manager) {
    }

    public void postFindLocalResource(String name, URL resource, ClasspathManager manager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordClassDefine(String name, Class<?> clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        Object bundle;
        List<Bundle> list = this.activatableBundles;
        synchronized (list) {
            bundle = manager.getBaseData().getBundle();
            if (this.pendingNonLazyActivationBundles.remove(bundle)) {
                this.activatableBundles.add((Bundle)bundle);
            }
        }
        boolean shouldTrigger = false;
        bundle = this.currentlyDefiningClasses;
        synchronized (bundle) {
            this.currentlyDefiningClasses.remove(name);
            if (this.currentlyDefiningClasses.isEmpty()) {
                shouldTrigger = true;
            }
        }
        if (shouldTrigger) {
            Bundle[] copy;
            List<Bundle> list2 = this.activatableBundles;
            synchronized (list2) {
                copy = this.activatableBundles.toArray(new Bundle[this.activatableBundles.size()]);
                this.activatableBundles.clear();
            }
            Bundle[] bundleArray = copy;
            int n = copy.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle2 = bundleArray[n2];
                BaseBundleRole.endActivation(this.bundleRegistry, bundle2, this.aspectRegistry, this.teamLoadingService);
                ++n2;
            }
        }
        if (name.startsWith("org.objectteams")) {
            if (name.equals(ORG_OBJECTTEAMS_TEAM)) {
                this.teamLoadingService.initializeOOTeam(clazz);
            } else if (name.equals(ORG_OBJECTTEAMS_TEAMTHREADMANAGER)) {
                this.teamThreadManagerClass = clazz;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ClassKind {
        BASE,
        ROLE,
        TEAM;

    }
}

