/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.ocl.examples.eventmanager.framework.EventManagerTableBased;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanupThread
extends Thread {
    private Logger logger = Logger.getLogger(CleanupThread.class.getName());
    private final ReferenceQueue<Adapter> adaptersNoLongerStronglyReferenced;
    private final WeakReference<EventManagerTableBased> eventManagerRef;
    private Adapter stopThreadAdapter;
    private final WeakReference<Adapter> stopThreadMarker;

    public CleanupThread(ReferenceQueue<Adapter> adaptersNoLongerStronglyReferenced, EventManagerTableBased eventManager) {
        this.adaptersNoLongerStronglyReferenced = adaptersNoLongerStronglyReferenced;
        this.stopThreadAdapter = new AdapterImpl();
        this.stopThreadMarker = new WeakReference<Adapter>(this.stopThreadAdapter, adaptersNoLongerStronglyReferenced);
        this.eventManagerRef = new WeakReference<EventManagerTableBased>(eventManager);
    }

    public void stopCleaner() {
        this.stopThreadAdapter = null;
    }

    @Override
    public void run() {
        try {
            Reference<Adapter> adapterRef = this.adaptersNoLongerStronglyReferenced.remove();
            while (adapterRef != this.stopThreadMarker) {
                EventManagerTableBased eventManager = (EventManagerTableBased)this.eventManagerRef.get();
                if (eventManager != null) {
                    eventManager.deregister(adapterRef);
                }
                adapterRef = this.adaptersNoLongerStronglyReferenced.remove();
            }
        }
        catch (InterruptedException e) {
            this.logger.throwing(this.getClass().getName(), "run", e);
        }
    }
}

