/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.classifier;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractUnaryOperation;
import org.eclipse.ocl.examples.domain.values.TypeValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class ClassifierAllInstancesOperation
extends AbstractUnaryOperation {
    public static final ClassifierAllInstancesOperation INSTANCE = new ClassifierAllInstancesOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceVal) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        TypeValue typeVal = sourceVal.asTypeValue();
        DomainModelManager modelManager = evaluator.getModelManager();
        HashSet<Value> results = new HashSet<Value>();
        Set instances = modelManager.get(typeVal.getInstanceType());
        if (instances != null) {
            for (Object instance : instances) {
                results.add(valueFactory.valueOf(instance));
            }
        }
        return valueFactory.createSetValue((DomainCollectionType)returnType, results);
    }
}

