/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.collection;

import java.util.Set;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class CollectionProductOperation
extends AbstractBinaryOperation {
    public static final CollectionProductOperation INSTANCE = new CollectionProductOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceVal, Value argVal) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        CollectionValue sourceValue = sourceVal.asCollectionValue();
        CollectionValue argumentValue = argVal.asCollectionValue();
        DomainCollectionType collType = (DomainCollectionType)returnType;
        DomainTupleType tupleType = (DomainTupleType)collType.getElementType();
        Set product = sourceValue.product(argumentValue, tupleType);
        return valueFactory.createSetValue(collType, product);
    }
}

