/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.ecore;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.domain.values.ObjectValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ExecutorFragment;
import org.eclipse.ocl.examples.library.executor.ExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ExecutorType;
import org.eclipse.ocl.examples.library.executor.ExecutorTypeParameter;

public class EcoreExecutorType
extends ExecutorType {
    protected EClassifier eClassifier;

    public EcoreExecutorType(String name, ExecutorPackage evaluationPackage, int flags, ExecutorTypeParameter ... typeParameters) {
        super(name, evaluationPackage, flags, typeParameters);
        this.eClassifier = null;
    }

    public EcoreExecutorType(EClassifier eClassifier, EcoreExecutorPackage evaluationPackage, int flags, ExecutorTypeParameter ... typeParameters) {
        super(eClassifier.getName(), evaluationPackage, flags, typeParameters);
        this.eClassifier = eClassifier;
    }

    public ObjectValue createInstance(ValueFactory valueFactory) {
        if (this.eClassifier instanceof EClass) {
            EClass eClass = (EClass)this.eClassifier;
            EObject element = eClass.getEPackage().getEFactoryInstance().create(eClass);
            return valueFactory.createObjectValue((Object)element);
        }
        return super.createInstance(valueFactory);
    }

    public Value createInstance(ValueFactory valueFactory, String value) {
        if (this.eClassifier instanceof EDataType) {
            EDataType eDataType = (EDataType)this.eClassifier;
            Object element = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, value);
            return valueFactory.valueOf(element);
        }
        return super.createInstance(valueFactory);
    }

    public final EClassifier getEClassifier() {
        return this.eClassifier;
    }

    public String getMetaTypeName() {
        return this.eClassifier.getName();
    }

    public EcoreExecutorType initFragments(ExecutorFragment[] fragments, int[] depthCounts, EClassifier eClassifier) {
        assert (this.eClassifier == null);
        assert (this.name.equals(eClassifier.getName()));
        this.eClassifier = eClassifier;
        this.initFragments(fragments, depthCounts);
        return this;
    }
}

