/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.oclany;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class OclAnyEqualOperation
extends AbstractBinaryOperation {
    public static final OclAnyEqualOperation INSTANCE = new OclAnyEqualOperation();

    public BooleanValue evaluate(DomainEvaluator evaluator, DomainType returnType, Value left, Value right) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        if (left.isInvalid()) {
            valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, new Object[]{"="});
        }
        if (right.isInvalid()) {
            valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidArgument, new Object[]{"="});
        }
        return valueFactory.booleanValueOf(left.equals(right));
    }
}

