/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class StringLastIndexOfOperation
extends AbstractBinaryOperation {
    public static final StringLastIndexOfOperation INSTANCE = new StringLastIndexOfOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value left, Value right) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        String leftString = left.asString();
        String rightString = right.asString();
        if (rightString.length() <= 0) {
            return valueFactory.integerValueOf(leftString.length() + 1);
        }
        int index = leftString.lastIndexOf(rightString);
        if (index >= 0) {
            return valueFactory.integerValueOf(index + 1);
        }
        return valueFactory.integerValueOf(0);
    }
}

