/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.environment;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ocl.examples.modelregistry.environment.ModelSerializationRegistry;
import org.eclipse.ocl.examples.modelregistry.model.NamespaceRegistry;
import org.eclipse.ocl.examples.modelregistry.standalone.JavaModelRegistryEnvironment;

public abstract class ModelRegistryEnvironment {
    public static final String PLUGIN_ID = "org.eclipse.ocl.examples.modelregistry";
    private static ModelRegistryEnvironment INSTANCE = null;
    private NamespaceRegistry namespaceRegistry = null;
    private ModelSerializationRegistry modelSerializationRegistry = null;

    public static ModelRegistryEnvironment getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JavaModelRegistryEnvironment();
        }
        return INSTANCE;
    }

    public static void logError(String string, Throwable e) {
        ModelRegistryEnvironment.getInstance().logTheError(string, e);
    }

    protected ModelRegistryEnvironment() {
        INSTANCE = this;
    }

    protected ModelSerializationRegistry createModelSerializationRegistry() {
        return new ModelSerializationRegistry();
    }

    protected NamespaceRegistry createNamespaceRegistry() {
        return new NamespaceRegistry();
    }

    public File getFile(URI uri) throws URISyntaxException, IOException {
        String fileString = uri.toString();
        URL url = new URL(fileString);
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        return new File(url.toString().substring(5));
    }

    public ModelSerializationRegistry getModelSerializationRegistry() {
        if (this.modelSerializationRegistry == null) {
            this.modelSerializationRegistry = this.createModelSerializationRegistry();
            this.initializeModelSerializationRegistry(this.modelSerializationRegistry);
        }
        return this.modelSerializationRegistry;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        if (this.namespaceRegistry == null) {
            this.namespaceRegistry = this.createNamespaceRegistry();
            this.initializeNamespaceRegistry(this.namespaceRegistry);
        }
        return this.namespaceRegistry;
    }

    protected abstract void initializeModelSerializationRegistry(ModelSerializationRegistry var1);

    protected abstract void initializeNamespaceRegistry(NamespaceRegistry var1);

    public abstract void logTheError(String var1, Throwable var2);
}

