/**
 * <copyright>
 *
 * Copyright (c) 2010,2011 E.D.Willink and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   E.D.Willink - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: BasePostOrderVisitor.java,v 1.10 2011/05/20 15:27:24 ewillink Exp $
 */
package org.eclipse.ocl.examples.xtext.base.cs2pivot;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Detail;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.AnnotationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.AnnotationElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DetailCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DocumentationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.LambdaTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.LibraryCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MultiplicityBoundsCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MultiplicityStringCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.OperationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PrimitiveTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ReferenceCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateSignatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateableElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TuplePartCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TupleTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.util.AbstractExtendingBaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.util.VisitableCS;

public class BasePostOrderVisitor extends AbstractExtendingBaseCSVisitor<Continuation<?>, CS2PivotConversion>
{
	public static class ConstraintCSCompletion extends SingleContinuation<ConstraintCS>
	{
		public ConstraintCSCompletion(CS2PivotConversion context, ConstraintCS csElement) {
			super(context, null, null, csElement);
		}

		@Override
		public BasicContinuation<?> execute() {
			context.visitLeft2Right(Constraint.class, csElement);
			return null;
		}
	}
	
	public BasePostOrderVisitor(CS2PivotConversion context) {
		super(context);
	}

	protected TemplateableElementCS getTemplateableElementContainer(ElementCS csElement) {
		for (EObject eObject = csElement; eObject != null; eObject = eObject.eContainer())
			if (eObject instanceof TemplateableElementCS) {
				return (TemplateableElementCS) eObject;
			}
		return null;
	}

	protected <CST extends ModelElementCS, P extends NamedElement> BasicContinuation<?> refreshList(NamedElement pivotParent, EStructuralFeature pivotFeature,
		final Class<P> pivotClass, final List<P> pivotElements, List<CST> csElements) {
		if (csElements.isEmpty()) {
			context.refreshPivotList(pivotClass, pivotElements, csElements);
			return null;
		}
		else {
			return new MultipleContinuation<CST>(context, pivotParent, pivotFeature, csElements, new PivotDependencies(csElements)) 
			{
				@Override
				public BasicContinuation<?> execute() {
					context.refreshPivotList(pivotClass, pivotElements, csElement);
					return null;
				}			
			};
		}
	}

	public Continuation<?> visiting(VisitableCS visitable) {
		throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for CS2Pivot PostOrder pass");
	}

	@Override
	public Continuation<?> visitAnnotationCS(AnnotationCS csAnnotation) {
		Annotation pivotElement = PivotUtil.getPivot(Annotation.class, csAnnotation);
		context.handleVisitNamedElement(csAnnotation, pivotElement);
		context.refreshPivotList(Detail.class, pivotElement.getOwnedDetail(), csAnnotation.getOwnedDetail());
		context.refreshPivotList(Element.class, pivotElement.getOwnedContent(), csAnnotation.getOwnedContent());
		List<ModelElementRefCS> csReferences = csAnnotation.getOwnedReference();
		if (csReferences.size() > 0) {
			List<Element> references = new ArrayList<Element>(csReferences.size());
			for (ModelElementRefCS csReference : csReferences) {
				references.add(csReference.getElement());
			}
			context.refreshList(pivotElement.getReference(), references);
		}
		else {
			pivotElement.getReference().clear();
		}
		return null;
	}

	@Override
	public Continuation<?> visitAnnotationElementCS(AnnotationElementCS csAnnotationElement) {
		return null;
	}

	@Override
	public Continuation<?> visitClassifierCS(ClassifierCS csClassifier) {
		Type pivotElement = PivotUtil.getPivot(Type.class, csClassifier);
		context.handleVisitNamedElement(csClassifier, pivotElement);
		context.refreshPivotList(Constraint.class, pivotElement.getOwnedRule(), csClassifier.getOwnedConstraint());
		return null;
	}

	@Override
	public Continuation<?> visitConstraintCS(ConstraintCS csConstraint) {
		Constraint pivotElement = PivotUtil.getPivot(Constraint.class, csConstraint);
		pivotElement.setStereotype(csConstraint.getStereotype());
		if (csConstraint.getSpecification() != null) {
			return new ConstraintCSCompletion(context, csConstraint);
		}
		else {
			return null;
		}
	}

	@Override
	public Continuation<?> visitDetailCS(DetailCS csDetail) {
		Detail pivotElement = PivotUtil.getPivot(Detail.class, csDetail);
		context.handleVisitNamedElement(csDetail, pivotElement);
//			refreshPivotList(Detail.class, pivotElement.getOwnedDetail(), csDocumentation.getOwnedDetail());
		List<String> newValues = csDetail.getValue();
		List<String> pivotValues = pivotElement.getValue();
		pivotValues.clear();
		pivotValues.addAll(newValues);
		return null;
	}

	@Override
	public Continuation<?> visitDocumentationCS(DocumentationCS csDocumentation) {
		Annotation pivotElement = PivotUtil.getPivot(Annotation.class, csDocumentation);
		context.handleVisitNamedElement(csDocumentation, pivotElement);
		context.refreshPivotList(Detail.class, pivotElement.getOwnedDetail(), csDocumentation.getOwnedDetail());
		return null;
	}

	@Override
	public Continuation<?> visitElementCS(ElementCS csElement) {
		return visiting(csElement);
	}

	@Override
	public Continuation<?> visitImportCS(ImportCS object) {
		return null;
	}

	@Override
	public Continuation<?> visitLambdaTypeCS(LambdaTypeCS object) {
		return null;
	}

	@Override
	public Continuation<?> visitLibraryCS(LibraryCS object) {
		return null;
	}

	@Override
	public Continuation<?> visitModelElementCS(ModelElementCS csModelElement) {
		return null;
	}

	@Override
	public Continuation<?> visitModelElementRefCS(ModelElementRefCS object) {
		Element element = object.getPathName().getElement();
		context.installPivotReference(object, element, BaseCSTPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
		return null;
	}

	@Override
	public Continuation<?> visitMultiplicityBoundsCS(MultiplicityBoundsCS object) {
		return null;
	}

	@Override
	public Continuation<?> visitMultiplicityStringCS(MultiplicityStringCS object) {
		return null;
	}

	@Override
	public Continuation<?> visitNamedElementCS(NamedElementCS csNamedElement) {
		NamedElement pivotElement = PivotUtil.getPivot(NamedElement.class, csNamedElement);
		context.handleVisitNamedElement(csNamedElement, pivotElement);
		return null;
	}

	@Override
	public Continuation<?> visitOperationCS(OperationCS csElement) {
		Operation pivotOperation = PivotUtil.getPivot(Operation.class, csElement);
		context.refreshList(Type.class, pivotOperation.getRaisedException(), csElement.getOwnedException());
		return super.visitOperationCS(csElement);
	}

	@Override
	public Continuation<?> visitPackageCS(PackageCS csPackage) {
		org.eclipse.ocl.examples.pivot.Package pivotElement = PivotUtil.getPivot(org.eclipse.ocl.examples.pivot.Package.class, csPackage);
		context.handleVisitNamedElement(csPackage, pivotElement);
		return null;
	}

	@Override
	public Continuation<?> visitPathElementCS(PathElementCS object) {
		return null;
	}

	@Override
	public Continuation<?> visitPathNameCS(PathNameCS object) {
		return null;
	}

	@Override
	public Continuation<?> visitPrimitiveTypeRefCS(PrimitiveTypeRefCS csPrimitiveTypeRef) {
		return null;
	}

	@Override
	public Continuation<?> visitReferenceCS(ReferenceCS csReference) {
		Property pivotElement = PivotUtil.getPivot(Property.class, csReference);
		Property pivotOpposite = csReference.getOpposite();
		if ((pivotOpposite != null) && pivotOpposite.eIsProxy()) {
			pivotOpposite = null;
		}
		pivotElement.setOpposite(pivotOpposite);
		context.refreshList(pivotElement.getKeys(), csReference.getKeys());
		BasicContinuation<?> continuation = visitTypedElementCS(csReference);
		assert continuation == null;
		if (pivotOpposite == null) {
			context.getMetaModelManager().installPropertyDeclaration(pivotElement);
		}
		return null;
	}

	@Override
	public Continuation<?> visitTemplateBindingCS(TemplateBindingCS csTemplateBinding) {
		return null;
	}

	@Override
	public Continuation<?> visitTemplateParameterCS(TemplateParameterCS csTemplateParameter) {
		return null;
	}

	@Override
	public Continuation<?> visitTemplateParameterSubstitutionCS(TemplateParameterSubstitutionCS csTemplateParameterSubstitution) {
		return null;
	}
	
	@Override
	public Continuation<?> visitTemplateSignatureCS(TemplateSignatureCS csTemplateSignature) {
		return null;
	}

	@Override
	public Continuation<?> visitTuplePartCS(TuplePartCS object) {
		return null;
	}

	@Override
	public Continuation<?> visitTupleTypeCS(TupleTypeCS object) {
		return null;
	}

	@Override
	public BasicContinuation<?> visitTypedElementCS(TypedElementCS csTypedElement) {
		TypedElement pivotElement = PivotUtil.getPivot(TypedElement.class, csTypedElement);
		context.handleVisitNamedElement(csTypedElement, pivotElement);
		TypedRefCS ownedType = csTypedElement.getOwnedType();
		Type pivotType = ownedType != null ? PivotUtil.getPivot(Type.class, ownedType) : null;
		context.setType(pivotElement, pivotType);
		context.refreshPivotList(Constraint.class, pivotElement.getOwnedRule(), csTypedElement.getOwnedConstraint());
		return null;
	}

	@Override
	public Continuation<?> visitTypedTypeRefCS(TypedTypeRefCS object) {
		return null;
	}

	@Override
	public Continuation<?> visitWildcardTypeRefCS(WildcardTypeRefCS object) {
		return null;
	}
}