/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2pivot;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Detail;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.Model;
import org.eclipse.ocl.examples.pivot.MultiplicityElement;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.AnnotationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.AnnotationElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.CollectionTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DataTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DetailCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DocumentationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.EnumerationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.EnumerationLiteralCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.LambdaTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.LibraryCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MultiplicityBoundsCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MultiplicityStringCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.OperationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PrimitiveTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.RootPackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.StructuralFeatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateSignatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TuplePartCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TupleTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.base.util.AbstractExtendingBaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.util.VisitableCS;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseContainmentVisitor
extends AbstractExtendingBaseCSVisitor<Continuation<?>, CS2PivotConversion> {
    protected final MetaModelManager metaModelManager;

    public BaseContainmentVisitor(CS2PivotConversion context) {
        super(context);
        this.metaModelManager = context.getMetaModelManager();
    }

    protected void importPackages(RootPackageCS csElement) {
        for (LibraryCS csLibrary : csElement.getOwnedLibrary()) {
            csLibrary.getPackage();
        }
        for (ImportCS csImport : csElement.getOwnedImport()) {
            csImport.getNamespace();
        }
    }

    protected Type refreshClassifier(Type pivotElement, ClassifierCS csElement) {
        if (csElement.eIsSet((EStructuralFeature)BaseCSTPackage.Literals.CLASSIFIER_CS__INSTANCE_CLASS_NAME)) {
            pivotElement.setInstanceClassName(csElement.getInstanceClassName());
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.TYPE__INSTANCE_CLASS_NAME);
        }
        String newInstanceClassName = csElement.getInstanceClassName();
        String oldInstanceClassName = pivotElement.getInstanceClassName();
        if (!(newInstanceClassName == oldInstanceClassName || newInstanceClassName != null && newInstanceClassName.equals(oldInstanceClassName))) {
            pivotElement.setInstanceClassName(newInstanceClassName);
        }
        ((CS2PivotConversion)((Object)this.context)).refreshTemplateSignature(csElement, (TemplateableElement)pivotElement);
        return pivotElement;
    }

    protected <T> void refreshMultiplicity(MultiplicityElement pivotElement, TypedElementCS csTypedElement) {
        pivotElement.setIsOrdered(ElementUtil.isOrdered(csTypedElement));
        pivotElement.setIsUnique(ElementUtil.isUnique(csTypedElement));
        int lower = ElementUtil.getLower(csTypedElement);
        int upper = ElementUtil.getUpper(csTypedElement);
        pivotElement.setLower(BigInteger.valueOf(lower));
        pivotElement.setUpper(BigInteger.valueOf(upper));
    }

    protected <T extends NamedElement> T refreshNamedElement(Class<T> pivotClass, EClass pivotEClass, NamedElementCS csElement) {
        NamedElement pivotElement = (NamedElement)((CS2PivotConversion)((Object)this.context)).refreshModelElement(pivotClass, pivotEClass, csElement);
        ((CS2PivotConversion)((Object)this.context)).refreshName(pivotElement, csElement.getName());
        ((CS2PivotConversion)((Object)this.context)).refreshComments((Element)pivotElement, csElement);
        return (T)pivotElement;
    }

    protected <T extends Package> T refreshPackage(Class<T> pivotClass, EClass pivotEClass, PackageCS csElement) {
        String oldNsURI;
        String newNsURI;
        Package pivotElement;
        URI csURI;
        Resource csResource;
        String name;
        Element pivotObject = csElement.getPivot();
        if (pivotObject == null) {
            pivotObject = ((CS2PivotConversion)((Object)this.context)).getOldPackageByQualifiedName(csElement);
        }
        if ((name = csElement.getName()) == null && csElement.eContainer() == null && (csResource = csElement.eResource()) != null && (csURI = csResource.getURI()) != null) {
            name = csURI.lastSegment();
        }
        if (pivotObject == null) {
            pivotObject = ((CS2PivotConversion)((Object)this.context)).getOldPackageBySimpleName(name);
        }
        if (pivotObject == null) {
            pivotElement = this.metaModelManager.createPackage(pivotClass, pivotEClass, name, csElement.getNsURI());
            this.metaModelManager.installPackage(pivotElement);
        } else {
            Package pivotElement2;
            if (!pivotClass.isAssignableFrom(pivotObject.getClass())) {
                throw new ClassCastException();
            }
            pivotElement = pivotElement2 = (Package)pivotObject;
            ((CS2PivotConversion)((Object)this.context)).refreshName((NamedElement)pivotElement, name);
        }
        ((CS2PivotConversion)((Object)this.context)).converter.installPivotDefinition(csElement, (Element)pivotElement);
        ((CS2PivotConversion)((Object)this.context)).refreshComments((Element)pivotElement, csElement);
        String newNsPrefix = csElement.getNsPrefix();
        String oldNsPrefix = pivotElement.getNsPrefix();
        if (!(newNsPrefix == oldNsPrefix || newNsPrefix != null && newNsPrefix.equals(oldNsPrefix))) {
            pivotElement.setNsPrefix(newNsPrefix);
        }
        if (!((newNsURI = csElement.getNsURI()) == (oldNsURI = pivotElement.getNsURI()) || newNsURI != null && newNsURI.equals(oldNsURI))) {
            pivotElement.setNsURI(newNsURI);
        }
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Package.class, pivotElement.getNestedPackage(), (List<? extends ModelElementCS>)csElement.getOwnedNestedPackage());
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Type.class, pivotElement.getOwnedType(), (List<? extends ModelElementCS>)csElement.getOwnedType());
        return (T)pivotElement;
    }

    protected void refreshSerializable(DataType pivotElement, ClassifierCS csElement) {
        EList<String> qualifiers = csElement.getQualifier();
        pivotElement.setIsSerializable(qualifiers.contains("serializable"));
    }

    protected <T extends TypedMultiplicityElement> T refreshTypedMultiplicityElement(Class<T> pivotClass, EClass pivotEClass, TypedElementCS csTypedElement) {
        TypedMultiplicityElement pivotElement = (TypedMultiplicityElement)this.refreshNamedElement(pivotClass, pivotEClass, csTypedElement);
        this.refreshMultiplicity((MultiplicityElement)pivotElement, csTypedElement);
        return (T)pivotElement;
    }

    @Override
    public Continuation<?> visitAnnotationCS(AnnotationCS csElement) {
        this.refreshNamedElement(Annotation.class, PivotPackage.Literals.ANNOTATION, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitAnnotationElementCS(AnnotationElementCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitClassCS(ClassCS csElement) {
        org.eclipse.ocl.examples.pivot.Class pivotElement = this.refreshNamedElement(org.eclipse.ocl.examples.pivot.Class.class, PivotPackage.Literals.CLASS, csElement);
        EList<String> qualifiers = csElement.getQualifier();
        pivotElement.setIsAbstract(qualifiers.contains("abstract"));
        pivotElement.setIsInterface(qualifiers.contains("interface"));
        pivotElement.setIsStatic(qualifiers.contains("static"));
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Property.class, pivotElement.getOwnedAttribute(), (List<? extends ModelElementCS>)csElement.getOwnedProperty());
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Operation.class, pivotElement.getOwnedOperation(), (List<? extends ModelElementCS>)csElement.getOwnedOperation());
        this.refreshClassifier((Type)pivotElement, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitCollectionTypeRefCS(CollectionTypeRefCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitConstraintCS(ConstraintCS csElement) {
        this.refreshNamedElement(Constraint.class, PivotPackage.Literals.CONSTRAINT, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitDataTypeCS(DataTypeCS csElement) {
        DataType pivotElement = this.refreshNamedElement(DataType.class, PivotPackage.Literals.DATA_TYPE, csElement);
        this.refreshSerializable(pivotElement, csElement);
        this.refreshClassifier((Type)pivotElement, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitDetailCS(DetailCS csElement) {
        this.refreshNamedElement(Detail.class, PivotPackage.Literals.DETAIL, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitDocumentationCS(DocumentationCS csElement) {
        this.refreshNamedElement(Annotation.class, PivotPackage.Literals.ANNOTATION, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitElementCS(ElementCS csElement) {
        System.out.println("Unsupported " + csElement.eClass().getName() + " for CS2Pivot Containment pass");
        return null;
    }

    @Override
    public Continuation<?> visitElementRefCS(ElementRefCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitEnumerationCS(EnumerationCS csElement) {
        Enumeration pivotElement = this.refreshNamedElement(Enumeration.class, PivotPackage.Literals.ENUMERATION, csElement);
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(EnumerationLiteral.class, pivotElement.getOwnedLiteral(), (List<? extends ModelElementCS>)csElement.getOwnedLiterals());
        this.refreshSerializable((DataType)pivotElement, csElement);
        this.refreshClassifier((Type)pivotElement, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitEnumerationLiteralCS(EnumerationLiteralCS csElement) {
        EnumerationLiteral pivotElement = this.refreshNamedElement(EnumerationLiteral.class, PivotPackage.Literals.ENUMERATION_LITERAL, csElement);
        pivotElement.setValue(BigInteger.valueOf(csElement.getValue()));
        return null;
    }

    @Override
    public Continuation<?> visitImportCS(ImportCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitLambdaTypeCS(LambdaTypeCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitLibraryCS(LibraryCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitModelElementRefCS(ModelElementRefCS csElement) {
        CS2Pivot.setElementType(csElement.getPathName(), PivotPackage.Literals.ELEMENT, csElement, null);
        return null;
    }

    @Override
    public Continuation<?> visitMultiplicityBoundsCS(MultiplicityBoundsCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitMultiplicityStringCS(MultiplicityStringCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitOperationCS(OperationCS csElement) {
        Operation pivotElement = this.refreshTypedMultiplicityElement(Operation.class, PivotPackage.Literals.OPERATION, csElement);
        ((CS2PivotConversion)((Object)this.context)).refreshTemplateSignature(csElement, (TemplateableElement)pivotElement);
        ((CS2PivotConversion)((Object)this.context)).refreshPivotList(Parameter.class, pivotElement.getOwnedParameter(), (List<? extends ModelElementCS>)csElement.getOwnedParameter());
        return null;
    }

    @Override
    public Continuation<?> visitPackageCS(PackageCS csElement) {
        this.refreshPackage(Package.class, PivotPackage.Literals.PACKAGE, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitParameterCS(ParameterCS csElement) {
        this.refreshTypedMultiplicityElement(Parameter.class, PivotPackage.Literals.PARAMETER, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitPathElementCS(PathElementCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPathNameCS(PathNameCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPrimitiveTypeRefCS(PrimitiveTypeRefCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitRootPackageCS(RootPackageCS csElement) {
        this.importPackages(csElement);
        this.refreshPackage(Model.class, PivotPackage.Literals.MODEL, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitSpecificationCS(SpecificationCS csElement) {
        OpaqueExpression pivotElement = ((CS2PivotConversion)((Object)this.context)).refreshModelElement(OpaqueExpression.class, PivotPackage.Literals.OPAQUE_EXPRESSION, csElement);
        pivotElement.getLanguage().add((Object)"OCL");
        pivotElement.getBody().add((Object)csElement.getExprString());
        pivotElement.getMessage().add(null);
        return null;
    }

    @Override
    public Continuation<?> visitStructuralFeatureCS(StructuralFeatureCS csElement) {
        Property pivotElement = this.refreshTypedMultiplicityElement(Property.class, PivotPackage.Literals.PROPERTY, csElement);
        EList<String> qualifiers = csElement.getQualifier();
        pivotElement.setIsComposite(qualifiers.contains("composes"));
        pivotElement.setIsDerived(qualifiers.contains("derived"));
        pivotElement.setIsID(qualifiers.contains("id"));
        pivotElement.setIsReadOnly(qualifiers.contains("readonly"));
        pivotElement.setIsResolveProxies(ElementUtil.getQualifier(qualifiers, "resolve", "!resolve", true));
        pivotElement.setIsStatic(qualifiers.contains("static"));
        pivotElement.setIsTransient(qualifiers.contains("transient"));
        pivotElement.setIsUnsettable(qualifiers.contains("unsettable"));
        pivotElement.setIsVolatile(qualifiers.contains("volatile"));
        if (csElement.eIsSet((EStructuralFeature)BaseCSTPackage.Literals.STRUCTURAL_FEATURE_CS__DEFAULT)) {
            pivotElement.setDefault(csElement.getDefault());
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.PROPERTY__DEFAULT);
        }
        return null;
    }

    @Override
    public Continuation<?> visitTemplateBindingCS(TemplateBindingCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTemplateParameterCS(TemplateParameterCS csElement) {
        org.eclipse.ocl.examples.pivot.Class pivotElement = this.refreshNamedElement(org.eclipse.ocl.examples.pivot.Class.class, PivotPackage.Literals.CLASS, csElement);
        TemplateParameter pivotTemplateParameter = pivotElement.getOwningTemplateParameter();
        if (pivotTemplateParameter == null) {
            pivotTemplateParameter = PivotFactory.eINSTANCE.createTypeTemplateParameter();
            pivotTemplateParameter.setOwnedParameteredElement((ParameterableElement)pivotElement);
        }
        return null;
    }

    @Override
    public Continuation<?> visitTemplateParameterSubstitutionCS(TemplateParameterSubstitutionCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTemplateSignatureCS(TemplateSignatureCS csElement) {
        TemplateSignature pivotElement = ((CS2PivotConversion)((Object)this.context)).refreshModelElement(TemplateSignature.class, PivotPackage.Literals.TEMPLATE_SIGNATURE, csElement);
        ArrayList<TemplateParameter> newPivotTemplateParameters = new ArrayList<TemplateParameter>();
        EList<TemplateParameterCS> csTemplateParameters = csElement.getOwnedTemplateParameter();
        for (TemplateParameterCS csTemplateParameter : csTemplateParameters) {
            org.eclipse.ocl.examples.pivot.Class pivotTemplateParameterClass = (org.eclipse.ocl.examples.pivot.Class)PivotUtil.getPivot(org.eclipse.ocl.examples.pivot.Class.class, (Pivotable)csTemplateParameter);
            TemplateParameter pivotTemplateParameter = pivotTemplateParameterClass.getOwningTemplateParameter();
            newPivotTemplateParameters.add(pivotTemplateParameter);
        }
        PivotUtil.refreshList((List)pivotElement.getOwnedParameter(), newPivotTemplateParameters);
        return null;
    }

    @Override
    public Continuation<?> visitTuplePartCS(TuplePartCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTupleTypeCS(TupleTypeCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTypeRefCS(TypeRefCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTypedRefCS(TypedRefCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTypedTypeRefCS(TypedTypeRefCS csElement) {
        CS2Pivot.setElementType(csElement.getPathName(), PivotPackage.Literals.TYPE, csElement, null);
        return null;
    }

    @Override
    public Continuation<?> visitWildcardTypeRefCS(WildcardTypeRefCS csElement) {
        org.eclipse.ocl.examples.pivot.Class pivotElement = ((CS2PivotConversion)((Object)this.context)).refreshModelElement(org.eclipse.ocl.examples.pivot.Class.class, PivotPackage.Literals.CLASS, null);
        ((CS2PivotConversion)((Object)this.context)).installPivotReference(csElement, (Element)pivotElement, BaseCSTPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
        return null;
    }

    @Override
    public Continuation<?> visiting(VisitableCS visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for CS2Pivot Containment pass");
    }
}

