/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2pivot;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Dependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.ValidationDiagnostic;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2Moniker;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicContinuation<T>
implements Continuation<T> {
    static final Logger logger = Logger.getLogger(BasicContinuation.class);
    protected final CS2PivotConversion context;
    protected final Element pivotParent;
    protected final EStructuralFeature pivotFeature;
    protected final T csElement;
    protected final Dependency[] dependencies;

    public BasicContinuation(CS2PivotConversion context, Element pivotParent, EStructuralFeature pivotFeature, T csElement, Dependency ... dependencies) {
        this.context = context;
        this.pivotParent = pivotParent;
        this.pivotFeature = pivotFeature;
        this.csElement = csElement;
        Dependency[] dependencyArray = this.dependencies = dependencies != null ? dependencies : new Dependency[]{};
        assert (csElement != null);
    }

    public void addError(String message) {
        if (this.csElement instanceof ModelElementCS) {
            ModelElementCS csModelElement = (ModelElementCS)this.csElement;
            ICompositeNode node = NodeModelUtils.getNode((EObject)csModelElement);
            ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, message);
            csModelElement.eResource().getErrors().add((Object)resourceDiagnostic);
        } else {
            logger.error((Object)message);
        }
    }

    @Override
    public void addTo(List<BasicContinuation<?>> simpleContinuations) {
        simpleContinuations.add(this);
    }

    public boolean canExecute() {
        Dependency[] dependencyArray = this.dependencies;
        int n = this.dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            Dependency dependency = dependencyArray[n2];
            if (!dependency.canExecute()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public abstract BasicContinuation<?> execute();

    public Dependency[] getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName());
        s.append("@");
        s.append(Integer.toHexString(this.hashCode()));
        s.append(" : ");
        if (this.pivotParent != null) {
            s.append(this.pivotParent.eClass().getName());
        } else if (this.csElement instanceof EObject) {
            s.append(((EObject)this.csElement).eClass().getName());
        } else {
            s.append("???");
        }
        s.append(".");
        s.append(this.pivotFeature != null ? this.pivotFeature.getName() : "*");
        s.append(" : ");
        String elementName = null;
        if (this.csElement instanceof ModelElementCS) {
            ModelElementCS csModelElement = (ModelElementCS)this.csElement;
            elementName = CS2Moniker.toString(csModelElement);
        }
        if (elementName == null) {
            elementName = this.csElement.toString();
        }
        s.append(elementName);
        return s.toString();
    }
}

