/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.pivot2cs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTFactory;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CSConversion;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.BodyCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.ClassifierContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.CompleteOCLCSTPackage;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.CompleteOCLDocumentCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.ContextConstraintCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.ContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.ContextSpecificationCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.DerCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.InitCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.InvCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.OperationContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PackageDeclarationCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PathNameDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PostCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PreCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PropertyContextDeclCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.EssentialOCLCSTFactory;
import org.eclipse.ocl.examples.xtext.essentialocl.pivot2cs.EssentialOCLDeclarationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteOCLDeclarationVisitor
extends EssentialOCLDeclarationVisitor {
    public CompleteOCLDeclarationVisitor(Pivot2CSConversion context) {
        super(context);
    }

    protected TypedRefCS convertTypeRef(TypedMultiplicityElement object) {
        Type type = object.getType();
        if (type == null) {
            return null;
        }
        TypedRefCS typeRef = (TypedRefCS)((Pivot2CSConversion)this.context).visitReference(TypedRefCS.class, (EObject)type);
        int upper = object.getUpper().intValue();
        if (upper == 1) {
            return typeRef;
        }
        CollectionTypeCS collectionTypeCS = EssentialOCLCSTFactory.eINSTANCE.createCollectionTypeCS();
        collectionTypeCS.setOwnedType(typeRef);
        collectionTypeCS.setName(ElementUtil.getCollectionName((boolean)object.isOrdered(), (boolean)object.isUnique()));
        return collectionTypeCS;
    }

    protected void gatherPackages(List<Package> allPackages, List<Package> nestedPackages) {
        allPackages.addAll(nestedPackages);
        for (Package nestedPackage : nestedPackages) {
            this.gatherPackages(allPackages, (List<Package>)nestedPackage.getNestedPackage());
        }
    }

    protected void refreshPathNamedElement(PathNameDeclCS csDecl, NamedElement namedElement, EObject scope) {
        PathNameCS csPathName = csDecl.getPathName();
        if (csPathName == null) {
            csPathName = BaseCSTFactory.eINSTANCE.createPathNameCS();
            csDecl.setPathName(csPathName);
        }
        ((Pivot2CSConversion)this.context).refreshPathName(csPathName, (Element)namedElement, scope);
    }

    public ElementCS visitClass(Class object) {
        return this.visitType((Type)object);
    }

    public ElementCS visitConstraint(Constraint object) {
        String stereotype = object.getStereotype();
        ContextConstraintCS csElement = null;
        if ("body".equals(stereotype)) {
            csElement = (ContextConstraintCS)((Pivot2CSConversion)this.context).refreshNamedElement(BodyCS.class, CompleteOCLCSTPackage.Literals.BODY_CS, (NamedElement)object);
        } else if ("derivation".equals(stereotype)) {
            csElement = (ContextConstraintCS)((Pivot2CSConversion)this.context).refreshNamedElement(DerCS.class, CompleteOCLCSTPackage.Literals.DER_CS, (NamedElement)object);
        } else if ("initial".equals(stereotype)) {
            csElement = (ContextConstraintCS)((Pivot2CSConversion)this.context).refreshNamedElement(InitCS.class, CompleteOCLCSTPackage.Literals.INIT_CS, (NamedElement)object);
        } else if ("invariant".equals(stereotype)) {
            csElement = (ContextConstraintCS)((Pivot2CSConversion)this.context).refreshNamedElement(InvCS.class, CompleteOCLCSTPackage.Literals.INV_CS, (NamedElement)object);
        } else if ("postcondition".equals(stereotype)) {
            csElement = (ContextConstraintCS)((Pivot2CSConversion)this.context).refreshNamedElement(PostCS.class, CompleteOCLCSTPackage.Literals.POST_CS, (NamedElement)object);
        } else if ("precondition".equals(stereotype)) {
            csElement = (ContextConstraintCS)((Pivot2CSConversion)this.context).refreshNamedElement(PreCS.class, CompleteOCLCSTPackage.Literals.PRE_CS, (NamedElement)object);
        }
        if (csElement != null) {
            csElement.setStereotype(stereotype);
            Namespace namespace = PivotUtil.getNamespace((EObject)object);
            ValueSpecification specification = object.getSpecification();
            ContextSpecificationCS csSpec = (ContextSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ContextSpecificationCS.class, CompleteOCLCSTPackage.Literals.CONTEXT_SPECIFICATION_CS, (Element)specification);
            csElement.setSpecification((SpecificationCS)csSpec);
            if (specification instanceof OpaqueExpression) {
                MetaModelManager metaModelManager = ((Pivot2CSConversion)this.context).getMetaModelManager();
                PrettyPrintOptions.Global prettyPrintOptions = PrettyPrinter.createOptions((Namespace)((Namespace)metaModelManager.getPrimaryElement((EObject)namespace)));
                prettyPrintOptions.setMetaModelManager(metaModelManager);
                String expr = PrettyPrinter.print((Element)specification, (PrettyPrintOptions)prettyPrintOptions);
                csSpec.setExprString("\t" + expr.trim().replaceAll("\\r", "").replaceAll("\\n", "\n\t\t"));
                OpaqueExpression opaqueExpression = (OpaqueExpression)specification;
                String message = PivotUtil.getMessage((OpaqueExpression)opaqueExpression);
                if (message != null && message.length() > 0) {
                    ContextSpecificationCS csMessageElement = (ContextSpecificationCS)((Pivot2CSConversion)this.context).refreshElement(ContextSpecificationCS.class, CompleteOCLCSTPackage.Literals.CONTEXT_SPECIFICATION_CS, (Element)opaqueExpression);
                    csMessageElement.setExprString(message);
                    csElement.setMessageSpecification((SpecificationCS)csMessageElement);
                }
            }
        }
        return csElement;
    }

    public ElementCS visitOperation(Operation object) {
        Type modelType = object.getOwningType();
        Package modelPackage = modelType.getPackage();
        Class savedScope = ((Pivot2CSConversion)this.context).setScope((Class)modelType);
        OperationContextDeclCS csContext = (OperationContextDeclCS)((Pivot2CSConversion)this.context).refreshElement(OperationContextDeclCS.class, CompleteOCLCSTPackage.Literals.OPERATION_CONTEXT_DECL_CS, (Element)object);
        this.refreshPathNamedElement(csContext, (NamedElement)object, (EObject)modelPackage);
        csContext.setOwnedType(this.convertTypeRef((TypedMultiplicityElement)object));
        ((Pivot2CSConversion)this.context).importPackage(object.getOwningType().getPackage());
        ((Pivot2CSConversion)this.context).refreshList(csContext.getParameters(), ((Pivot2CSConversion)this.context).visitDeclarations(ParameterCS.class, (List)object.getOwnedParameter(), null));
        ((Pivot2CSConversion)this.context).refreshList(csContext.getRules(), ((Pivot2CSConversion)this.context).visitDeclarations(ContextConstraintCS.class, (List)object.getOwnedRule(), null));
        ((Pivot2CSConversion)this.context).setScope(savedScope);
        return csContext;
    }

    public ElementCS visitPackage(Package object) {
        Object csElement;
        if (object.eContainer() == null) {
            CompleteOCLDocumentCS csDocument = (CompleteOCLDocumentCS)((Pivot2CSConversion)this.context).refreshElement(CompleteOCLDocumentCS.class, CompleteOCLCSTPackage.Literals.COMPLETE_OCL_DOCUMENT_CS, (Element)object);
            ArrayList<Package> allPackages = new ArrayList<Package>();
            this.gatherPackages(allPackages, (List<Package>)object.getNestedPackage());
            ((Pivot2CSConversion)this.context).refreshList(csDocument.getPackages(), ((Pivot2CSConversion)this.context).visitDeclarations(PackageDeclarationCS.class, allPackages, null));
            csElement = csDocument;
        } else {
            PackageDeclarationCS csPackage = (PackageDeclarationCS)((Pivot2CSConversion)this.context).refreshElement(PackageDeclarationCS.class, CompleteOCLCSTPackage.Literals.PACKAGE_DECLARATION_CS, (Element)object);
            this.refreshPathNamedElement(csPackage, (NamedElement)object, EcoreUtil.getRootContainer((EObject)object));
            ((Pivot2CSConversion)this.context).importPackage(object);
            ArrayList<ContextDeclCS> contexts = new ArrayList<ContextDeclCS>();
            for (Type type : object.getOwnedType()) {
                ClassifierContextDeclCS classifierContext = (ClassifierContextDeclCS)((Pivot2CSConversion)this.context).visitDeclaration(ClassifierContextDeclCS.class, (EObject)type);
                if (classifierContext != null) {
                    contexts.add(classifierContext);
                }
                for (Operation operation : type.getOwnedOperation()) {
                    OperationContextDeclCS operationContext = (OperationContextDeclCS)((Pivot2CSConversion)this.context).visitDeclaration(OperationContextDeclCS.class, (EObject)operation);
                    if (operationContext == null) continue;
                    contexts.add(operationContext);
                }
                for (Property property : type.getOwnedAttribute()) {
                    PropertyContextDeclCS propertyContext = (PropertyContextDeclCS)((Pivot2CSConversion)this.context).visitDeclaration(PropertyContextDeclCS.class, (EObject)property);
                    if (propertyContext == null) continue;
                    contexts.add(propertyContext);
                }
            }
            ((Pivot2CSConversion)this.context).refreshList(csPackage.getContexts(), contexts);
            csElement = csPackage;
        }
        return csElement;
    }

    public ElementCS visitParameter(Parameter object) {
        ParameterCS csElement = (ParameterCS)((Pivot2CSConversion)this.context).refreshNamedElement(ParameterCS.class, BaseCSTPackage.Literals.PARAMETER_CS, (NamedElement)object);
        csElement.setOwnedType(this.convertTypeRef((TypedMultiplicityElement)object));
        return csElement;
    }

    public ElementCS visitProperty(Property object) {
        Type modelType = object.getOwningType();
        Package modelPackage = modelType.getPackage();
        Class savedScope = ((Pivot2CSConversion)this.context).setScope((Class)modelType);
        PropertyContextDeclCS csContext = (PropertyContextDeclCS)((Pivot2CSConversion)this.context).refreshElement(PropertyContextDeclCS.class, CompleteOCLCSTPackage.Literals.PROPERTY_CONTEXT_DECL_CS, (Element)object);
        this.refreshPathNamedElement(csContext, (NamedElement)object, (EObject)modelPackage);
        csContext.setOwnedType(this.convertTypeRef((TypedMultiplicityElement)object));
        ((Pivot2CSConversion)this.context).importPackage(modelPackage);
        ((Pivot2CSConversion)this.context).refreshList(csContext.getRules(), ((Pivot2CSConversion)this.context).visitDeclarations(ContextConstraintCS.class, (List)object.getOwnedRule(), null));
        ((Pivot2CSConversion)this.context).setScope(savedScope);
        return csContext;
    }

    public ElementCS visitType(Type object) {
        EList ownedRule = object.getOwnedRule();
        if (ownedRule.size() <= 0) {
            return null;
        }
        ClassifierContextDeclCS csContext = (ClassifierContextDeclCS)((Pivot2CSConversion)this.context).refreshElement(ClassifierContextDeclCS.class, CompleteOCLCSTPackage.Literals.CLASSIFIER_CONTEXT_DECL_CS, (Element)object);
        this.refreshPathNamedElement(csContext, (NamedElement)object, (EObject)object.getPackage());
        ((Pivot2CSConversion)this.context).importPackage(object.getPackage());
        ((Pivot2CSConversion)this.context).refreshList(csContext.getRules(), ((Pivot2CSConversion)this.context).visitDeclarations(ContextConstraintCS.class, (List)ownedRule, null));
        return csContext;
    }
}

