/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.contentassist.AbstractEssentialOCLProposalProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLProposalProvider
extends AbstractEssentialOCLProposalProvider {
    private static final int BOOST_EXPLICIT_PROPERTY = 20;
    private static final int BOOST_PARAMETER = 20;
    private static final int BOOST_VARIABLE = 20;
    private static final int BOOST_IMPLICIT_PROPERTY = 15;
    private static final int BOOST_OPERATION = 10;
    private static final int BOOST_ITERATION = 5;
    private static final int BOOST_TYPE = 0;
    private static final int BOOST_PACKAGE = -5;
    protected static Image collectionTypeImage = null;
    private static Image primitiveTypeImage = null;

    @Override
    public void complete_CollectionTypeIdentifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (collectionTypeImage == null) {
            collectionTypeImage = this.getImage((EObject)PivotFactory.eINSTANCE.createCollectionType());
        }
        this.proposeKeywordAlternatives(ruleCall, context, acceptor, collectionTypeImage);
        super.complete_CollectionTypeIdentifier(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_PrefixOperator(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeywordAlternatives(ruleCall, context, acceptor, null);
        super.complete_PrefixOperator(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_InfixOperator(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeywordAlternatives(ruleCall, context, acceptor, null);
        super.complete_InfixOperator(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_NavigationOperator(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeywordAlternatives(ruleCall, context, acceptor, null);
        super.complete_NavigationOperator(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_PrimitiveTypeIdentifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeKeywordAlternatives(ruleCall, context, acceptor, this.getPrimitiveTypeImage());
    }

    protected EObject getPathScope(EObject model, ContentAssistContext context) {
        int offset = context.getOffset();
        INode currentNode = context.getCurrentNode();
        ILeafNode offsetNode = NodeModelUtils.findLeafNodeAtOffset((INode)currentNode, (int)offset);
        EObject eObject = NodeModelUtils.findActualSemanticObjectFor((INode)offsetNode);
        if (!(eObject instanceof PathElementCS)) {
            offsetNode = NodeModelUtils.findLeafNodeAtOffset((INode)currentNode, (int)(offset - 1));
            eObject = NodeModelUtils.findActualSemanticObjectFor((INode)offsetNode);
        }
        if (eObject instanceof PathElementCS) {
            model = eObject;
        }
        return model;
    }

    protected Image getPrimitiveTypeImage() {
        if (primitiveTypeImage == null) {
            primitiveTypeImage = this.getImage((EObject)PivotFactory.eINSTANCE.createPrimitiveType());
        }
        return primitiveTypeImage;
    }

    protected int getPriorityBoost(EObject eObject) {
        if (eObject instanceof Property) {
            return ((Property)eObject).isImplicit() ? 15 : 20;
        }
        if (eObject instanceof Iteration) {
            return 5;
        }
        if (eObject instanceof Operation) {
            return 10;
        }
        if (eObject instanceof Type) {
            return 0;
        }
        if (eObject instanceof Parameter) {
            return 20;
        }
        if (eObject instanceof Variable) {
            return 20;
        }
        if (eObject instanceof Package) {
            return -5;
        }
        return 0;
    }

    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(String ruleName, ContentAssistContext contentAssistContext) {
        return new ClassSensitiveProposalCreator(contentAssistContext, ruleName, this.getQualifiedNameConverter());
    }

    protected void lookupCrossReference(CrossReference crossReference, EReference reference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        EObject currentModel = contentAssistContext.getCurrentModel();
        if (currentModel instanceof InfixExpCS) {
            ExpCS argument;
            EObject previousModel = contentAssistContext.getPreviousModel();
            if (previousModel instanceof NavigationOperatorCS && (argument = ((NavigationOperatorCS)previousModel).getArgument()) != null) {
                currentModel = argument;
            }
        } else if (currentModel instanceof PathNameCS) {
            currentModel = this.getPathScope(currentModel, contentAssistContext);
        }
        String ruleName = null;
        if (crossReference.getTerminal() instanceof RuleCall) {
            ruleName = ((RuleCall)crossReference.getTerminal()).getRule().getName();
        }
        this.lookupCrossReference(currentModel, reference, acceptor, filter, this.getProposalFactory(ruleName, contentAssistContext));
    }

    protected void proposeKeywordAlternatives(RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor, Image image) {
        AbstractElement alternatives = ruleCall.getRule().getAlternatives();
        if (alternatives instanceof Alternatives) {
            for (AbstractElement alternative : ((Alternatives)alternatives).getElements()) {
                if (!(alternative instanceof Keyword)) continue;
                Keyword keyword = (Keyword)alternative;
                String name = keyword.getValue();
                acceptor.accept(this.createCompletionProposal(name, name, image, context));
            }
        } else if (alternatives instanceof RuleCall) {
            this.proposeKeywordAlternatives((RuleCall)alternatives, context, acceptor, image);
        }
    }

    public class ClassSensitiveProposalCreator
    extends AbstractJavaBasedContentProposalProvider.DefaultProposalCreator {
        public ClassSensitiveProposalCreator(ContentAssistContext contentAssistContext, String ruleName, IQualifiedNameConverter qualifiedNameConverter) {
            super((AbstractJavaBasedContentProposalProvider)EssentialOCLProposalProvider.this, contentAssistContext, ruleName, qualifiedNameConverter);
        }

        public ICompletionProposal apply(IEObjectDescription candidate) {
            ICompletionProposal proposal = super.apply(candidate);
            EObject eObject = candidate.getEObjectOrProxy();
            if (proposal instanceof ConfigurableCompletionProposal && !eObject.eIsProxy()) {
                ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)proposal;
                int priority = configurableCompletionProposal.getPriority() + EssentialOCLProposalProvider.this.getPriorityBoost(eObject);
                configurableCompletionProposal.setPriority(priority);
            }
            return proposal;
        }
    }
}

