/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.util.Nameable;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TuplePartCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TupleTypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.labeling.BaseLabelProvider;

public class EssentialOCLLabelProvider
extends BaseLabelProvider {
    @Inject
    public EssentialOCLLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected void appendTemplateParameter(StringBuilder s, TemplateParameterCS templateParameter) {
        this.appendName(s, (NamedElementCS)templateParameter);
    }

    protected void appendType(StringBuilder s, Type type) {
        if (type instanceof CollectionTypeCS) {
            this.appendName(s, (Nameable)((CollectionTypeCS)type));
            s.append("(");
            this.appendType(s, (TypeRefCS)((CollectionTypeCS)type).getOwnedType());
            s.append(")");
        } else if (type instanceof TupleTypeCS) {
            this.appendName(s, (Nameable)((TupleTypeCS)type));
            s.append("Tuple(");
            String prefix = "";
            for (TuplePartCS part : ((TupleTypeCS)type).getOwnedParts()) {
                s.append(prefix);
                this.appendName(s, (NamedElementCS)part);
                s.append(" : ");
                this.appendType(s, (TypeRefCS)part.getOwnedType());
                prefix = ", ";
            }
            s.append(")");
        } else if (!(type instanceof NameExpCS)) {
            super.appendType(s, type);
        }
    }
}

