/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.utilities;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceAdapter;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.LibraryDiagnostic;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.Pivot2CS;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot.EssentialOCLCS2Pivot;
import org.eclipse.ocl.examples.xtext.essentialocl.pivot2cs.EssentialOCLPivot2CS;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.util.CancelIndicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLCSResource
extends LazyLinkingResource
implements BaseCSResource {
    private ParserContext parserContext;

    protected void addLibraryError(List<Resource.Diagnostic> errors, IllegalLibraryException e) {
        String message = e.getMessage();
        for (Resource.Diagnostic diagnostic : errors) {
            Exception exception;
            if (!(diagnostic instanceof LibraryDiagnostic) || !((exception = ((LibraryDiagnostic)diagnostic).getException()) instanceof IllegalLibraryException) || !message.equals(exception.getMessage())) continue;
            return;
        }
        errors.add((Resource.Diagnostic)new LibraryDiagnostic((Exception)((Object)e)));
    }

    public CS2Pivot createCS2Pivot(Map<? extends Resource, ? extends Resource> cs2pivotResourceMap, MetaModelManager metaModelManager) {
        return new EssentialOCLCS2Pivot(cs2pivotResourceMap, metaModelManager);
    }

    public Pivot2CS createPivot2CS(Map<? extends Resource, ? extends Resource> cs2pivotResourceMap, MetaModelManager metaModelManager) {
        return new EssentialOCLPivot2CS(cs2pivotResourceMap, metaModelManager);
    }

    public MetaModelManager createMetaModelManager() {
        ResourceSet resourceSet = this.getResourceSet();
        MetaModelManagerResourceSetAdapter resourceSetAdapter = MetaModelManagerResourceSetAdapter.findAdapter((ResourceSet)resourceSet);
        if (resourceSetAdapter != null) {
            return resourceSetAdapter.getMetaModelManager();
        }
        return new MetaModelManager();
    }

    protected void doLinking() {
        EList errors = this.getErrors();
        if (errors.size() > 0) {
            int i = errors.size();
            while (--i >= 0) {
                Resource.Diagnostic error = (Resource.Diagnostic)errors.get(i);
                if (!(error instanceof LibraryDiagnostic)) continue;
                errors.remove(i);
            }
        }
        super.doLinking();
    }

    public String getEditorName() {
        return "Essential OCL";
    }

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    public Resource getPivotResource(MetaModelManager metaModelManager) {
        CS2PivotResourceAdapter adapter = CS2PivotResourceAdapter.getAdapter((BaseCSResource)this, (MetaModelManager)metaModelManager);
        Resource pivotResource = adapter.getPivotResource((Resource)this);
        return pivotResource;
    }

    public URI resolve(URI uri) {
        URI csURI = this.getURI();
        if (csURI.isRelative()) {
            File csRelative = new File(csURI.toFileString());
            File csAbsolute = csRelative.getAbsoluteFile();
            csURI = URI.createFileURI((String)csAbsolute.toString());
        }
        return uri.resolve(csURI);
    }

    public void resolveLazyCrossReferences(CancelIndicator mon) {
        EList errors = this.getErrors();
        if (ElementUtil.hasSyntaxError((List)errors)) {
            return;
        }
        MetaModelManagerResourceAdapter adapter = MetaModelManagerResourceAdapter.findAdapter((Resource)this);
        if (adapter != null) {
            MetaModelManager metaModelManager = adapter.getMetaModelManager();
            if (metaModelManager != null) {
                try {
                    metaModelManager.getOclAnyType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getOclElementType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getOclVoidType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getOclInvalidType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getAnyClassifierType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getBooleanType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getRealType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getIntegerType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getUnlimitedNaturalType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getStringType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getCollectionType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getBagType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getSequenceType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getSetType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getOrderedSetType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getEnumerationType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getOclTupleType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
                try {
                    metaModelManager.getOclLambdaType();
                }
                catch (IllegalLibraryException e) {
                    this.addLibraryError((List<Resource.Diagnostic>)errors, e);
                }
            }
            super.resolveLazyCrossReferences(mon);
        }
    }

    public void setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    public void updateFrom(Resource pivotResource, MetaModelManager metaModelManager) {
        HashMap<EssentialOCLCSResource, Resource> cs2PivotResourceMap = new HashMap<EssentialOCLCSResource, Resource>();
        if (pivotResource != null) {
            cs2PivotResourceMap.put(this, pivotResource);
        }
        Pivot2CS pivot2cs = this.createPivot2CS(cs2PivotResourceMap, metaModelManager);
        pivot2cs.update();
    }
}

