/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sashwindows.di.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.core.sashwindows.di.AbstractPanel;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiFactory;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiPackage;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.PanelParent;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashModel;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashPanel;
import org.eclipse.papyrus.infra.core.sashwindows.di.TabFolder;
import org.eclipse.papyrus.infra.core.sashwindows.di.Window;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SashModelImpl
extends EObjectImpl
implements SashModel {
    protected EList<Window> windows;
    protected TabFolder currentSelection;

    protected SashModelImpl() {
    }

    protected EClass eStaticClass() {
        return DiPackage.Literals.SASH_MODEL;
    }

    @Override
    public EList<Window> getWindows() {
        if (this.windows == null) {
            this.windows = new EObjectContainmentEList(Window.class, (InternalEObject)this, 0);
        }
        return this.windows;
    }

    @Override
    public TabFolder getCurrentSelection() {
        if (this.currentSelection != null && this.currentSelection.eIsProxy()) {
            InternalEObject oldCurrentSelection = (InternalEObject)this.currentSelection;
            this.currentSelection = (TabFolder)this.eResolveProxy(oldCurrentSelection);
            if (this.currentSelection != oldCurrentSelection && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldCurrentSelection, (Object)this.currentSelection));
            }
        }
        return this.currentSelection;
    }

    public TabFolder basicGetCurrentSelection() {
        return this.currentSelection;
    }

    @Override
    public void setCurrentSelection(TabFolder newCurrentSelection) {
        TabFolder oldCurrentSelection = this.currentSelection;
        this.currentSelection = newCurrentSelection;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldCurrentSelection, (Object)this.currentSelection));
        }
    }

    @Override
    public void addPage(Object pageIdentifier) {
        this.getCurrentSelection().addPage(pageIdentifier);
    }

    @Override
    public void removePage(Object pageIdentifier) {
        PageRef pageRef = this.lookupPage(pageIdentifier);
        if (pageRef == null) {
            return;
        }
        TabFolder folder = pageRef.getParent();
        folder.getChildren().remove((Object)pageRef);
    }

    @Override
    public void removePageAndEmptyFolder(Object pageIdentifier) {
        PageRef pageRef = this.lookupPage(pageIdentifier);
        if (pageRef == null) {
            return;
        }
        TabFolder folder = pageRef.getParent();
        folder.getChildren().remove((Object)pageRef);
        this.removeEmptyFolder(folder);
    }

    @Override
    public PageRef lookupPage(final Object pageIdentifier) {
        DiSwitch<PageRef> visitor = new DiSwitch<PageRef>(){

            @Override
            public PageRef caseSashModel(SashModel object) {
                PageRef res = null;
                for (Window window : object.getWindows()) {
                    res = (PageRef)this.doSwitch(window);
                    if (res == null) continue;
                    return res;
                }
                return (PageRef)super.caseSashModel(object);
            }

            @Override
            public PageRef caseWindow(Window window) {
                AbstractPanel panel = window.getPanel();
                if (panel == null) {
                    return null;
                }
                PageRef res = (PageRef)this.doSwitch(panel);
                if (res != null) {
                    return res;
                }
                return (PageRef)super.caseWindow(window);
            }

            @Override
            public PageRef caseSashPanel(SashPanel object) {
                PageRef res = null;
                for (AbstractPanel panel : object.getChildren()) {
                    res = (PageRef)this.doSwitch(panel);
                    if (res == null) continue;
                    return res;
                }
                return (PageRef)super.caseSashPanel(object);
            }

            @Override
            public PageRef caseTabFolder(TabFolder object) {
                for (PageRef pageRef : object.getChildren()) {
                    if (!pageRef.isForIdentifier(pageIdentifier)) continue;
                    return pageRef;
                }
                return (PageRef)super.caseTabFolder(object);
            }
        };
        PageRef res = (PageRef)visitor.doSwitch(this);
        return res;
    }

    @Override
    public TabFolder lookupFirstFolder() {
        DiSwitch<TabFolder> visitor = new DiSwitch<TabFolder>(){

            @Override
            public TabFolder caseSashModel(SashModel object) {
                TabFolder res = null;
                for (Window window : object.getWindows()) {
                    res = (TabFolder)this.doSwitch(window);
                    if (res == null) continue;
                    return res;
                }
                return (TabFolder)super.caseSashModel(object);
            }

            @Override
            public TabFolder caseWindow(Window window) {
                AbstractPanel panel = window.getPanel();
                if (panel == null) {
                    return null;
                }
                TabFolder res = (TabFolder)this.doSwitch(panel);
                if (res != null) {
                    return res;
                }
                return (TabFolder)super.caseWindow(window);
            }

            @Override
            public TabFolder caseSashPanel(SashPanel object) {
                TabFolder res = null;
                for (AbstractPanel panel : object.getChildren()) {
                    res = (TabFolder)this.doSwitch(panel);
                    if (res == null) continue;
                    return res;
                }
                return (TabFolder)super.caseSashPanel(object);
            }

            @Override
            public TabFolder caseTabFolder(TabFolder object) {
                return object;
            }
        };
        TabFolder res = (TabFolder)visitor.doSwitch(this);
        return res;
    }

    @Override
    public Window lookupFirstWindow() {
        EList<Window> list = this.getWindows();
        if (list.size() == 0) {
            return null;
        }
        return (Window)list.get(0);
    }

    @Override
    public void movePage(TabFolder srcParentFolder, int srcIndex, TabFolder targetParentFolder, int targetIndex) {
        if (srcIndex == -1) {
            EList<PageRef> srcChildrens = srcParentFolder.getChildren();
            EList<PageRef> targetChildrens = targetParentFolder.getChildren();
            while (srcChildrens.size() > 0) {
                PageRef pageRef = (PageRef)srcChildrens.remove(0);
                targetChildrens.add(pageRef);
            }
            return;
        }
        PageRef pageRef = (PageRef)srcParentFolder.getChildren().remove(srcIndex);
        EList<PageRef> targetChildrens = targetParentFolder.getChildren();
        if (targetIndex < 0 || targetIndex > targetChildrens.size()) {
            targetChildrens.add(pageRef);
        } else {
            targetChildrens.add(targetIndex, pageRef);
        }
    }

    @Override
    public void insertFolder(TabFolder folderToInsert, TabFolder refFolder, int side) {
        PanelParent refParent = refFolder.getParent();
        int direction = side == 16384 || side == 131072 ? 256 : 512;
        SashPanel newSash = DiFactory.eINSTANCE.createSashPanel();
        refParent.replaceChild(refFolder, newSash);
        if (side == 16384 || side == 128) {
            newSash.setChildren(folderToInsert, refFolder, direction);
        } else {
            newSash.setChildren(refFolder, folderToInsert, direction);
        }
    }

    @Override
    public void movePage(TabFolder srcParentFolder, int srcIndex, TabFolder targetParentFolder) {
        PageRef pageRef = (PageRef)srcParentFolder.getChildren().remove(srcIndex);
        EList<PageRef> targetChildrens = targetParentFolder.getChildren();
        targetChildrens.add(pageRef);
    }

    @Override
    public void removeEmptyFolder(TabFolder folder) {
        EList<PageRef> children = folder.getChildren();
        if (children.size() > 0) {
            return;
        }
        PanelParent parent = folder.getParent();
        if (parent instanceof Window) {
            return;
        }
        ((SashPanel)parent).delete(folder);
        if (this.getCurrentSelection() == folder) {
            this.setCurrentSelection(this.lookupFirstFolder());
        }
    }

    @Override
    public void removeAllPages() {
        Window firstWindow = this.lookupFirstWindow();
        TabFolder folder = this.lookupFirstFolder();
        folder.getChildren().clear();
        firstWindow.setPanel(folder);
    }

    @Override
    public void removeOtherPages(Object pageIdentifier) {
        Window firstWindow = this.lookupFirstWindow();
        TabFolder folder = this.lookupFirstFolder();
        PageRef page = this.lookupPage(pageIdentifier);
        folder.getChildren().clear();
        if (page != null) {
            folder.getChildren().add((Object)page);
        }
        firstWindow.setPanel(folder);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getWindows()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getWindows();
            }
            case 1: {
                if (resolve) {
                    return this.getCurrentSelection();
                }
                return this.basicGetCurrentSelection();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getWindows().clear();
                this.getWindows().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setCurrentSelection((TabFolder)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getWindows().clear();
                return;
            }
            case 1: {
                this.setCurrentSelection(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.windows != null && !this.windows.isEmpty();
            }
            case 1: {
                return this.currentSelection != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

